/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.filter.annotations.FilterConfig;
import br.com.fiorilli.filter.annotations.FilterConfigSelect;
import br.com.fiorilli.filter.model.FilterCondition;
import br.com.fiorilli.filter.model.FilterInputType;
import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.Banco;
import br.com.fiorilli.sip.persistence.entity.BeneficiarioPensaoAlimenticiaPK;
import br.com.fiorilli.sip.persistence.entity.Convenio;
import br.com.fiorilli.sip.persistence.entity.Endereco;
import br.com.fiorilli.sip.persistence.entity.Evento;
import br.com.fiorilli.sip.persistence.entity.Parentesco;
import br.com.fiorilli.sip.persistence.entity.Trabalhador;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.Size;

@Entity
@Table(name="BENEFPENSAOALIM")
@Audited
public class BeneficiarioPensaoAlimenticia
implements Serializable {
    public static final String FIND_BY_TRABALHADOR = "SELECT b FROM BeneficiarioPensaoAlimenticia b JOIN FETCH b.trabalhador JOIN FETCH b.evento LEFT JOIN FETCH b.outroBanco LEFT JOIN FETCH b.convenios co LEFT JOIN FETCH co.banco WHERE b.trabalhador.trabalhadorPK = :trabalhadorPK";
    public static final String GET_NEXT_ITEM = "SELECT coalesce(max(b.beneficiarioPensaoAlimenticiaPK.item), 0) + 1 FROM BeneficiarioPensaoAlimenticia b WHERE b.trabalhador.trabalhadorPK = :trabalhadorPK";
    private static final long serialVersionUID = 1L;
    @EmbeddedId
    protected BeneficiarioPensaoAlimenticiaPK beneficiarioPensaoAlimenticiaPK;
    @FilterConfig(label="Nome do Benefici\u00e1rio", condition=FilterCondition.COMECE)
    @Size(max=60)
    @Column(name="NOME")
    private String nome;
    @Size(max=2)
    @Column(name="TIPO")
    private String tipo;
    @Size(max=12)
    @Column(name="CONTA")
    private String conta;
    @Column(name="DVCONTA")
    private String dvconta;
    @Size(max=6)
    @Column(name="AGENCIA")
    private String agencia;
    @Column(name="DVAGENCIA")
    private String dvagencia;
    @Size(max=11)
    @Column(name="CPF")
    private String cpf;
    @Size(max=11)
    @Column(name="CPF_RESPONSAVEL")
    private String cpfResponsavel;
    @Size(max=60)
    @Column(name="NOME_RESPONSAVEL")
    private String nomeResponsavel;
    @Size(max=1)
    @Column(name="FORMA_CREDITO")
    private String formaCredito;
    @Embedded
    private Endereco endereco;
    @Column(name="ID_CADUNICO")
    private Double idCadunico;
    @Column(name="DTINICIO")
    @Temporal(value=TemporalType.DATE)
    private Date dtinicio;
    @Column(name="DTTERMINO")
    @Temporal(value=TemporalType.DATE)
    private Date dttermino;
    @Column(name="DTNASCIMENTO")
    @Temporal(value=TemporalType.DATE)
    private Date dataNascimento;
    @Column(name="PARENTESCO")
    private String parentesco;
    @FilterConfig(label="Trabalhador", inputType=FilterInputType.AUTO_COMPLETE)
    @FilterConfigSelect(query="SELECT t FROM Trabalhador t WHERE concat(t.matricula, t.trabalhadorPK.registro, lower(t.nome)) LIKE lower('%'||:param||'%') AND t.situacao = '1' AND t.trabalhadorPK.entidade = :entidadeCodigo")
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="REGISTRO", referencedColumnName="REGISTRO", insertable=false, updatable=false)})
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private Trabalhador trabalhador;
    @Column(name="EVENTO")
    private String eventoCodigo;
    @FilterConfig(label="Evento", inputType=FilterInputType.AUTO_COMPLETE)
    @FilterConfigSelect(query="SELECT e FROM Evento e WHERE UPPER(concat(e.eventoPK.codigo, e.nome)) LIKE UPPER(concat('%', :param, '%')) AND e.eventoPK.entidade = :entidadeCodigo ORDER BY e.nome")
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="EVENTO", referencedColumnName="CODIGO", insertable=false, updatable=false)})
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private Evento evento;
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="BANCO", referencedColumnName="BANCO", insertable=false, updatable=false), @JoinColumn(name="ITEMAGENCIA", referencedColumnName="ITEMAGENCIA", insertable=false, updatable=false), @JoinColumn(name="ITEMCONTA", referencedColumnName="ITEMCONTA", insertable=false, updatable=false), @JoinColumn(name="ITEMCONVENIO", referencedColumnName="ITEM", insertable=false, updatable=false)})
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private Convenio convenios;
    @Basic(optional=false)
    @Size(min=1, max=3)
    @Column(name="BANCO")
    private String bancoCodigo;
    @Basic(optional=false)
    @Column(name="ITEMAGENCIA")
    private Short agenciaItem;
    @Basic(optional=false)
    @Column(name="ITEMCONTA")
    private Short contaItem;
    @Basic(optional=false)
    @Column(name="ITEMCONVENIO")
    private Short convenioItem;
    @Column(name="OUTRO_BANCO", insertable=false, updatable=false)
    private String outroBancoCodigo;
    @JoinColumn(name="OUTRO_BANCO", referencedColumnName="CODIGO")
    @ManyToOne(fetch=FetchType.LAZY)
    private Banco outroBanco;

    public BeneficiarioPensaoAlimenticia() {
    }

    public BeneficiarioPensaoAlimenticia(BeneficiarioPensaoAlimenticiaPK benefpensaoalimPK) {
        this.beneficiarioPensaoAlimenticiaPK = benefpensaoalimPK;
    }

    public BeneficiarioPensaoAlimenticia(String entidade, String registro, short item) {
        this.beneficiarioPensaoAlimenticiaPK = new BeneficiarioPensaoAlimenticiaPK(entidade, registro, item);
    }

    public BeneficiarioPensaoAlimenticiaPK getBeneficiarioPensaoAlimenticiaPK() {
        return this.beneficiarioPensaoAlimenticiaPK;
    }

    public void setBeneficiarioPensaoAlimenticiaPK(BeneficiarioPensaoAlimenticiaPK benefpensaoalimPK) {
        this.beneficiarioPensaoAlimenticiaPK = benefpensaoalimPK;
    }

    public String getNome() {
        return this.nome;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public String getTipo() {
        return this.tipo;
    }

    public void setTipo(String tipo) {
        this.tipo = tipo;
    }

    public String getConta() {
        return this.conta;
    }

    public void setConta(String conta) {
        this.conta = conta;
    }

    public String getDvconta() {
        return this.dvconta;
    }

    public void setDvconta(String dvconta) {
        this.dvconta = dvconta;
    }

    public String getAgencia() {
        return this.agencia;
    }

    public void setAgencia(String agencia) {
        this.agencia = agencia;
    }

    public String getDvagencia() {
        return this.dvagencia;
    }

    public void setDvagencia(String dvagencia) {
        this.dvagencia = dvagencia;
    }

    public String getCpf() {
        return this.cpf;
    }

    public void setCpf(String cpf) {
        this.cpf = cpf;
    }

    public String getFormaCredito() {
        return this.formaCredito;
    }

    public void setFormaCredito(String formaCredito) {
        this.formaCredito = formaCredito;
    }

    public Endereco getEndereco() {
        if (this.endereco == null) {
            this.endereco = new Endereco();
        }
        return this.endereco;
    }

    public void setEndereco(Endereco endereco) {
        this.endereco = endereco;
    }

    public Double getIdCadunico() {
        return this.idCadunico;
    }

    public void setIdCadunico(Double idCadunico) {
        this.idCadunico = idCadunico;
    }

    public Date getDtinicio() {
        return this.dtinicio;
    }

    public void setDtinicio(Date dtinicio) {
        this.dtinicio = dtinicio;
    }

    public Date getDttermino() {
        return this.dttermino;
    }

    public void setDttermino(Date dttermino) {
        this.dttermino = dttermino;
    }

    public Trabalhador getTrabalhador() {
        return this.trabalhador;
    }

    public void setTrabalhador(Trabalhador trabalhador) {
        this.trabalhador = trabalhador;
        if (trabalhador != null) {
            this.beneficiarioPensaoAlimenticiaPK.setEntidade(trabalhador.getTrabalhadorPK().getEntidade());
            this.beneficiarioPensaoAlimenticiaPK.setRegistro(trabalhador.getTrabalhadorPK().getRegistro());
        } else {
            this.beneficiarioPensaoAlimenticiaPK.setEntidade(null);
            this.beneficiarioPensaoAlimenticiaPK.setRegistro(null);
        }
    }

    public Evento getEvento() {
        return this.evento;
    }

    public void setEvento(Evento eventos) {
        this.evento = eventos;
        this.eventoCodigo = this.evento != null ? this.evento.getEventoPK().getCodigo() : null;
    }

    public Convenio getConvenios() {
        return this.convenios;
    }

    public void setConvenios(Convenio convenios) {
        this.convenios = convenios;
        if (convenios != null) {
            this.setBancoCodigo(convenios.getCodigoBanco());
            this.setAgenciaItem(convenios.getConvenioPK().getItemAgencia());
            this.setContaItem(convenios.getConvenioPK().getItemConta());
            this.setConvenioItem(convenios.getConvenioPK().getItem());
        } else {
            this.setBancoCodigo(null);
            this.setAgenciaItem(null);
            this.setContaItem(null);
            this.setConvenioItem(null);
        }
    }

    public Banco getOutroBanco() {
        return this.outroBanco;
    }

    public void setOutroBanco(Banco outroBanco) {
        this.outroBanco = outroBanco;
        this.outroBancoCodigo = outroBanco != null ? outroBanco.getCodigo() : null;
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.beneficiarioPensaoAlimenticiaPK != null ? this.beneficiarioPensaoAlimenticiaPK.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof BeneficiarioPensaoAlimenticia)) {
            return false;
        }
        BeneficiarioPensaoAlimenticia other = (BeneficiarioPensaoAlimenticia)object;
        return (this.beneficiarioPensaoAlimenticiaPK != null || other.beneficiarioPensaoAlimenticiaPK == null) && (this.beneficiarioPensaoAlimenticiaPK == null || this.beneficiarioPensaoAlimenticiaPK.equals(other.beneficiarioPensaoAlimenticiaPK));
    }

    public String toString() {
        return "entity.Benefpensaoalim[ benefpensaoalimPK=" + this.beneficiarioPensaoAlimenticiaPK + " ]";
    }

    public Date getDataNascimento() {
        return this.dataNascimento;
    }

    public void setDataNascimento(Date dataNascimento) {
        this.dataNascimento = dataNascimento;
    }

    public String getEventoCodigo() {
        return this.eventoCodigo;
    }

    public void setEventoCodigo(String eventoCodigo) {
        this.eventoCodigo = eventoCodigo;
    }

    public String getBancoCodigo() {
        return this.bancoCodigo;
    }

    public void setBancoCodigo(String bancoCodigo) {
        this.bancoCodigo = bancoCodigo;
    }

    public Short getAgenciaItem() {
        return this.agenciaItem;
    }

    public void setAgenciaItem(Short agenciaItem) {
        this.agenciaItem = agenciaItem;
    }

    public Short getContaItem() {
        return this.contaItem;
    }

    public void setContaItem(Short contaItem) {
        this.contaItem = contaItem;
    }

    public Short getConvenioItem() {
        return this.convenioItem;
    }

    public void setConvenioItem(Short convenioItem) {
        this.convenioItem = convenioItem;
    }

    public String getOutroBancoCodigo() {
        return this.outroBancoCodigo;
    }

    public void setOutroBancoCodigo(String outroBancoCodigo) {
        this.outroBancoCodigo = outroBancoCodigo;
    }

    public String getCpfResponsavel() {
        return this.cpfResponsavel;
    }

    public void setCpfResponsavel(String cpfResponsavel) {
        this.cpfResponsavel = cpfResponsavel;
    }

    public String getNomeResponsavel() {
        return this.nomeResponsavel;
    }

    public void setNomeResponsavel(String nomeResponsavel) {
        this.nomeResponsavel = nomeResponsavel;
    }

    public Parentesco getParentesco() {
        return Parentesco.of(this.parentesco);
    }

    public void setParentesco(Parentesco parentesco) {
        this.parentesco = parentesco.getCodigo();
    }
}

