/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.filter.annotations.FilterConfig;
import br.com.fiorilli.filter.annotations.FilterConfigEnum;
import br.com.fiorilli.filter.annotations.FilterConfigType;
import br.com.fiorilli.filter.model.FilterCondition;
import br.com.fiorilli.filter.model.FilterInputType;
import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.BancoHoraMovimento;
import br.com.fiorilli.sip.persistence.entity.BancoHorasLancamento;
import br.com.fiorilli.sip.persistence.entity.Entidade;
import br.com.fiorilli.sip.persistence.entity.PagamentoBancoHoras;
import br.com.fiorilli.sip.persistence.entity.PontoEvento;
import br.com.fiorilli.sip.persistence.entity.TipoLimiteHoraExtra;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@FilterConfigType(autoFilter=true)
@Entity
@Table(name="SIPBH_PARAMETROS")
@Audited
public class BancoHorasParametros
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String GET_BY_DATA = "SELECT b FROM BancoHorasParametros b WHERE b.entidadeCodigo = :entidadeCodigo AND :data BETWEEN b.dataVigenciaInicio AND COALESCE(b.dataVigenciaTermino, CURRENT_DATE) ORDER BY b.codigo DESC";
    public static final String GENERATOR = "GEN_SIPBHPARAMETROS";
    @Id
    @Basic(optional=false)
    @NotNull
    @Column(name="CODIGO")
    @FilterConfig(label="C\u00f3digo", inputType=FilterInputType.NUMBER)
    private Integer codigo;
    @Column(name="VIGENCIADATAINICIO")
    @Temporal(value=TemporalType.DATE)
    @FilterConfig(label="In\u00edcio da Vig\u00eancia", inputType=FilterInputType.CALENDAR, condition=FilterCondition.INTERVALO)
    private Date dataVigenciaInicio;
    @Column(name="VIGENCIADATATERMINO")
    @Temporal(value=TemporalType.DATE)
    @FilterConfig(label="Fim da Vig\u00eancia", inputType=FilterInputType.CALENDAR, condition=FilterCondition.INTERVALO)
    private Date dataVigenciaTermino;
    @FilterConfig(label="Tipo de Limite das Horas Extras", inputType=FilterInputType.SELECT_ONE_MENU)
    @FilterConfigEnum(enumClass=TipoLimiteHoraExtra.class, enumId="codigo", itemLabel="descricao")
    @Column(name="LIMITEHORASEXTRASTIPO")
    private Character tipoLimiteHorasExtras;
    @Column(name="LIMITEHORASEXTRASQTDE")
    private Short quantidadeLimiteHorasExtras;
    @Type(type="BooleanTypeSip")
    @Column(name="PERMITIRAUMENTARGOZOFERIAS")
    private Boolean permitirAumentarGozoFerias;
    @Type(type="BooleanTypeSip")
    @Column(name="DESCONTARHORASFOLGANARESCISAO")
    private Boolean descontarHorasFolgaRescisao;
    @Column(name="PORCENTAGEMARMAZENAMENTO")
    private Double porcentagemarmazenamento;
    @Type(type="BooleanTypeSip")
    @Column(name="CONTROLARSALDOPORHORAREAL")
    private Boolean controlarSaldoPorHoraReal;
    @Column(name="EMPRESA")
    private String entidadeCodigo;
    @Column(name="MESES_DE_VALIDADE")
    private Integer mesesDeValidade;
    @JoinColumn(name="EMPRESA", referencedColumnName="CODIGO", insertable=false, updatable=false)
    @ManyToOne(fetch=FetchType.LAZY)
    private Entidade entidade;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="sipbhParametros", fetch=FetchType.LAZY)
    private List<BancoHoraMovimento> sipbhSaldoList;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="sipbhParametros", fetch=FetchType.LAZY)
    private List<BancoHorasLancamento> bancoHorasLancamentos;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="bancoHorasVigencia", fetch=FetchType.LAZY)
    private List<PontoEvento> pontoEventos;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="bancoHorasParametros", fetch=FetchType.LAZY)
    private List<PagamentoBancoHoras> bancoHorasPagamentos;

    public BancoHorasParametros() {
    }

    public BancoHorasParametros(Integer codigo) {
        this.codigo = codigo;
    }

    public Integer getCodigo() {
        return this.codigo;
    }

    public void setCodigo(Integer codigo) {
        this.codigo = codigo;
    }

    public Date getDataVigenciaInicio() {
        return this.dataVigenciaInicio;
    }

    public void setDataVigenciaInicio(Date vigenciadatainicio) {
        this.dataVigenciaInicio = vigenciadatainicio;
    }

    public Date getDataVigenciaTermino() {
        return this.dataVigenciaTermino;
    }

    public void setDataVigenciaTermino(Date vigenciadatatermino) {
        this.dataVigenciaTermino = vigenciadatatermino;
    }

    public TipoLimiteHoraExtra getLimiteHorasExtrasTipo() {
        return TipoLimiteHoraExtra.get(this.tipoLimiteHorasExtras);
    }

    public void setLimiteHorasExtrasTipo(TipoLimiteHoraExtra limitehorasextrastipo) {
        this.tipoLimiteHorasExtras = limitehorasextrastipo != null ? limitehorasextrastipo.getCodigo() : null;
    }

    public Short getQuantidadeLimiteHorasExtras() {
        return this.quantidadeLimiteHorasExtras;
    }

    public void setQuantidadeLimiteHorasExtras(Short limitehorasextrasqtde) {
        this.quantidadeLimiteHorasExtras = limitehorasextrasqtde;
    }

    public Boolean getPermitirAumentarGozoFerias() {
        return this.permitirAumentarGozoFerias;
    }

    public void setPermitirAumentarGozoFerias(Boolean permitirAumentarGozoFerias) {
        this.permitirAumentarGozoFerias = permitirAumentarGozoFerias;
    }

    public Boolean getDescontarHorasFolgaRescisao() {
        return this.descontarHorasFolgaRescisao;
    }

    public void setDescontarHorasFolgaRescisao(Boolean descontarHorasFolgaRescisao) {
        this.descontarHorasFolgaRescisao = descontarHorasFolgaRescisao;
    }

    public Boolean getControlarSaldoPorHoraReal() {
        return this.controlarSaldoPorHoraReal;
    }

    public void setControlarSaldoPorHoraReal(Boolean controlarSaldoPorHoraReal) {
        this.controlarSaldoPorHoraReal = controlarSaldoPorHoraReal;
    }

    public Double getPorcentagemarmazenamento() {
        return this.porcentagemarmazenamento;
    }

    public void setPorcentagemarmazenamento(Double porcentagemarmazenamento) {
        this.porcentagemarmazenamento = porcentagemarmazenamento;
    }

    public Entidade getEntidade() {
        return this.entidade;
    }

    public void setEntidade(Entidade entidade) {
        this.entidade = entidade;
    }

    public List<BancoHoraMovimento> getSipbhSaldoList() {
        return this.sipbhSaldoList;
    }

    public void setSipbhSaldoList(List<BancoHoraMovimento> sipbhSaldoList) {
        this.sipbhSaldoList = sipbhSaldoList;
    }

    public List<BancoHorasLancamento> getBancoHorasLancamentos() {
        return this.bancoHorasLancamentos;
    }

    public void setBancoHorasLancamentos(List<BancoHorasLancamento> bancoHorasLancamentos) {
        this.bancoHorasLancamentos = bancoHorasLancamentos;
    }

    public List<PontoEvento> getPontoEventos() {
        return this.pontoEventos;
    }

    public void setPontoEventos(List<PontoEvento> pontoEventos) {
        this.pontoEventos = pontoEventos;
    }

    public String getEntidadeCodigo() {
        return this.entidadeCodigo;
    }

    public void setEntidadeCodigo(String entidadeCodigo) {
        this.entidadeCodigo = entidadeCodigo;
    }

    public static BancoHorasParametros newBlank() {
        BancoHorasParametros blank = new BancoHorasParametros();
        blank.dataVigenciaInicio = new Date(0L);
        blank.dataVigenciaTermino = new Date(0L);
        return blank;
    }

    public Integer getMesesDeValidade() {
        return this.mesesDeValidade;
    }

    public void setMesesDeValidade(Integer mesesDeValidade) {
        this.mesesDeValidade = mesesDeValidade;
    }

    public List<PagamentoBancoHoras> getBancoHorasPagamentos() {
        return this.bancoHorasPagamentos;
    }

    public void setBancoHorasPagamentos(List<PagamentoBancoHoras> bancoHorasPagamentos) {
        this.bancoHorasPagamentos = bancoHorasPagamentos;
    }

    public String toString() {
        return "BancoHorasParametros [codigo=" + this.codigo + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.codigo;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BancoHorasParametros other = (BancoHorasParametros)obj;
        return this.codigo == other.codigo;
    }
}

