/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.BancoHorasParametros;
import br.com.fiorilli.sip.persistence.entity.Evento;
import br.com.fiorilli.sip.persistence.entity.Trabalhador;
import br.com.fiorilli.sip.persistence.enums.ponto.BancoHorasLancamentoOrigem;
import br.com.fiorilli.sip.persistence.vo.cartaoponto.autorizacaoHoraExtra.PontoEventoVO;
import br.com.fiorilli.sip.persistence.vo.cartaoponto.autorizacaoHoraExtra.TrabalhadorVO;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.hibernate.annotations.Type;

@Audited
@Entity
@Table(name="SIPBH_SALDO_LANCAMENTO")
public class BancoHorasLancamento
implements Serializable {
    public static final String QUERY_BY_SUBKEY = "SELECT l FROM BancoHorasLancamento l WHERE l.entidadeCodigo = :entidadeCodigo AND l.registro = :registro AND l.vigencia = :vigencia AND l.eventoCodigo = :eventoCodigo AND l.dataLancto = :data AND l.origem = :origem AND l.mes = :mes AND l.ano = :ano ";
    public static final String QUERY_DELETE = "DELETE FROM BancoHorasLancamento l WHERE l.entidadeCodigo = :entidadeCodigo    AND l.registro = :registro    AND l.dataLancto between :dataInicial and :dataFinal    AND coalesce(l.inseridoManual, true) = false ";
    public static final String GENERATOR = "GEN_SIPBHSALDOLANCAMENTO";
    @Id
    @NotNull
    @Column(name="ID")
    private Integer id;
    @Basic(optional=false)
    @NotNull
    @Size(min=1, max=3)
    @Column(name="EMPRESA")
    private String entidadeCodigo;
    @Basic(optional=false)
    @NotNull
    @Size(min=1, max=6)
    @Column(name="REGISTRO")
    private String registro;
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="REGISTRO", referencedColumnName="REGISTRO", insertable=false, updatable=false)})
    @ManyToOne(fetch=FetchType.LAZY)
    private Trabalhador trabalhador;
    @NotNull
    @Column(name="VIGENCIA")
    private Integer vigencia;
    @JoinColumn(name="VIGENCIA", referencedColumnName="CODIGO", insertable=false, updatable=false)
    @ManyToOne(fetch=FetchType.LAZY)
    private BancoHorasParametros sipbhParametros;
    @NotNull
    @Size(min=1, max=3)
    @Column(name="EVENTO")
    private String eventoCodigo;
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="EVENTO", referencedColumnName="CODIGO", insertable=false, updatable=false)})
    @ManyToOne(fetch=FetchType.LAZY)
    private Evento evento;
    @NotNull
    @Size(min=1, max=4)
    @Column(name="ANO")
    private String ano;
    @NotNull
    @Size(min=1, max=2)
    @Column(name="MES")
    private String mes;
    @NotNull
    @Column(name="TIPOREFERENCIA")
    private Character tipoReferencia;
    @NotNull
    @Column(name="ORIGEM")
    private Short origem;
    @NotNull
    @Column(name="HORAS")
    private Double horas;
    @NotNull
    @Column(name="DTLANCTO")
    @Temporal(value=TemporalType.DATE)
    private Date dataLancto;
    @Type(type="BooleanTypeSip")
    @Column(name="INSERIDO_MANUAL")
    private Boolean inseridoManual;

    public BancoHorasLancamento(TrabalhadorVO trabalhadorVO, PontoEventoVO pontoEventoVO) throws ClassCastException {
        if (trabalhadorVO != null && pontoEventoVO != null) {
            this.entidadeCodigo = trabalhadorVO.getEntidade();
            this.registro = trabalhadorVO.getRegistro();
            this.vigencia = pontoEventoVO.getBancoHorasVigencia().getCodigo();
            this.eventoCodigo = pontoEventoVO.getCodEvento();
            this.ano = pontoEventoVO.getReferenciaPagto().getAno();
            this.mes = pontoEventoVO.getReferenciaPagto().getMesCodigo();
            this.tipoReferencia = Character.valueOf(pontoEventoVO.getReferenciaPagto().getTipoReferencia().getCodigo().charAt(0));
            this.origem = (short)BancoHorasLancamentoOrigem.PONTO.ordinal();
            this.horas = pontoEventoVO.getHorasAprovadasInDecimal();
            this.dataLancto = pontoEventoVO.getData();
            this.inseridoManual = Boolean.FALSE;
        }
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getEntidadeCodigo() {
        return this.entidadeCodigo;
    }

    public void setEntidadeCodigo(String entidadeCodigo) {
        this.entidadeCodigo = entidadeCodigo;
    }

    public String getRegistro() {
        return this.registro;
    }

    public void setRegistro(String registro) {
        this.registro = registro;
    }

    public Trabalhador getTrabalhador() {
        return this.trabalhador;
    }

    public void setTrabalhador(Trabalhador trabalhador) {
        this.trabalhador = trabalhador;
    }

    public Integer getVigencia() {
        return this.vigencia;
    }

    public void setVigencia(Integer vigencia) {
        this.vigencia = vigencia;
    }

    public BancoHorasParametros getSipbhParametros() {
        return this.sipbhParametros;
    }

    public void setSipbhParametros(BancoHorasParametros sipbhParametros) {
        this.sipbhParametros = sipbhParametros;
    }

    public String getEventoCodigo() {
        return this.eventoCodigo;
    }

    public void setEventoCodigo(String eventoCodigo) {
        this.eventoCodigo = eventoCodigo;
    }

    public Evento getEvento() {
        return this.evento;
    }

    public void setEvento(Evento evento) {
        this.evento = evento;
    }

    public String getAno() {
        return this.ano;
    }

    public void setAno(String ano) {
        this.ano = ano;
    }

    public String getMes() {
        return this.mes;
    }

    public void setMes(String mes) {
        this.mes = mes;
    }

    public Character getTipoReferencia() {
        return this.tipoReferencia;
    }

    public void setTipoReferencia(Character tipoReferencia) {
        this.tipoReferencia = tipoReferencia;
    }

    public Short getOrigem() {
        return this.origem;
    }

    public void setOrigem(Short origem) {
        this.origem = origem;
    }

    public Double getHoras() {
        return this.horas;
    }

    public void setHoras(Double horas) {
        this.horas = horas;
    }

    public Date getDataLancto() {
        return this.dataLancto;
    }

    public void setDataLancto(Date dtLancto) {
        this.dataLancto = dtLancto;
    }

    public Boolean getInseridoManual() {
        return this.inseridoManual;
    }

    public void setInseridoManual(Boolean inseridoManual) {
        this.inseridoManual = inseridoManual;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BancoHorasLancamento that = (BancoHorasLancamento)o;
        return Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public BancoHorasLancamento() {
    }

    public BancoHorasLancamento(Integer id, String entidadeCodigo, String registro, Trabalhador trabalhador, Integer vigencia, BancoHorasParametros sipbhParametros, String eventoCodigo, Evento evento, String ano, String mes, Character tipoReferencia, Short origem, Double horas, Date dataLancto, Boolean inseridoManual) {
        this.id = id;
        this.entidadeCodigo = entidadeCodigo;
        this.registro = registro;
        this.trabalhador = trabalhador;
        this.vigencia = vigencia;
        this.sipbhParametros = sipbhParametros;
        this.eventoCodigo = eventoCodigo;
        this.evento = evento;
        this.ano = ano;
        this.mes = mes;
        this.tipoReferencia = tipoReferencia;
        this.origem = origem;
        this.horas = horas;
        this.dataLancto = dataLancto;
        this.inseridoManual = inseridoManual;
    }
}

