/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.BancoHoraMovimentoPK;
import br.com.fiorilli.sip.persistence.entity.BancoHorasParametros;
import br.com.fiorilli.sip.persistence.entity.Bases;
import br.com.fiorilli.sip.persistence.entity.Evento;
import br.com.fiorilli.sip.persistence.entity.Referencia;
import br.com.fiorilli.sip.persistence.entity.Trabalhador;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import org.hibernate.annotations.Type;

@Entity
@Table(name="SIPBH_SALDO")
@Audited
public class BancoHoraMovimento
implements Serializable {
    private static final long serialVersionUID = 1L;
    @EmbeddedId
    protected BancoHoraMovimentoPK pk;
    @Column(name="PORCENTAGEM")
    private Double porcentagem;
    @Column(name="HORAS_REAL")
    private Double horasReal;
    @Column(name="HORAS")
    private Double horas;
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="REGISTRO", referencedColumnName="REGISTRO", insertable=false, updatable=false)})
    @ManyToOne(fetch=FetchType.LAZY)
    private Trabalhador trabalhador;
    @JoinColumn(name="VIGENCIA", referencedColumnName="CODIGO", insertable=false, updatable=false)
    @ManyToOne(fetch=FetchType.LAZY)
    private BancoHorasParametros sipbhParametros;
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="EVENTO", referencedColumnName="CODIGO", insertable=false, updatable=false)})
    @ManyToOne(fetch=FetchType.LAZY)
    private Evento eventos;
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="REGISTRO", referencedColumnName="REGISTRO", insertable=false, updatable=false), @JoinColumn(name="REFERENCIA", referencedColumnName="REFERENCIA", insertable=false, updatable=false)})
    @ManyToOne(fetch=FetchType.LAZY)
    private Bases bases;
    @JoinColumn(name="REFERENCIA", referencedColumnName="CODIGO", insertable=false, updatable=false)
    @ManyToOne(fetch=FetchType.LAZY)
    private Referencia referencia;
    @Column(name="TIPO")
    private Integer tipo;
    @Type(type="BooleanTypeSip")
    @Column(name="INSERIDO_MANUAL")
    private Boolean inseridoManual;

    public BancoHoraMovimento() {
    }

    public BancoHoraMovimento(BancoHoraMovimentoPK pk) {
        this.pk = pk;
    }

    public BancoHoraMovimento(String entidade, String registro, int referencia, Date data, int vigencia, String evento) {
        this.pk = new BancoHoraMovimentoPK(entidade, registro, referencia, data, vigencia, evento);
    }

    public BancoHoraMovimentoPK getPk() {
        return this.pk;
    }

    public void setPk(BancoHoraMovimentoPK pk) {
        this.pk = pk;
    }

    public Double getPorcentagem() {
        return this.porcentagem;
    }

    public void setPorcentagem(Double porcentagem) {
        this.porcentagem = porcentagem;
    }

    public Double getHorasReal() {
        return this.horasReal;
    }

    public void setHorasReal(Double horasReal) {
        this.horasReal = horasReal;
    }

    public Double getHoras() {
        return this.horas;
    }

    public void setHoras(Double horas) {
        this.horas = horas;
    }

    public Trabalhador getTrabalhador() {
        return this.trabalhador;
    }

    public void setTrabalhador(Trabalhador trabalhador) {
        this.trabalhador = trabalhador;
    }

    public BancoHorasParametros getSipbhParametros() {
        return this.sipbhParametros;
    }

    public void setSipbhParametros(BancoHorasParametros sipbhParametros) {
        this.sipbhParametros = sipbhParametros;
    }

    public Evento getEventos() {
        return this.eventos;
    }

    public void setEventos(Evento eventos) {
        this.eventos = eventos;
    }

    public Bases getBases() {
        return this.bases;
    }

    public void setBases(Bases bases) {
        this.bases = bases;
    }

    public Referencia getReferencia() {
        return this.referencia;
    }

    public void setReferencia(Referencia referencia) {
        this.referencia = referencia;
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.pk != null ? this.pk.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof BancoHoraMovimento)) {
            return false;
        }
        BancoHoraMovimento other = (BancoHoraMovimento)object;
        return (this.pk != null || other.pk == null) && (this.pk == null || this.pk.equals(other.pk));
    }

    public String toString() {
        return "BancoHoraMovimento [pk=" + this.pk + "]";
    }

    public Integer getTipo() {
        return this.tipo;
    }

    public void setTipo(Integer tipo) {
        this.tipo = tipo;
    }

    public Boolean getInseridoManual() {
        return this.inseridoManual;
    }

    public void setInseridoManual(Boolean inseridoManual) {
        this.inseridoManual = inseridoManual;
    }

    public static class Builder {
        private BancoHoraMovimento m = new BancoHoraMovimento(new BancoHoraMovimentoPK());

        public Builder() {
            this.m.setInseridoManual(Boolean.TRUE);
        }

        public BancoHoraMovimento build() {
            return this.m;
        }

        public Builder entidade(String entidade) {
            this.m.pk.setEntidade(entidade);
            return this;
        }

        public Builder registro(String registro) {
            this.m.pk.setRegistro(registro);
            return this;
        }

        public Builder referencia(int referencia) {
            this.m.pk.setReferencia(referencia);
            return this;
        }

        public Builder data(Date data) {
            this.m.pk.setData(data);
            return this;
        }

        public Builder vigencia(int vigencia) {
            this.m.pk.setVigencia(vigencia);
            return this;
        }

        public Builder evento(String evento) {
            this.m.pk.setEvento(evento);
            return this;
        }

        public Builder horas(double horas) {
            this.m.horas = horas;
            this.m.horasReal = horas;
            return this;
        }

        public Builder horasReais(double horasReais) {
            this.m.horasReal = horasReais;
            return this;
        }

        public Builder porcentagem(Double porcentagem) {
            this.m.porcentagem = porcentagem;
            return this;
        }

        public Builder tipoByPorcentagem() {
            if (this.m.porcentagem == null || this.m.porcentagem == 0.0) {
                this.m.tipo = 1;
            } else {
                this.m.tipo = 0;
            }
            if (this.m.tipo == 1) {
                this.m.horas = (this.m.horasReal = this.m.horas * -1.0);
            }
            return this;
        }
    }
}

