/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.filter.annotations.FilterConfigType;
import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.Avaliacao;
import br.com.fiorilli.sip.persistence.entity.AvaliacaoGrupo;
import br.com.fiorilli.sip.persistence.entity.Entidade;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@FilterConfigType(rootQueryType=AvaliacaoQuestionario.class)
@Entity
@Table(name="AVALIACAO_QUESTIONARIO")
@Audited
public class AvaliacaoQuestionario
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String GENERATOR = "GEN_AVALIACAOQUESTIONARIO";
    public static final String GET_FETCHED_BY_ID = "SELECT q FROM AvaliacaoQuestionario q JOIN FETCH q.avaliacaoGrupoList WHERE q.codigo = :codigo";
    public static final String FIND_BY_AVALIACAO = "SELECT q FROM AvaliacaoQuestionario q LEFT JOIN q.avaliacaoList a WHERE a.codigo = :codigo";
    @Id
    @Basic(optional=false)
    @NotNull
    @Column(name="CODIGO")
    private Integer codigo;
    @Basic(optional=false)
    @NotNull
    @Size(min=1, max=60)
    @Column(name="NOME")
    private String nome;
    @Basic(optional=false)
    @NotNull
    @Column(name="PERIODOINI")
    @Temporal(value=TemporalType.DATE)
    private Date periodoini;
    @Basic(optional=false)
    @NotNull
    @Column(name="PERIODOFIM")
    @Temporal(value=TemporalType.DATE)
    private Date periodofim;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="avaliacaoQuestionario", fetch=FetchType.LAZY)
    private List<Avaliacao> avaliacaoList;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="avaliacaoQuestionario", fetch=FetchType.LAZY)
    private List<AvaliacaoGrupo> avaliacaoGrupoList;
    @JoinColumn(name="EMPRESA", referencedColumnName="CODIGO", insertable=false, updatable=false)
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private Entidade entidade;
    @Column(name="EMPRESA")
    private String empresa;

    public AvaliacaoQuestionario() {
    }

    public AvaliacaoQuestionario(Integer codigo) {
        this.codigo = codigo;
    }

    public AvaliacaoQuestionario(Integer codigo, String nome, Date periodoini, Date periodofim) {
        this.codigo = codigo;
        this.nome = nome;
        this.periodoini = periodoini;
        this.periodofim = periodofim;
    }

    public Integer getCodigo() {
        return this.codigo;
    }

    public void setCodigo(Integer codigo) {
        this.codigo = codigo;
    }

    public String getNome() {
        return this.nome;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public Date getPeriodoini() {
        return this.periodoini;
    }

    public void setPeriodoini(Date periodoini) {
        this.periodoini = periodoini;
    }

    public Date getPeriodofim() {
        return this.periodofim;
    }

    public void setPeriodofim(Date periodofim) {
        this.periodofim = periodofim;
    }

    public List<Avaliacao> getAvaliacaoList() {
        return this.avaliacaoList;
    }

    public void setAvaliacaoList(List<Avaliacao> avaliacaoList) {
        this.avaliacaoList = avaliacaoList;
    }

    public List<AvaliacaoGrupo> getAvaliacaoGrupoList() {
        return this.avaliacaoGrupoList;
    }

    public void setAvaliacaoGrupoList(List<AvaliacaoGrupo> avaliacaoGrupoList) {
        this.avaliacaoGrupoList = avaliacaoGrupoList;
    }

    public Entidade getEntidade() {
        if (this.entidade == null) {
            this.entidade = new Entidade();
        }
        return this.entidade;
    }

    public void setEntidade(Entidade entidade) {
        this.entidade = entidade;
    }

    public String getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(String empresa) {
        this.empresa = empresa;
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.codigo != null ? this.codigo.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof AvaliacaoQuestionario)) {
            return false;
        }
        AvaliacaoQuestionario other = (AvaliacaoQuestionario)object;
        return (this.codigo != null || other.codigo == null) && (this.codigo == null || this.codigo.equals(other.codigo));
    }

    public String toString() {
        return "entity.AvaliacaoQuestionario[ codigo=" + this.codigo + " ]";
    }
}

