/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.AvaliacaoQuestao;
import br.com.fiorilli.sip.persistence.entity.AvaliacaoQuestionario;
import java.io.Serializable;
import java.util.List;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@Entity
@Table(name="AVALIACAO_GRUPO")
@Audited
public class AvaliacaoGrupo
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String GENERATOR = "GEN_AVALIACAOGRUPO";
    public static final String FIND_BY_QUESTIONARIO = "SELECT g FROM AvaliacaoGrupo g LEFT JOIN FETCH g.avaliacaoQuestionario WHERE g.avaliacaoQuestionario.codigo = :questionarioID";
    @Id
    @Basic(optional=false)
    @NotNull
    @Column(name="CODIGO")
    private Integer codigo;
    @Basic(optional=false)
    @NotNull
    @Size(min=1, max=60)
    @Column(name="NOME")
    private String nome;
    @JoinColumn(name="AVALIACAO_QUESTIONARIO", referencedColumnName="CODIGO")
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private AvaliacaoQuestionario avaliacaoQuestionario;
    @OneToMany(mappedBy="pai")
    private List<AvaliacaoGrupo> avaliacaoGrupoList;
    @JoinColumn(name="PAI", referencedColumnName="CODIGO")
    @ManyToOne(fetch=FetchType.LAZY)
    private AvaliacaoGrupo pai;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="grupo", fetch=FetchType.LAZY)
    private List<AvaliacaoQuestao> avaliacaoQuestaoList;

    public AvaliacaoGrupo() {
    }

    public AvaliacaoGrupo(Integer codigo) {
        this.codigo = codigo;
    }

    public AvaliacaoGrupo(Integer codigo, String nome) {
        this.codigo = codigo;
        this.nome = nome;
    }

    public Integer getCodigo() {
        return this.codigo;
    }

    public void setCodigo(Integer codigo) {
        this.codigo = codigo;
    }

    public String getNome() {
        return this.nome;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public AvaliacaoQuestionario getAvaliacaoQuestionario() {
        return this.avaliacaoQuestionario;
    }

    public void setAvaliacaoQuestionario(AvaliacaoQuestionario avaliacaoQuestionario) {
        if (avaliacaoQuestionario == null) {
            avaliacaoQuestionario = new AvaliacaoQuestionario();
        }
        this.avaliacaoQuestionario = avaliacaoQuestionario;
    }

    public List<AvaliacaoGrupo> getAvaliacaoGrupoList() {
        return this.avaliacaoGrupoList;
    }

    public void setAvaliacaoGrupoList(List<AvaliacaoGrupo> avaliacaoGrupoList) {
        this.avaliacaoGrupoList = avaliacaoGrupoList;
    }

    public AvaliacaoGrupo getPai() {
        return this.pai;
    }

    public void setPai(AvaliacaoGrupo pai) {
        this.pai = pai;
    }

    public List<AvaliacaoQuestao> getAvaliacaoQuestaoList() {
        return this.avaliacaoQuestaoList;
    }

    public void setAvaliacaoQuestaoList(List<AvaliacaoQuestao> avaliacaoQuestaoList) {
        this.avaliacaoQuestaoList = avaliacaoQuestaoList;
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.codigo != null ? this.codigo.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof AvaliacaoGrupo)) {
            return false;
        }
        AvaliacaoGrupo other = (AvaliacaoGrupo)object;
        return (this.codigo != null || other.codigo == null) && (this.codigo == null || this.codigo.equals(other.codigo));
    }

    public String toString() {
        return "entity.AvaliacaoGrupo[ codigo=" + this.codigo + " ]";
    }
}

