/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.AvaliacaoDesempenhoFormulario;
import br.com.fiorilli.sip.persistence.entity.AvaliacaoDesempenhoOpcao;
import java.io.Serializable;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;

@Entity
@Table(name="AVA_DES_FORM_PERG")
@Audited
public class AvaliacaoDesempenhoPergunta
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String FIND_FORMULARIO = "SELECT a FROM AvaliacaoDesempenhoPergunta a WHERE a.formulario.id = :formularioId ORDER BY a.sequencia";
    @Id
    @Column(unique=true, nullable=false)
    private int id;
    @Column(length=512)
    private String enunciado;
    @Column(nullable=false)
    private int sequencia;
    @Column(length=1)
    private String texto;
    @Column(name="TIPO_OPCAO", nullable=false)
    private int tipoOpcao;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="FORMULARIO_ID", nullable=false)
    private AvaliacaoDesempenhoFormulario formulario;
    @OneToMany(mappedBy="pergunta", fetch=FetchType.EAGER)
    private List<AvaliacaoDesempenhoOpcao> opcoes;

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getEnunciado() {
        return this.enunciado;
    }

    public void setEnunciado(String enunciado) {
        this.enunciado = enunciado;
    }

    public int getSequencia() {
        return this.sequencia;
    }

    public void setSequencia(int sequencia) {
        this.sequencia = sequencia;
    }

    public String getTexto() {
        return this.texto;
    }

    public void setTexto(String texto) {
        this.texto = texto;
    }

    public int getTipoOpcao() {
        return this.tipoOpcao;
    }

    public void setTipoOpcao(int tipoOpcao) {
        this.tipoOpcao = tipoOpcao;
    }

    public AvaliacaoDesempenhoFormulario getFormulario() {
        return this.formulario;
    }

    public void setFormulario(AvaliacaoDesempenhoFormulario avaliacaoDesempenhoFormulario) {
        this.formulario = avaliacaoDesempenhoFormulario;
    }

    public List<AvaliacaoDesempenhoOpcao> getOpcoes() {
        return this.opcoes;
    }

    public void setOpcoes(List<AvaliacaoDesempenhoOpcao> avaliacaoDesempenhoOpcaos) {
        this.opcoes = avaliacaoDesempenhoOpcaos;
    }

    public AvaliacaoDesempenhoOpcao addOpcao(AvaliacaoDesempenhoOpcao avaliacaoDesempenhoOpcao) {
        this.getOpcoes().add(avaliacaoDesempenhoOpcao);
        avaliacaoDesempenhoOpcao.setAvaDesFormPerg(this);
        return avaliacaoDesempenhoOpcao;
    }

    public AvaliacaoDesempenhoOpcao removeOpcao(AvaliacaoDesempenhoOpcao avaliacaoDesempenhoOpcao) {
        this.getOpcoes().remove(avaliacaoDesempenhoOpcao);
        avaliacaoDesempenhoOpcao.setAvaDesFormPerg(null);
        return avaliacaoDesempenhoOpcao;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.formulario == null ? 0 : this.formulario.hashCode());
        result = 31 * result + (this.opcoes == null ? 0 : this.opcoes.hashCode());
        result = 31 * result + (this.enunciado == null ? 0 : this.enunciado.hashCode());
        result = 31 * result + this.id;
        result = 31 * result + this.sequencia;
        result = 31 * result + (this.texto == null ? 0 : this.texto.hashCode());
        result = 31 * result + this.tipoOpcao;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AvaliacaoDesempenhoPergunta other = (AvaliacaoDesempenhoPergunta)obj;
        if (this.formulario == null ? other.formulario != null : !this.formulario.equals(other.formulario)) {
            return false;
        }
        if (this.opcoes == null ? other.opcoes != null : !this.opcoes.equals(other.opcoes)) {
            return false;
        }
        if (this.enunciado == null ? other.enunciado != null : !this.enunciado.equals(other.enunciado)) {
            return false;
        }
        if (this.id != other.id) {
            return false;
        }
        if (this.sequencia != other.sequencia) {
            return false;
        }
        if (this.texto == null ? other.texto != null : !this.texto.equals(other.texto)) {
            return false;
        }
        return this.tipoOpcao == other.tipoOpcao;
    }
}

