/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.AvaliacaoDesempenhoFormulario;
import br.com.fiorilli.sip.persistence.entity.AvaliacaoDesempenhoResposta;
import br.com.fiorilli.sip.persistence.entity.Trabalhador;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;

@Entity
@Table(name="AVA_DES")
@Audited
public class AvaliacaoDesempenho
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @Column(unique=true)
    private int id;
    @Column(name="DATA_AVALIACAO")
    private Date dataAvaliacao;
    @Column(name="DATA_CADASTRO")
    private Date dataCadastro;
    @Column(name="REGISTRO_AVALIADO")
    private String registroAvaliado;
    @Column(name="ENTIDADE_AVALIADO")
    private String entidadeAvaliado;
    @Column(name="REGISTRO_AVALIADOR")
    private String registroAvaliador;
    @Column(name="ENTIDADE_AVALIADOR")
    private String entidadeAvaliador;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumns(value={@JoinColumn(name="ENTIDADE_AVALIADO", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="REGISTRO_AVALIADO", referencedColumnName="REGISTRO", insertable=false, updatable=false)})
    private Trabalhador avaliado;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumns(value={@JoinColumn(name="ENTIDADE_AVALIADOR", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="REGISTRO_AVALIADOR", referencedColumnName="REGISTRO", insertable=false, updatable=false)})
    private Trabalhador avaliador;
    @Column(name="FORMULARIO_ID")
    private Integer formularioId;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="FORMULARIO_ID", insertable=false, updatable=false)
    private AvaliacaoDesempenhoFormulario formulario;
    @OneToMany(mappedBy="avaliacaoDesempenho", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    private List<AvaliacaoDesempenhoResposta> respostas;

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public Date getDataAvaliacao() {
        return this.dataAvaliacao;
    }

    public void setDataAvaliacao(Date dataAvaliacao) {
        this.dataAvaliacao = dataAvaliacao;
    }

    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    public List<AvaliacaoDesempenhoResposta> getRespostas() {
        return this.respostas;
    }

    public void setRespostas(List<AvaliacaoDesempenhoResposta> avaliacaoDesempenhoResposta) {
        this.respostas = avaliacaoDesempenhoResposta;
    }

    public AvaliacaoDesempenhoResposta addResposta(AvaliacaoDesempenhoResposta avaliacaoDesempenhoResposta) {
        this.getRespostas().add(avaliacaoDesempenhoResposta);
        avaliacaoDesempenhoResposta.setAvaliacao(this);
        return avaliacaoDesempenhoResposta;
    }

    public AvaliacaoDesempenhoResposta removeAvaDesFormResp(AvaliacaoDesempenhoResposta avaliacaoDesempenhoResposta) {
        this.getRespostas().remove(avaliacaoDesempenhoResposta);
        avaliacaoDesempenhoResposta.setAvaliacao(null);
        return avaliacaoDesempenhoResposta;
    }

    public Trabalhador getAvaliado() {
        return this.avaliado;
    }

    public void setAvaliado(Trabalhador trabalhador) {
        if (trabalhador == null) {
            this.entidadeAvaliado = null;
            this.registroAvaliado = null;
        } else {
            this.entidadeAvaliado = trabalhador.trabalhadorPK.getEntidade();
            this.registroAvaliado = trabalhador.trabalhadorPK.getRegistro();
        }
        this.avaliado = trabalhador;
    }

    public String toString() {
        return "AvaliacaoDesempenho [id=" + this.id + ", dataAvaliacao=" + this.dataAvaliacao + ", dataCadastro=" + this.dataCadastro + ", avaliado=" + this.avaliado + ", formulario=" + this.formulario + ", respostas=" + this.respostas + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.dataAvaliacao == null ? 0 : this.dataAvaliacao.hashCode());
        result = 31 * result + (this.dataCadastro == null ? 0 : this.dataCadastro.hashCode());
        result = 31 * result + (this.formulario == null ? 0 : this.formulario.hashCode());
        result = 31 * result + this.id;
        result = 31 * result + (this.respostas == null ? 0 : this.respostas.hashCode());
        result = 31 * result + (this.avaliado == null ? 0 : this.avaliado.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AvaliacaoDesempenho other = (AvaliacaoDesempenho)obj;
        if (this.dataAvaliacao == null ? other.dataAvaliacao != null : !this.dataAvaliacao.equals(other.dataAvaliacao)) {
            return false;
        }
        if (this.dataCadastro == null ? other.dataCadastro != null : !this.dataCadastro.equals(other.dataCadastro)) {
            return false;
        }
        if (this.formulario == null ? other.formulario != null : !this.formulario.equals(other.formulario)) {
            return false;
        }
        if (this.id != other.id) {
            return false;
        }
        if (this.respostas == null ? other.respostas != null : !this.respostas.equals(other.respostas)) {
            return false;
        }
        return !(this.avaliado == null ? other.avaliado != null : !this.avaliado.equals(other.avaliado));
    }

    public Trabalhador getAvaliador() {
        return this.avaliador;
    }

    public void setAvaliador(Trabalhador avaliador) {
        if (avaliador == null) {
            this.entidadeAvaliador = null;
            this.registroAvaliador = null;
        } else {
            this.entidadeAvaliador = avaliador.trabalhadorPK.getEntidade();
            this.registroAvaliador = avaliador.trabalhadorPK.getRegistro();
        }
        this.avaliador = avaliador;
    }

    public AvaliacaoDesempenhoFormulario getFormulario() {
        return this.formulario;
    }

    public void setFormulario(AvaliacaoDesempenhoFormulario formulario) {
        this.formularioId = formulario == null ? null : Integer.valueOf(formulario.getId());
        this.formulario = formulario;
    }
}

