/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.filter.annotations.FilterConfig;
import br.com.fiorilli.filter.annotations.FilterConfigType;
import br.com.fiorilli.filter.model.FilterCondition;
import br.com.fiorilli.filter.model.FilterInputType;
import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.AvaliacaoPenalidade;
import br.com.fiorilli.sip.persistence.entity.AvaliacaoPonto;
import br.com.fiorilli.sip.persistence.entity.AvaliacaoQuestionario;
import br.com.fiorilli.sip.persistence.entity.Trabalhador;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@FilterConfigType(rootQueryType=Avaliacao.class)
@Entity
@Table(name="AVALIACAO")
@Audited
public class Avaliacao
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String GENERATOR = "GEN_AVALIACAO";
    public static final String FIND_BY_AVALIADOR = "SELECT DISTINCT a FROM Avaliacao a JOIN FETCH a.trabalhador WHERE a.trabalhador.trabalhadorPK.entidade = :entidade AND a.trabalhador.trabalhadorPK.registro = :registro";
    public static final String FIND_BY_AVALIADO = "SELECT DISTINCT a FROM Avaliacao a JOIN FETCH a.trabalhador1 WHERE a.trabalhador1.trabalhadorPK.entidade = :entidade AND a.trabalhador1.trabalhadorPK.registro = :registro";
    @FilterConfig(label="C\u00f3digo", inputType=FilterInputType.NUMBER)
    @Id
    @Basic(optional=false)
    @NotNull
    @Column(name="CODIGO")
    private Integer codigo;
    @Basic(optional=false)
    @NotNull
    @Size(min=1, max=16)
    @Column(name="NUMERO")
    private String numero;
    @Basic(optional=false)
    @NotNull
    @Column(name="PONTUACAO_TOTAL")
    private double pontuacaoTotal;
    @FilterConfig(label="Data", inputType=FilterInputType.CALENDAR, order=4)
    @Basic(optional=false)
    @NotNull
    @Column(name="DATA")
    @Temporal(value=TemporalType.DATE)
    private Date data;
    @NotNull
    @Column(name="REGISTRO")
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="avaliacao", fetch=FetchType.LAZY)
    private List<AvaliacaoPonto> avaliacaoPontoList;
    @NotNull
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="avaliacao", fetch=FetchType.LAZY)
    private List<AvaliacaoPenalidade> avaliacaoPenalidadeList;
    @FilterConfig(label="Avaliador", condition=FilterCondition.COMECE, order=2)
    @NotNull
    @JoinColumns(value={@JoinColumn(name="EMPRESA_AVALIADOR", referencedColumnName="EMPRESA"), @JoinColumn(name="REGISTRO_AVALIADOR", referencedColumnName="REGISTRO")})
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private Trabalhador trabalhador;
    @FilterConfig(label="Servidor", condition=FilterCondition.COMECE, order=1)
    @NotNull
    @JoinColumns(value={@JoinColumn(name="EMPRESA_AVALIADO", referencedColumnName="EMPRESA"), @JoinColumn(name="REGISTRO_AVALIADO", referencedColumnName="REGISTRO")})
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private Trabalhador trabalhador1;
    @FilterConfig(label="Questionario", condition=FilterCondition.COMECE, order=3)
    @NotNull
    @JoinColumn(name="AVALIACAO_QUESTIONARIO", referencedColumnName="CODIGO")
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private AvaliacaoQuestionario avaliacaoQuestionario;

    public Avaliacao() {
    }

    public Avaliacao(Integer codigo) {
        this.codigo = codigo;
    }

    public Avaliacao(Integer codigo, String numero, double pontuacaoTotal, Date data) {
        this.codigo = codigo;
        this.numero = numero;
        this.pontuacaoTotal = pontuacaoTotal;
        this.data = data;
    }

    public Integer getCodigo() {
        return this.codigo;
    }

    public void setCodigo(Integer codigo) {
        this.codigo = codigo;
    }

    public String getNumero() {
        return this.numero;
    }

    public void setNumero(String numero) {
        this.numero = numero;
    }

    public double getPontuacaoTotal() {
        return this.pontuacaoTotal;
    }

    public void setPontuacaoTotal(double pontuacaoTotal) {
        this.pontuacaoTotal = pontuacaoTotal;
    }

    public Date getData() {
        return this.data;
    }

    public void setData(Date data) {
        this.data = data;
    }

    public List<AvaliacaoPonto> getAvaliacaoPontoList() {
        return this.avaliacaoPontoList;
    }

    public void setAvaliacaoPontoList(List<AvaliacaoPonto> avaliacaoPontoList) {
        this.avaliacaoPontoList = avaliacaoPontoList;
    }

    public List<AvaliacaoPenalidade> getAvaliacaoPenalidadeList() {
        return this.avaliacaoPenalidadeList;
    }

    public void setAvaliacaoPenalidadeList(List<AvaliacaoPenalidade> avaliacaoPenalidadeList) {
        this.avaliacaoPenalidadeList = avaliacaoPenalidadeList;
    }

    public Trabalhador getTrabalhador() {
        if (this.trabalhador == null) {
            this.trabalhador = new Trabalhador();
        }
        return this.trabalhador;
    }

    public void setTrabalhador(Trabalhador trabalhador) {
        this.trabalhador = trabalhador;
    }

    public Trabalhador getTrabalhador1() {
        if (this.trabalhador1 == null) {
            this.trabalhador1 = new Trabalhador();
        }
        return this.trabalhador1;
    }

    public void setTrabalhador1(Trabalhador trabalhador1) {
        this.trabalhador1 = trabalhador1;
    }

    public AvaliacaoQuestionario getAvaliacaoQuestionario() {
        if (this.avaliacaoQuestionario == null) {
            this.avaliacaoQuestionario = new AvaliacaoQuestionario();
        }
        return this.avaliacaoQuestionario;
    }

    public void setAvaliacaoQuestionario(AvaliacaoQuestionario avaliacaoQuestionario) {
        this.avaliacaoQuestionario = avaliacaoQuestionario;
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.codigo != null ? this.codigo.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Avaliacao)) {
            return false;
        }
        Avaliacao other = (Avaliacao)object;
        return (this.codigo != null || other.codigo == null) && (this.codigo == null || this.codigo.equals(other.codigo));
    }

    public String toString() {
        return "entity.Avaliacao[ codigo=" + this.codigo + " ]";
    }
}

