/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.filter.annotations.FilterConfig;
import br.com.fiorilli.filter.model.FilterCondition;
import br.com.fiorilli.filter.service.Filterable;
import br.com.fiorilli.sip.commons.util.SIPNumberUtil;
import br.com.fiorilli.sip.persistence.api.GenericEntity;
import br.com.fiorilli.sip.persistence.api.SearchNome;
import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.AutonomoPK;
import br.com.fiorilli.sip.persistence.entity.CategoriaSefip;
import br.com.fiorilli.sip.persistence.entity.CboOcupacao;
import br.com.fiorilli.sip.persistence.entity.Convenio;
import br.com.fiorilli.sip.persistence.entity.DocumentoProfissional;
import br.com.fiorilli.sip.persistence.entity.Endereco;
import br.com.fiorilli.sip.persistence.entity.Entidade;
import br.com.fiorilli.sip.persistence.entity.Instrucao;
import br.com.fiorilli.sip.persistence.entity.MovimentoAutonomo;
import br.com.fiorilli.sip.persistence.entity.PessoaPortaria;
import br.com.fiorilli.sip.persistence.entity.RetencaoDIRF;
import br.com.fiorilli.sip.persistence.entity.SefipTipoOcorrencia;
import br.com.fiorilli.sip.persistence.entity.TelefoneFixo;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.PostLoad;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.hibernate.annotations.Type;

@Entity
@Table(name="AUTONOMOSEFIP")
@Audited
public class Autonomo
implements Serializable,
Filterable,
GenericEntity {
    private static final long serialVersionUID = 1L;
    public static final String FIND_LAST_CODIGO = "SELECT COALESCE(MAX(a.codigoInteiro), 0) + 1 FROM Autonomo a WHERE a.autonomoPK.entidade = :entidadeCodigo";
    public static final String GET_FETCHED = "SELECT au FROM Autonomo au LEFT JOIN FETCH au.categoria LEFT JOIN FETCH au.retencaoDirf LEFT JOIN FETCH au.convenio co LEFT JOIN FETCH au.cboOcupacao LEFT JOIN FETCH co.banco b LEFT JOIN FETCH co.conta WHERE au.autonomoPK = :pk";
    public static final String FIND_FOR_FILTER = "SELECT a FROM Autonomo a WHERE a.nome LIKE '%'||:param||'%' ";
    @EmbeddedId
    protected AutonomoPK autonomoPK;
    @SearchNome
    @FilterConfig(label="Nome", condition=FilterCondition.COMECE)
    @Size(max=60)
    @Column(name="NOME")
    private String nome;
    @Size(max=11)
    @Column(name="PIS", length=11)
    private String pis;
    @Embedded
    private Endereco endereco;
    @Size(max=6)
    @Column(name="CBO")
    private String cbo;
    @JoinColumn(name="CBO", referencedColumnName="NUMEROCBO", insertable=false, updatable=false)
    @ManyToOne(fetch=FetchType.LAZY)
    private CboOcupacao cboOcupacao;
    @Size(max=11)
    @Column(name="MATRICULA")
    private String matricula;
    @Size(max=7)
    @Column(name="CTPS")
    private String ctps;
    @Size(max=5)
    @Column(name="SERIE")
    private String serie;
    @Size(max=2)
    @Column(name="OCORRENCIA")
    private String ocorrencia;
    @Column(name="DTNASC")
    @Temporal(value=TemporalType.DATE)
    private Date dataNascimento;
    @Column(name="DTADMISSAO")
    @Temporal(value=TemporalType.DATE)
    private Date dataAdmissao;
    @Type(type="BooleanTypeSip")
    @Column(name="FGTS")
    private Boolean fgts;
    @Column(name="DTOPCAO")
    @Temporal(value=TemporalType.DATE)
    private Date dataOpcao;
    @Size(max=11)
    @Column(name="CPF", length=11)
    private String cpf;
    @Column(name="DH_REGISTRO")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date dataHoraRegistro;
    @Column(name="ALIQUOTA_SERVICO")
    private BigDecimal aliquotaServico;
    @Column(name="DEPIRRF")
    private Short dependentesIrrf;
    @Column(name="ID_CADUNICO")
    private Double cadastroUnicoId;
    @Column(name="CODIGOINT")
    private Integer codigoInteiro;
    @Column(name="BANCO", length=3)
    private String bancoCodigo;
    @Column(name="ITEMAGENCIA")
    private Short agenciaItem;
    @Column(name="ITEMCONTA")
    private Short contaItem;
    @Column(name="ITEMCONVENIO")
    private Short convenioItem;
    @Column(name="CODRETDIRF", length=4)
    private String codRetencaoDirf;
    @JoinColumn(name="CODRETDIRF", referencedColumnName="CODIGO", insertable=false, updatable=false)
    @ManyToOne(fetch=FetchType.LAZY)
    private RetencaoDIRF retencaoDirf;
    @Size(max=15)
    @Column(name="RG")
    private String rg;
    @Type(type="BooleanTypeSip")
    @Column(name="MEI_ART18B_LC128_2008")
    private Boolean meiArtigo18bLc1282008;
    @JoinColumn(name="EMPRESA", referencedColumnName="CODIGO", insertable=false, updatable=false)
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private Entidade entidade;
    @Column(name="CATEGORIA")
    private String categoriaCodigo;
    @JoinColumn(name="CATEGORIA", referencedColumnName="CODIGO", insertable=false, updatable=false)
    @ManyToOne(fetch=FetchType.LAZY)
    private CategoriaSefip categoria;
    @JoinColumn(name="IDCADPORTARIA", referencedColumnName="IDCADPORTARIA")
    @ManyToOne(fetch=FetchType.LAZY)
    private PessoaPortaria pessoaPortaria;
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="BANCO", referencedColumnName="BANCO", insertable=false, updatable=false), @JoinColumn(name="ITEMAGENCIA", referencedColumnName="ITEMAGENCIA", insertable=false, updatable=false), @JoinColumn(name="ITEMCONTA", referencedColumnName="ITEMCONTA", insertable=false, updatable=false), @JoinColumn(name="ITEMCONVENIO", referencedColumnName="ITEM", insertable=false, updatable=false)})
    @ManyToOne(fetch=FetchType.LAZY)
    private Convenio convenio;
    @Size(max=12)
    @Column(name="CONTA")
    private String conta;
    @Size(max=2)
    @Column(name="DVCONTA")
    private String dvConta;
    @Size(max=5)
    @Column(name="TIPOCONTA")
    private String tipoConta;
    @Size(max=6)
    @Column(name="AGENCIA")
    private String agencia;
    @Size(max=2)
    @Column(name="DVAGENCIA")
    private String dvAgencia;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="autonomo", fetch=FetchType.LAZY)
    private List<MovimentoAutonomo> movimentoAutonomoList;
    @Embedded
    private DocumentoProfissional documentoProfissional;
    @JoinColumn(name="INSTRUCAO", referencedColumnName="CODIGO", insertable=false, updatable=false)
    @ManyToOne(fetch=FetchType.LAZY)
    private Instrucao instrucao;
    @Pattern(regexp="[a-z0-9!#$%&'*+/=?^_`{|}~-]+(?:\\.[a-z0-9!#$%&'*+/=?^_`{|}~-]+)*@(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?", message="E-mail inv\u00e1lido")
    @Size(max=60)
    @Column(name="EMAIL")
    private String email;
    @Embedded
    private TelefoneFixo telefone;

    @PostLoad
    public void postLoad() {
        if (this.endereco == null) {
            this.endereco = new Endereco();
        }
    }

    public Autonomo() {
    }

    public Autonomo(AutonomoPK autonomoPK) {
        this.autonomoPK = autonomoPK;
    }

    public Autonomo(String entidade, String codigo) {
        this.autonomoPK = new AutonomoPK(entidade, codigo);
    }

    public AutonomoPK getAutonomoPK() {
        if (this.autonomoPK == null) {
            this.autonomoPK = new AutonomoPK();
        }
        return this.autonomoPK;
    }

    public void setAutonomoPK(AutonomoPK autonomoPK) {
        this.autonomoPK = autonomoPK;
    }

    public String getNome() {
        return this.nome;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public String getPis() {
        return this.pis;
    }

    public void setPis(String pis) {
        this.pis = pis;
    }

    public String getCbo() {
        return this.cbo;
    }

    public void setCbo(String cbo) {
        this.cbo = cbo;
    }

    public String getMatricula() {
        return this.matricula;
    }

    public void setMatricula(String matricula) {
        this.matricula = matricula;
    }

    public String getCtps() {
        return this.ctps;
    }

    public void setCtps(String ctps) {
        this.ctps = ctps;
    }

    public String getSerie() {
        return this.serie;
    }

    public void setSerie(String serie) {
        this.serie = serie;
    }

    public SefipTipoOcorrencia getOcorrencia() {
        return SefipTipoOcorrencia.get(this.ocorrencia);
    }

    public void setOcorrencia(SefipTipoOcorrencia ocorrencia) {
        this.ocorrencia = ocorrencia.getCodigo();
    }

    public Date getDataNascimento() {
        return this.dataNascimento;
    }

    public void setDataNascimento(Date dtnasc) {
        this.dataNascimento = dtnasc;
    }

    public Date getDataAdmissao() {
        return this.dataAdmissao;
    }

    public void setDataAdmissao(Date dataAdmissao) {
        this.dataAdmissao = dataAdmissao;
    }

    public Date getDataOpcao() {
        return this.dataOpcao;
    }

    public Boolean getFgts() {
        return this.fgts;
    }

    public void setFgts(Boolean fgts) {
        this.fgts = fgts;
    }

    public void setDataOpcao(Date dtopcao) {
        this.dataOpcao = dtopcao;
    }

    public String getCpf() {
        return this.cpf;
    }

    public void setCpf(String cpf) {
        this.cpf = cpf;
    }

    public Date getDataHoraRegistro() {
        return this.dataHoraRegistro;
    }

    public void setDataHoraRegistro(Date dhRegistro) {
        this.dataHoraRegistro = dhRegistro;
    }

    public BigDecimal getAliquotaServico() {
        return this.aliquotaServico;
    }

    public void setAliquotaServico(BigDecimal aliquotaServico) {
        this.aliquotaServico = aliquotaServico;
    }

    public Short getDependentesIrrf() {
        return SIPNumberUtil.defaultShort((Short)this.dependentesIrrf);
    }

    public void setDependentesIrrf(Short depirrf) {
        this.dependentesIrrf = depirrf;
    }

    public Double getCadastroUnicoId() {
        return this.cadastroUnicoId;
    }

    public void setCadastroUnicoId(Double idCadunico) {
        this.cadastroUnicoId = idCadunico;
    }

    public Integer getCodigoInteiro() {
        return this.codigoInteiro;
    }

    public void setCodigoInteiro(Integer codigoint) {
        this.codigoInteiro = codigoint;
    }

    public Entidade getEntidade() {
        return this.entidade;
    }

    public void setEntidade(Entidade entidade1) {
        this.entidade = entidade1;
    }

    public CategoriaSefip getCategoria() {
        return this.categoria;
    }

    public void setCategoria(CategoriaSefip value) {
        this.categoria = value;
        this.categoriaCodigo = value != null ? this.categoria.getCodigo() : null;
    }

    public PessoaPortaria getPessoaPortaria() {
        return this.pessoaPortaria;
    }

    public void setPessoaPortaria(PessoaPortaria idcadportaria) {
        this.pessoaPortaria = idcadportaria;
    }

    public List<MovimentoAutonomo> getMovimentoAutonomoList() {
        return this.movimentoAutonomoList;
    }

    public void setMovimentoAutonomoList(List<MovimentoAutonomo> movtoautonomosefipList) {
        this.movimentoAutonomoList = movtoautonomosefipList;
    }

    public Endereco getEndereco() {
        if (this.endereco == null) {
            this.endereco = new Endereco();
        }
        return this.endereco;
    }

    public void setEndereco(Endereco endereco) {
        this.endereco = endereco;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.autonomoPK == null ? 0 : this.autonomoPK.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Autonomo other = (Autonomo)obj;
        return !(this.autonomoPK == null ? other.autonomoPK != null : !this.autonomoPK.equals(other.autonomoPK));
    }

    public String toString() {
        return "Autonomo [autonomoPK=" + this.autonomoPK + "]";
    }

    public Convenio getConvenio() {
        return this.convenio;
    }

    public void setConvenio(Convenio convenio) {
        if (convenio != null) {
            this.bancoCodigo = convenio.getConvenioPK().getBanco();
            this.agenciaItem = convenio.getConvenioPK().getItemAgencia();
            this.contaItem = convenio.getConvenioPK().getItemConta();
            this.convenioItem = convenio.getConvenioPK().getItem();
            this.bancoCodigo = convenio.getConvenioPK().getBanco();
        }
        this.convenio = convenio;
    }

    public String getConta() {
        return this.conta;
    }

    public void setConta(String conta) {
        this.conta = conta;
    }

    public String getDvConta() {
        return this.dvConta;
    }

    public void setDvConta(String dvConta) {
        this.dvConta = dvConta;
    }

    public String getTipoConta() {
        return this.tipoConta;
    }

    public void setTipoConta(String tipoConta) {
        this.tipoConta = tipoConta;
    }

    public String getAgencia() {
        return this.agencia;
    }

    public void setAgencia(String agencia) {
        this.agencia = agencia;
    }

    public String getDvAgencia() {
        return this.dvAgencia;
    }

    public void setDvAgencia(String dvAgencia) {
        this.dvAgencia = dvAgencia;
    }

    public static Autonomo createNotNull(String entidadeCodigo) {
        Autonomo autonomo = new Autonomo(entidadeCodigo, null);
        autonomo.endereco = new Endereco();
        return autonomo;
    }

    public String getCategoriaCodigo() {
        return this.categoriaCodigo;
    }

    public String getCodRetencaoDirf() {
        return this.codRetencaoDirf;
    }

    public void setCodRetencaoDirf(String codRetencaoDirf) {
        this.codRetencaoDirf = codRetencaoDirf;
    }

    public String getBancoCodigo() {
        return this.bancoCodigo;
    }

    public void setBancoCodigo(String bancoCodigo) {
        this.bancoCodigo = bancoCodigo;
    }

    public Short getAgenciaItem() {
        return this.agenciaItem;
    }

    public Short getContaItem() {
        return this.contaItem;
    }

    public Short getConvenioItem() {
        return this.convenioItem;
    }

    public String getRg() {
        return this.rg;
    }

    public void setRg(String rg) {
        this.rg = rg;
    }

    public Boolean isMeiArtigo18bLc1282008() {
        return this.meiArtigo18bLc1282008 != null ? this.meiArtigo18bLc1282008 : false;
    }

    public Boolean getMeiArtigo18bLc1282008() {
        return this.isMeiArtigo18bLc1282008();
    }

    public void setMeiArtigo18bLc1282008(Boolean meiArtigo18bLc1282008) {
        this.meiArtigo18bLc1282008 = meiArtigo18bLc1282008;
    }

    public RetencaoDIRF getRetencaoDirf() {
        return this.retencaoDirf;
    }

    public void setRetencaoDirf(RetencaoDIRF retencaoDirf) {
        this.codRetencaoDirf = retencaoDirf == null ? null : retencaoDirf.getCodigo();
        this.retencaoDirf = retencaoDirf;
    }

    public CboOcupacao getCboOcupacao() {
        return this.cboOcupacao;
    }

    public void setCboOcupacao(CboOcupacao cboObj) {
        this.cboOcupacao = cboObj;
        this.cbo = cboObj == null ? null : this.cboOcupacao.getNumeroCbo();
    }

    public String getItemId() {
        return String.valueOf(this.hashCode());
    }

    public String getItemLabel() {
        return this.nome;
    }

    @Override
    public String getHashId() {
        return String.valueOf(this.hashCode());
    }
}

