/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.sip.commons.util.SIPUtil;
import br.com.fiorilli.sip.persistence.api.Documento;
import br.com.fiorilli.sip.persistence.api.GenericEntity;
import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.LocalPublicacao;
import br.com.fiorilli.sip.persistence.entity.TipoDocumentoLegal;
import br.com.fiorilli.sip.persistence.entity.Trabalhador;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.NotNull;

@Entity
@Table(name="SIPATOPESSOAL")
@Audited
public class AtoPessoal
implements Serializable,
Documento,
GenericEntity {
    private static final long serialVersionUID = 1L;
    public static final String FIND_BY_NUMERO = "SELECT a FROM AtoPessoal a LEFT JOIN FETCH a.tipoLegal LEFT JOIN FETCH a.localPublicacao WHERE a.numeroDocumento like :numeroDocumento";
    @NotNull
    @Id
    @Column(name="ID_ATO_PESSOAL")
    private Integer id;
    @JoinColumn(name="LOCAL_PUBLICACAO", referencedColumnName="CODIGO", insertable=false, updatable=false)
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private LocalPublicacao localPublicacao;
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="REGISTRO", referencedColumnName="REGISTRO", insertable=false, updatable=false)})
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private Trabalhador trabalhador;
    @JoinColumn(name="TIPOLEGAL", referencedColumnName="CODIGO", insertable=false, updatable=false)
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private TipoDocumentoLegal tipoLegal;
    @Column(name="TIPOLEGAL")
    private Integer tipoLegalCodigo;
    @Basic(optional=false)
    @Column(name="NUMDOC", length=16)
    private String numeroDocumento;
    @Basic(optional=false)
    @Column(name="DATADOC")
    @Temporal(value=TemporalType.DATE)
    private Date dataDocumento;
    @Basic(optional=false)
    @Column(name="DATAPUB")
    @Temporal(value=TemporalType.DATE)
    private Date dataPublicacao;

    @Override
    public TipoDocumentoLegal getTipoLegal() {
        return this.tipoLegal;
    }

    @Override
    public void setTipoLegal(TipoDocumentoLegal value) {
        this.tipoLegalCodigo = this.tipoLegal != null ? value.getCodigo() : null;
        this.tipoLegal = value;
    }

    @Override
    public Integer getTipoLegalCodigo() {
        return this.tipoLegalCodigo;
    }

    @Override
    public String getNumeroDocumento() {
        return this.numeroDocumento;
    }

    @Override
    public void setNumeroDocumento(String value) {
        this.numeroDocumento = value;
    }

    @Override
    public Integer getAnoDocumento() {
        return SIPUtil.getAnoFromNumDoc((String)this.numeroDocumento);
    }

    @Override
    public String getNumDocSemAno() {
        return SIPUtil.getNumDocSemAno((String)this.numeroDocumento);
    }

    @Override
    public Date getData() {
        return this.dataDocumento;
    }

    @Override
    public void setData(Date value) {
        this.dataDocumento = value;
    }

    public Trabalhador getTrabalhador() {
        return this.trabalhador;
    }

    public void setTrabalhador(Trabalhador trabalhador) {
        this.trabalhador = trabalhador;
    }

    public Date getDataPublicacao() {
        return this.dataPublicacao;
    }

    public void setDataPublicacao(Date dataPublicacao) {
        this.dataPublicacao = dataPublicacao;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AtoPessoal other = (AtoPessoal)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public String toString() {
        return "AtoPessoal [id=" + this.id + "]";
    }

    @Override
    public String getHashId() {
        return String.valueOf(this.id);
    }
}

