/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.filter.annotations.FilterConfig;
import br.com.fiorilli.filter.service.Filterable;
import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.AtividadeCargo;
import br.com.fiorilli.sip.persistence.entity.AtividadePK;
import br.com.fiorilli.sip.persistence.entity.Epi;
import br.com.fiorilli.sip.persistence.entity.Trabalhador;
import java.io.Serializable;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.validation.constraints.Size;

@Entity
@Table(name="ATIVIDADE")
@Audited
public class Atividade
implements Serializable,
Filterable {
    private static final long serialVersionUID = 1L;
    public static final String QUERY_FIND_POR_ENTIDADE = "SELECT a FROM Atividade a where a.atividadePK.entidade = :entidadeId";
    public static final String GET_COMPLETE_ATIVIDADE = "SELECT a FROM Atividade a LEFT JOIN FETCH a.epis WHERE a.atividadePK = :atividadePK";
    public static final String FIND_FOR_FILTER = "SELECT a FROM Atividade a WHERE a.nome LIKE '%'||:param||'%'";
    @EmbeddedId
    protected AtividadePK atividadePK;
    @FilterConfig(label="Nome", order=1)
    @Size(max=60)
    @Column(name="NOME")
    private String nome;
    @Size(max=6)
    @Column(name="CBO")
    private String cbo;
    @JoinTable(name="ATIVIDADE_EPI", joinColumns={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA"), @JoinColumn(name="CODIGO_ATIVIDADE", referencedColumnName="CODIGO")}, inverseJoinColumns={@JoinColumn(name="CODIGO_EPI", referencedColumnName="CODIGO")})
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.MERGE})
    private List<Epi> epis;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="atividade", fetch=FetchType.LAZY)
    private List<Trabalhador> trabalhadores;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="atividade", fetch=FetchType.LAZY)
    private List<AtividadeCargo> atividadesCargo;

    public Atividade() {
    }

    public Atividade(AtividadePK atividadePK) {
        this.atividadePK = atividadePK;
    }

    public Atividade(String entidade, int codigo) {
        this.atividadePK = new AtividadePK(entidade, codigo);
    }

    public AtividadePK getAtividadePK() {
        return this.atividadePK;
    }

    public void setAtividadePK(AtividadePK atividadePK) {
        this.atividadePK = atividadePK;
    }

    public String getNome() {
        return this.nome;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public List<Epi> getEpis() {
        return this.epis;
    }

    public void setEpis(List<Epi> epiList) {
        this.epis = epiList;
    }

    public List<Trabalhador> getTrabalhadores() {
        return this.trabalhadores;
    }

    public void setTrabalhadores(List<Trabalhador> trabalhadorList) {
        this.trabalhadores = trabalhadorList;
    }

    public List<AtividadeCargo> getAtividadesCargo() {
        return this.atividadesCargo;
    }

    public void setAtividadesCargo(List<AtividadeCargo> atividadesCargo) {
        this.atividadesCargo = atividadesCargo;
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.atividadePK != null ? this.atividadePK.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Atividade)) {
            return false;
        }
        Atividade other = (Atividade)object;
        return (this.atividadePK != null || other.atividadePK == null) && (this.atividadePK == null || this.atividadePK.equals(other.atividadePK));
    }

    public String toString() {
        return "entity.Atividade[ atividadePK=" + this.atividadePK + " ]";
    }

    public String getCbo() {
        return this.cbo;
    }

    public void setCbo(String cbo) {
        this.cbo = cbo;
    }

    public String getItemId() {
        return String.valueOf(this.hashCode());
    }

    public String getItemLabel() {
        return this.nome;
    }
}

