/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.MotivoAposentadoria;
import br.com.fiorilli.sip.persistence.entity.RegraAposentadoria;
import br.com.fiorilli.sip.persistence.entity.Trabalhador;
import br.com.fiorilli.sip.persistence.entity.TrabalhadorPK;
import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

@Entity
@Table(name="APOSENTADOS")
@Audited
public class Aposentado
implements Serializable {
    private static final long serialVersionUID = 1L;
    @EmbeddedId
    protected TrabalhadorPK aposentadosPK;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="REGISTRO", referencedColumnName="REGISTRO", insertable=false, updatable=false)})
    private Trabalhador trabalhador;
    @JoinColumn(name="REGRA", referencedColumnName="CODIGO", insertable=false, updatable=false)
    @ManyToOne(fetch=FetchType.LAZY)
    private RegraAposentadoria regra;
    @Column(name="REGRA")
    private Integer regraCodigo;
    @JoinColumn(name="CAUSA", referencedColumnName="CODIGO", insertable=false, updatable=false)
    @ManyToOne(fetch=FetchType.LAZY)
    private MotivoAposentadoria motivoAposentadoria;
    @Column(name="CAUSA", length=2)
    private String causaCodigo;

    public Aposentado() {
    }

    public Aposentado(TrabalhadorPK aposentadosPK) {
        this.aposentadosPK = aposentadosPK;
    }

    public Aposentado(String entidade, String registro) {
        this.aposentadosPK = new TrabalhadorPK(entidade, registro);
    }

    public TrabalhadorPK getTrabalhadorPK() {
        if (this.aposentadosPK == null) {
            this.aposentadosPK = new TrabalhadorPK();
        }
        return this.aposentadosPK;
    }

    public void setTrabalhadorPK(TrabalhadorPK aposentadosPK) {
        this.aposentadosPK = aposentadosPK;
    }

    public Trabalhador getTrabalhador() {
        return this.trabalhador;
    }

    public void setTrabalhador(Trabalhador trabalhador) {
        this.trabalhador = trabalhador;
    }

    public RegraAposentadoria getRegra() {
        return this.regra;
    }

    public void setRegra(RegraAposentadoria regra) {
        this.regra = regra;
    }

    public MotivoAposentadoria getMotivoAposentadoria() {
        return this.motivoAposentadoria;
    }

    public void setMotivoAposentadoria(MotivoAposentadoria motivoAposentadoria) {
        this.motivoAposentadoria = motivoAposentadoria;
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.aposentadosPK != null ? this.aposentadosPK.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Aposentado)) {
            return false;
        }
        Aposentado other = (Aposentado)object;
        return (this.aposentadosPK != null || other.aposentadosPK == null) && (this.aposentadosPK == null || this.aposentadosPK.equals(other.aposentadosPK));
    }

    public String toString() {
        return "entity.Aposentados[ aposentadosPK=" + this.aposentadosPK + " ]";
    }

    public String getCausaCodigo() {
        return this.causaCodigo;
    }

    public void setCausaCodigo(String causaCodigo) {
        this.causaCodigo = causaCodigo;
    }

    public Integer getRegraCodigo() {
        return this.regraCodigo;
    }

    public void setRegraCodigo(Integer regraCodigo) {
        this.regraCodigo = regraCodigo;
    }
}

