/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.sip.persistence.entity.AmbienteTrabalhoFatorRisco;
import br.com.fiorilli.sip.persistence.entity.AmbienteTrabalhoPK;
import br.com.fiorilli.sip.persistence.entity.Entidade;
import br.com.fiorilli.sip.persistence.entity.GrupoFatorRisco;
import br.com.fiorilli.sip.persistence.entity.PericiaNova;
import br.com.fiorilli.sip.persistence.entity.Trabalhador;
import br.com.fiorilli.sipweb.vo.ws.AmbienteTrabalhoMinWsVo;
import br.com.fiorilli.sipweb.vo.ws.AmbienteTrabalhoWsVo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.validation.constraints.Size;
import org.apache.commons.lang3.StringUtils;

@Entity
@Table(name="AMBIENTE_TRABALHO")
public class AmbienteTrabalho
implements Serializable {
    public static final String QUERY_FIND_BY_ENTIDADE_TO_WS = "SELECT new " + AmbienteTrabalhoMinWsVo.class.getCanonicalName() + "(a.pk.codigo, a.nome) " + "FROM AmbienteTrabalho a " + "WHERE a.pk.entidade = :entidade";
    public static final String QUERY_FIND_BY_PK_TO_WS = "SELECT new " + AmbienteTrabalhoWsVo.class.getCanonicalName() + "(a) " + "FROM AmbienteTrabalho a " + "WHERE a.pk = :pk";
    private static final long serialVersionUID = 1L;
    @EmbeddedId
    private AmbienteTrabalhoPK pk;
    @Column(name="NOME")
    @Size(max=2048)
    private String nome;
    @Column(name="IDENTIFICADOR")
    @Size(max=18)
    private String identificador;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="EMPRESA", referencedColumnName="CODIGO", insertable=false, updatable=false)
    private Entidade entidade;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="ambienteTrabalho")
    private List<Trabalhador> trabalhadores;
    @OneToMany(fetch=FetchType.EAGER, mappedBy="ambienteTrabalho", cascade={CascadeType.ALL})
    private List<AmbienteTrabalhoFatorRisco> fatoresRisco;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="ambienteTrabalho", cascade={CascadeType.ALL})
    private List<PericiaNova> pericias;
    @Column(name="ATIVIDADE")
    @Size(max=512)
    private String descricaoAtividade;

    public AmbienteTrabalhoPK getPk() {
        return this.pk;
    }

    public void setPk(AmbienteTrabalhoPK pk) {
        this.pk = pk;
    }

    public String getNome() {
        return this.nome;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public String getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(String identificador) {
        this.identificador = identificador;
    }

    public Entidade getEntidade() {
        return this.entidade;
    }

    public void setEntidade(Entidade entidade) {
        this.entidade = entidade;
    }

    public List<Trabalhador> getTrabalhadores() {
        return this.trabalhadores;
    }

    public void setTrabalhadores(List<Trabalhador> trabalhadores) {
        this.trabalhadores = trabalhadores;
    }

    public List<AmbienteTrabalhoFatorRisco> getFatoresRisco() {
        return this.fatoresRisco;
    }

    public void setFatoresRisco(List<AmbienteTrabalhoFatorRisco> fatoresRiscos) {
        this.fatoresRisco = fatoresRiscos;
    }

    public List<PericiaNova> getPericias() {
        return this.pericias;
    }

    public void setPericias(List<PericiaNova> pericias) {
        this.pericias = pericias;
    }

    private List<String> getRiscos(GrupoFatorRisco grupoFatorRisco) {
        ArrayList<String> riscos = new ArrayList<String>();
        if (this.fatoresRisco != null) {
            for (AmbienteTrabalhoFatorRisco ambTrabfatorRisco : this.fatoresRisco) {
                if (!grupoFatorRisco.isFromTheGroup(ambTrabfatorRisco.getFatorRisco().getCodigo())) continue;
                riscos.add(ambTrabfatorRisco.getFatorRisco().toString());
            }
        }
        Collections.sort(riscos);
        return riscos;
    }

    private String riscosToString(List<String> riscos) {
        if (riscos.isEmpty()) {
            return "Aus\u00eancia de Risco";
        }
        return StringUtils.join(riscos, (String)", ");
    }

    public String getRiscosBiologicos() {
        List<String> riscos = this.getRiscos(GrupoFatorRisco.BIOLOGICOS);
        return this.riscosToString(riscos);
    }

    public String getRiscosQuimicos() {
        List<String> riscos = this.getRiscos(GrupoFatorRisco.QUIMICOS);
        return this.riscosToString(riscos);
    }

    public String getRiscosFisicos() {
        List<String> riscos = this.getRiscos(GrupoFatorRisco.FISICOS);
        return this.riscosToString(riscos);
    }

    public String getRiscosErgonomicos() {
        List<String> riscos = this.getRiscos(GrupoFatorRisco.ERGONOMICOS);
        return this.riscosToString(riscos);
    }

    public String getRiscosAcidentes() {
        List<String> riscos = this.getRiscos(GrupoFatorRisco.ACIDENTES);
        return this.riscosToString(riscos);
    }

    public String getDescricaoAtividade() {
        return this.descricaoAtividade;
    }

    public void setDescricaoAtividade(String descricaoAtividade) {
        this.descricaoAtividade = descricaoAtividade;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AmbienteTrabalho that = (AmbienteTrabalho)o;
        return Objects.equals(this.pk, that.pk);
    }

    public int hashCode() {
        return Objects.hash(this.pk);
    }
}

