/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.sip.persistence.api.AliquotaNacional;
import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.AliquotaPrevidenciaUsuario;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.NumberFormat;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@Entity
@Table(name="ALIQPREVUSUARIO_ITENS")
@Audited
public class AliquotaPrevidenciaUsuarioItem
implements Serializable,
AliquotaNacional {
    private static final long serialVersionUID = 1L;
    public static final String FIND_BY_PK_MES_ANO = "SELECT a FROM AliquotaPrevidenciaUsuarioItem a WHERE a.tabelaCodigo = :tabelaCodigo   AND a.ano = :ano   AND a.mes = :mes ORDER BY a.faixa";
    public static final String GENERATOR = "GEN_CODIGO_ALIQPREVUSRITENS";
    @Id
    @Basic(optional=false)
    @NotNull
    @Column(name="CODIGO")
    private Integer codigo;
    @Basic(optional=false)
    @NotNull
    @Size(min=1, max=4)
    @Column(name="ANO")
    private String ano;
    @Basic(optional=false)
    @NotNull
    @Size(min=1, max=2)
    @Column(name="MES")
    private String mes;
    @Basic(optional=false)
    @NotNull
    @Column(name="FAIXA")
    private Short faixa;
    @Column(name="DE")
    private BigDecimal de;
    @Column(name="ATE")
    private BigDecimal ate;
    @Column(name="ALIQUOTA")
    private BigDecimal aliquota;
    @Column(name="TABELA")
    private Integer tabelaCodigo;
    @Column(name="EMPRESA")
    private String entidadeCodigo;
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="TABELA", referencedColumnName="CODIGO", insertable=false, updatable=false)})
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private AliquotaPrevidenciaUsuario aliquotaPrevidenciaUsuario;

    public AliquotaPrevidenciaUsuarioItem() {
    }

    public AliquotaPrevidenciaUsuarioItem(Integer codigo) {
        this.codigo = codigo;
    }

    public AliquotaPrevidenciaUsuarioItem(Integer codigo, String ano, String mes, short faixa) {
        this.codigo = codigo;
        this.ano = ano;
        this.mes = mes;
        this.faixa = faixa;
    }

    public Integer getCodigo() {
        return this.codigo;
    }

    public void setCodigo(Integer codigo) {
        this.codigo = codigo;
    }

    @Override
    public String getAno() {
        return this.ano;
    }

    @Override
    public void setAno(String ano) {
        this.ano = ano;
    }

    @Override
    public String getMes() {
        return this.mes;
    }

    @Override
    public void setMes(String mes) {
        this.mes = mes;
    }

    @Override
    public BigDecimal getDe() {
        return this.de;
    }

    @Override
    public void setDe(BigDecimal de) {
        this.de = de;
    }

    @Override
    public BigDecimal getAte() {
        return this.ate;
    }

    public void setAte(BigDecimal ate) {
        this.ate = ate;
    }

    public BigDecimal getAliquota() {
        return this.aliquota;
    }

    public void setAliquota(BigDecimal aliquota) {
        this.aliquota = aliquota;
    }

    public AliquotaPrevidenciaUsuario getAliquotaPrevidenciaUsuario() {
        return this.aliquotaPrevidenciaUsuario;
    }

    public Integer getTabelaCodigo() {
        return this.tabelaCodigo;
    }

    public void setTabelaCodigo(Integer aliquotaPrevidenciaUsuarioId) {
        this.tabelaCodigo = aliquotaPrevidenciaUsuarioId;
    }

    public void setAliquotaPrevidenciaUsuario(AliquotaPrevidenciaUsuario aliquotaPrevidenciaUsuario) {
        if (aliquotaPrevidenciaUsuario != null) {
            this.entidadeCodigo = aliquotaPrevidenciaUsuario.getAliquotaPrevidenciaUsuarioPK().getEntidade();
            this.tabelaCodigo = aliquotaPrevidenciaUsuario.getAliquotaPrevidenciaUsuarioPK().getCodigo();
        } else {
            this.entidadeCodigo = null;
            this.tabelaCodigo = null;
        }
        this.aliquotaPrevidenciaUsuario = aliquotaPrevidenciaUsuario;
    }

    @Override
    public Short getFaixa() {
        return this.faixa;
    }

    @Override
    public void setFaixa(Short faixa) {
        this.faixa = faixa;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.codigo == null ? 0 : this.codigo.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AliquotaPrevidenciaUsuarioItem other = (AliquotaPrevidenciaUsuarioItem)obj;
        return !(this.codigo == null ? other.codigo != null : !this.codigo.equals(other.codigo));
    }

    public String toString() {
        return "AliquotaPrevidenciaUsuarioItem [codigo=" + this.codigo + "mes=" + this.mes + "/" + this.ano + ", faixa=" + this.faixa + ", de=" + NumberFormat.getCurrencyInstance().format(this.de) + ", ate=" + NumberFormat.getCurrencyInstance().format(this.ate) + ", aliquota=" + NumberFormat.getNumberInstance().format(this.aliquota) + "%]";
    }

    public String getEntidadeCodigo() {
        return this.entidadeCodigo;
    }

    public void setEntidadeCodigo(String entidadeCodigo) {
        this.entidadeCodigo = entidadeCodigo;
    }
}

