/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.filter.annotations.FilterConfig;
import br.com.fiorilli.filter.annotations.FilterConfigSelect;
import br.com.fiorilli.filter.model.FilterCondition;
import br.com.fiorilli.filter.model.FilterInputType;
import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.AliquotaPrevidenciaUsuarioItem;
import br.com.fiorilli.sip.persistence.entity.AliquotaPrevidenciaUsuarioPK;
import br.com.fiorilli.sip.persistence.entity.Evento;
import java.io.Serializable;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.validation.constraints.Size;

@Entity
@Table(name="ALIQPREVUSUARIO")
@Audited
public class AliquotaPrevidenciaUsuario
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String FIND_BY_ENTIDADE = "SELECT a FROM AliquotaPrevidenciaUsuario a WHERE a.eventoEntidadeCodigo = :entidadeCodigo ORDER BY a.nome";
    @EmbeddedId
    private AliquotaPrevidenciaUsuarioPK aliquotaPrevidenciaUsuarioPK;
    @FilterConfig(label="Nome", condition=FilterCondition.COMECE, order=2)
    @Size(max=60)
    @Column(name="NOME")
    private String nome;
    @OneToMany(cascade={CascadeType.REMOVE}, mappedBy="aliquotaPrevidenciaUsuario", fetch=FetchType.LAZY)
    private List<AliquotaPrevidenciaUsuarioItem> aliquotaPrevidenciaUsuarioItens;
    @Size(min=1, max=3)
    @Column(name="EVENTO")
    private String eventoCodigo;
    @Size(min=1, max=3)
    @Column(name="EMPRESA_EVENTO")
    private String eventoEntidadeCodigo;
    @FilterConfig(label="Evento", inputType=FilterInputType.AUTO_COMPLETE, order=3)
    @FilterConfigSelect(query="SELECT e FROM Evento e WHERE UPPER(concat(e.eventoPK.codigo, e.nome)) LIKE UPPER(concat('%', :param, '%')) AND e.eventoPK.entidade = :entidadeCodigo ORDER BY e.nome")
    @JoinColumns(value={@JoinColumn(name="EMPRESA_EVENTO", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="EVENTO", referencedColumnName="CODIGO", insertable=false, updatable=false)})
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private Evento evento;

    public static AliquotaPrevidenciaUsuario createInitialized(String codigoEntidade) {
        AliquotaPrevidenciaUsuario a = new AliquotaPrevidenciaUsuario();
        a.setAliquotaPrevidenciaUsuarioPK(new AliquotaPrevidenciaUsuarioPK());
        a.getAliquotaPrevidenciaUsuarioPK().setEntidade(codigoEntidade);
        return a;
    }

    public String getNome() {
        return this.nome;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public List<AliquotaPrevidenciaUsuarioItem> getAliquotaPrevidenciaUsuarioItens() {
        return this.aliquotaPrevidenciaUsuarioItens;
    }

    public void setAliquotaPrevidenciaUsuarioItens(List<AliquotaPrevidenciaUsuarioItem> aliqprevusuarioItensList) {
        this.aliquotaPrevidenciaUsuarioItens = aliqprevusuarioItensList;
    }

    public Evento getEvento() {
        return this.evento;
    }

    public void setEvento(Evento evento) {
        if (evento != null) {
            this.eventoCodigo = evento.getEventoPK().getCodigo();
            this.eventoEntidadeCodigo = evento.getEventoPK().getEntidade();
        } else {
            this.eventoCodigo = null;
            this.eventoEntidadeCodigo = null;
        }
        this.evento = evento;
    }

    public String getEventoCodigo() {
        return this.eventoCodigo;
    }

    public void setEventoCodigo(String eventoCodigo) {
        this.eventoCodigo = eventoCodigo;
    }

    public String getEventoEntidadeCodigo() {
        return this.eventoEntidadeCodigo;
    }

    public void setEventoEntidadeCodigo(String eventoEntidadeCodigo) {
        this.eventoEntidadeCodigo = eventoEntidadeCodigo;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.aliquotaPrevidenciaUsuarioPK == null ? 0 : this.aliquotaPrevidenciaUsuarioPK.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AliquotaPrevidenciaUsuario other = (AliquotaPrevidenciaUsuario)obj;
        return !(this.aliquotaPrevidenciaUsuarioPK == null ? other.aliquotaPrevidenciaUsuarioPK != null : !this.aliquotaPrevidenciaUsuarioPK.equals(other.aliquotaPrevidenciaUsuarioPK));
    }

    public String toString() {
        return "AliquotaPrevidenciaUsuario [aliquotaPrevidenciaUsuarioPK=" + this.aliquotaPrevidenciaUsuarioPK + "]";
    }

    public AliquotaPrevidenciaUsuarioPK getAliquotaPrevidenciaUsuarioPK() {
        return this.aliquotaPrevidenciaUsuarioPK;
    }

    public void setAliquotaPrevidenciaUsuarioPK(AliquotaPrevidenciaUsuarioPK aliquotaPrevidenciaUsuarioPK) {
        this.aliquotaPrevidenciaUsuarioPK = aliquotaPrevidenciaUsuarioPK;
    }
}

