/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.sip.persistence.api.AliquotaMunicipal;
import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.AliquotaPrevidenciaMunicipalPK;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.NumberFormat;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.Table;

@Entity
@Table(name="ALIQINSSMUNICIPAL")
@Audited
public class AliquotaPrevidenciaMunicipal
implements Serializable,
AliquotaMunicipal {
    private static final long serialVersionUID = 1L;
    @EmbeddedId
    protected AliquotaPrevidenciaMunicipalPK pk;
    @Column(name="DE")
    private BigDecimal de;
    @Column(name="ATE")
    private BigDecimal ate;
    @Column(name="PREVIDENCIA")
    private BigDecimal previdencia;
    @Column(name="IRRF")
    private BigDecimal irrf;
    @Column(name="MES", insertable=false, updatable=false)
    private String mes;
    @Column(name="ANO", insertable=false, updatable=false)
    private String ano;
    @Column(name="FAIXA", insertable=false, updatable=false)
    private Short faixa;
    @Column(name="EMPRESA", insertable=false, updatable=false)
    private String entidade;

    public AliquotaPrevidenciaMunicipal() {
        this.pk = new AliquotaPrevidenciaMunicipalPK();
    }

    public AliquotaPrevidenciaMunicipal(AliquotaPrevidenciaMunicipalPK pk) {
        this.pk = pk;
    }

    public AliquotaPrevidenciaMunicipal(String entidade, String ano, String mes, short faixa) {
        this.pk = new AliquotaPrevidenciaMunicipalPK(entidade, ano, mes, faixa);
    }

    public AliquotaPrevidenciaMunicipalPK getPk() {
        return this.pk;
    }

    public void setPk(AliquotaPrevidenciaMunicipalPK pk) {
        this.pk = pk;
    }

    @Override
    public BigDecimal getDe() {
        return this.de;
    }

    @Override
    public void setDe(BigDecimal de) {
        this.de = de;
    }

    @Override
    public BigDecimal getAte() {
        return this.ate;
    }

    public void setAte(BigDecimal ate) {
        this.ate = ate;
    }

    public BigDecimal getPrevidencia() {
        return this.previdencia;
    }

    public void setPrevidencia(BigDecimal previdencia) {
        this.previdencia = previdencia;
    }

    public BigDecimal getIrrf() {
        return this.irrf;
    }

    public void setIrrf(BigDecimal irrf) {
        this.irrf = irrf;
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.pk != null ? this.pk.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof AliquotaPrevidenciaMunicipal)) {
            return false;
        }
        AliquotaPrevidenciaMunicipal other = (AliquotaPrevidenciaMunicipal)object;
        return (this.pk != null || other.pk == null) && (this.pk == null || this.pk.equals(other.pk));
    }

    public String toString() {
        return "AliquotaPrevidenciaMunicipal [mes=" + this.mes + "/" + this.ano + ", faixa=" + this.faixa + ", de=" + NumberFormat.getCurrencyInstance().format(this.de) + ", ate=" + NumberFormat.getCurrencyInstance().format(this.ate) + ", previdencia=" + NumberFormat.getNumberInstance().format(this.previdencia) + "%]";
    }

    @Override
    public Short getFaixa() {
        return this.pk.getFaixa();
    }

    @Override
    public String getAno() {
        return this.pk.getAno();
    }

    @Override
    public String getMes() {
        return this.pk.getMes();
    }

    @Override
    public void setFaixa(Short faixa) {
        this.pk.setFaixa(faixa);
    }

    @Override
    public void setAno(String ano) {
        this.pk.setAno(ano);
    }

    @Override
    public void setMes(String mes) {
        this.pk.setMes(mes);
    }

    @Override
    public String getEntidade() {
        return this.pk.getEntidade();
    }

    @Override
    public void setEntidade(String entidadeCodigo) {
        this.pk.setEntidade(entidadeCodigo);
    }
}

