/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.sip.persistence.api.AliquotaNacional;
import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.AliquotaIRRFPK;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.NumberFormat;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.Table;

@Entity
@Table(name="ALIQIRRF")
@Audited
public class AliquotaIRRF
implements Serializable,
AliquotaNacional {
    private static final long serialVersionUID = 1L;
    @EmbeddedId
    protected AliquotaIRRFPK pk;
    @Column(name="MES", insertable=false, updatable=false)
    private String mes;
    @Column(name="ANO", insertable=false, updatable=false)
    private String ano;
    @Column(name="FAIXA", insertable=false, updatable=false)
    private Short faixa;
    @Column(name="DE")
    private BigDecimal de;
    @Column(name="ATE")
    private BigDecimal ate;
    @Column(name="ALIQUOTA")
    private BigDecimal aliquota;
    @Column(name="DEDUCAO")
    private BigDecimal deducao;
    @Column(name="DEPENDENTE")
    private BigDecimal dependente;
    @Column(name="APOSENTADO")
    private BigDecimal aposentado;
    @Column(name="DEDUZBASECALC")
    private BigDecimal deduzBaseCalculo;

    public AliquotaIRRF() {
        this.pk = new AliquotaIRRFPK();
    }

    public AliquotaIRRF(String mes, String ano, Short faixa, BigDecimal de, BigDecimal ate, BigDecimal aliquota, BigDecimal deducao, BigDecimal dependente, BigDecimal aposentado, BigDecimal deduzBaseCalculo) {
        this.mes = mes;
        this.ano = ano;
        this.faixa = faixa;
        this.de = de;
        this.ate = ate;
        this.aliquota = aliquota;
        this.deducao = deducao;
        this.dependente = dependente;
        this.aposentado = aposentado;
        this.deduzBaseCalculo = deduzBaseCalculo;
    }

    public AliquotaIRRF(AliquotaIRRFPK aliquotaIrrfPK) {
        this.pk = aliquotaIrrfPK;
    }

    public AliquotaIRRF(String ano, String mes, short faixa) {
        this.pk = new AliquotaIRRFPK(ano, mes, faixa);
    }

    public AliquotaIRRFPK getPk() {
        return this.pk;
    }

    public void setPk(AliquotaIRRFPK aliquotaIrrfPK) {
        this.pk = aliquotaIrrfPK;
    }

    @Override
    public BigDecimal getDe() {
        return this.de;
    }

    @Override
    public void setDe(BigDecimal de) {
        this.de = de;
    }

    @Override
    public BigDecimal getAte() {
        return this.ate;
    }

    public void setAte(BigDecimal ate) {
        this.ate = ate;
    }

    public BigDecimal getAliquota() {
        return this.aliquota;
    }

    public void setAliquota(BigDecimal aliquota) {
        this.aliquota = aliquota;
    }

    public BigDecimal getDeducao() {
        return this.deducao;
    }

    public void setDeducao(BigDecimal deducao) {
        this.deducao = deducao;
    }

    public BigDecimal getDependente() {
        return this.dependente;
    }

    public void setDependente(BigDecimal dependente) {
        this.dependente = dependente;
    }

    public BigDecimal getAposentado() {
        return this.aposentado;
    }

    public void setAposentado(BigDecimal aposentado) {
        this.aposentado = aposentado;
    }

    public BigDecimal getDeduzBaseCalculo() {
        return this.deduzBaseCalculo;
    }

    public void setDeduzBaseCalculo(BigDecimal deduzbasecalc) {
        this.deduzBaseCalculo = deduzbasecalc;
    }

    @Override
    public Short getFaixa() {
        return this.pk.getFaixa();
    }

    @Override
    public void setFaixa(Short faixa) {
        this.pk.setFaixa(faixa);
    }

    @Override
    public String getAno() {
        return this.pk.getAno();
    }

    @Override
    public void setAno(String ano) {
        this.pk.setAno(ano);
    }

    @Override
    public String getMes() {
        return this.pk.getMes();
    }

    @Override
    public void setMes(String mes) {
        this.pk.setMes(mes);
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.pk != null ? this.pk.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof AliquotaIRRF)) {
            return false;
        }
        AliquotaIRRF other = (AliquotaIRRF)object;
        return (this.pk != null || other.pk == null) && (this.pk == null || this.pk.equals(other.pk));
    }

    public String toString() {
        return "AliquotaIRRF [mes=" + this.mes + "/" + this.ano + ", faixa=" + this.faixa + ", de=" + NumberFormat.getCurrencyInstance().format(this.de) + ", ate=" + NumberFormat.getCurrencyInstance().format(this.ate) + ", aliquota=" + NumberFormat.getNumberInstance().format(this.aliquota) + "%]";
    }
}

