/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.sip.persistence.api.AliquotaNacional;
import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.AliquotaINSSPK;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.NumberFormat;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.Table;

@Entity
@Table(name="ALIQINSSNACIONAL")
@Audited
public class AliquotaINSS
implements Serializable,
AliquotaNacional {
    private static final long serialVersionUID = 1L;
    public static final String FIND_TETO_PROVIDENCIA = "SELECT MAX(a.ate) FROM AliquotaINSS a WHERE a.ano = :ano AND a.mes = :mes";
    @EmbeddedId
    protected AliquotaINSSPK pk;
    @Column(name="MES", insertable=false, updatable=false)
    private String mes;
    @Column(name="ANO", insertable=false, updatable=false)
    private String ano;
    @Column(name="FAIXA", insertable=false, updatable=false)
    private Short faixa;
    @Column(name="DE")
    private BigDecimal de;
    @Column(name="ATE")
    private BigDecimal ate;
    @Column(name="PREVIDENCIA")
    private BigDecimal previdencia;
    @Column(name="IRRF")
    private BigDecimal irrf;

    public AliquotaINSS() {
        this.pk = new AliquotaINSSPK();
    }

    public AliquotaINSS(AliquotaINSSPK pk) {
        this.pk = pk;
    }

    public AliquotaINSS(String ano, String mes, short faixa) {
        this.pk = new AliquotaINSSPK(ano, mes, faixa);
    }

    public AliquotaINSSPK getPk() {
        return this.pk;
    }

    public void setPk(AliquotaINSSPK aliquotaINSSPK) {
        this.pk = aliquotaINSSPK;
    }

    @Override
    public BigDecimal getDe() {
        return this.de;
    }

    @Override
    public void setDe(BigDecimal de) {
        this.de = de;
    }

    @Override
    public BigDecimal getAte() {
        return this.ate;
    }

    public void setAte(BigDecimal ate) {
        this.ate = ate;
    }

    public BigDecimal getPrevidencia() {
        return this.previdencia;
    }

    public void setPrevidencia(BigDecimal previdencia) {
        this.previdencia = previdencia;
    }

    public BigDecimal getIrrf() {
        return this.irrf;
    }

    public void setIrrf(BigDecimal irrf) {
        this.irrf = irrf;
    }

    @Override
    public Short getFaixa() {
        return this.pk.getFaixa();
    }

    @Override
    public void setFaixa(Short faixa) {
        this.pk.setFaixa(faixa);
    }

    @Override
    public String getAno() {
        return this.pk.getAno();
    }

    @Override
    public void setAno(String ano) {
        this.pk.setAno(ano);
    }

    @Override
    public String getMes() {
        return this.pk.getMes();
    }

    @Override
    public void setMes(String mes) {
        this.pk.setMes(mes);
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.pk != null ? this.pk.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof AliquotaINSS)) {
            return false;
        }
        AliquotaINSS other = (AliquotaINSS)object;
        return (this.pk != null || other.pk == null) && (this.pk == null || this.pk.equals(other.pk));
    }

    public String toString() {
        return "AliquotaINSS [mes=" + this.mes + "/" + this.ano + ", faixa=" + this.faixa + ", de=" + NumberFormat.getCurrencyInstance().format(this.de) + ", ate=" + NumberFormat.getCurrencyInstance().format(this.ate) + ", aliquota=" + NumberFormat.getNumberInstance().format(this.previdencia) + "%]";
    }
}

