/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.JornadaEventual;
import br.com.fiorilli.sip.persistence.entity.Referencia;
import br.com.fiorilli.sip.persistence.entity.Trabalhador;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@Entity
@Table(name="AGENDAMENTO_JORNADAS")
@Audited
public class AgendamentoDeJornada
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String GENERATOR = "GEN_AGENDAMENTO_JORNADAS";
    @Id
    @Column(name="ID")
    private Integer id;
    @NotNull
    @Column(name="EMPRESA")
    @Size(min=1, max=3)
    private String entidadeCodigo;
    @NotNull
    @Size(min=1, max=6)
    @Column(name="REGISTRO")
    private String registro;
    @NotNull
    @Column(name="REFERENCIA")
    private Integer referenciaCodigo;
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="REGISTRO", referencedColumnName="REGISTRO", insertable=false, updatable=false)})
    @ManyToOne(fetch=FetchType.LAZY)
    private Trabalhador trabalhador;
    @JoinColumn(name="REFERENCIA", referencedColumnName="CODIGO", insertable=false, updatable=false)
    @ManyToOne(fetch=FetchType.LAZY)
    private Referencia referencia;
    @OneToMany(mappedBy="agendamento", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<JornadaEventual> jornadaEventuais;

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getEntidadeCodigo() {
        return this.entidadeCodigo;
    }

    public void setEntidadeCodigo(String entidadeCodigo) {
        this.entidadeCodigo = entidadeCodigo;
    }

    public String getRegistro() {
        return this.registro;
    }

    public void setRegistro(String registro) {
        this.registro = registro;
    }

    public Integer getReferenciaCodigo() {
        return this.referenciaCodigo;
    }

    public void setReferenciaCodigo(Integer referenciaCodigo) {
        this.referenciaCodigo = referenciaCodigo;
    }

    public Trabalhador getTrabalhador() {
        return this.trabalhador;
    }

    public void setTrabalhador(Trabalhador trabalhador) {
        this.trabalhador = trabalhador;
    }

    public Referencia getReferencia() {
        return this.referencia;
    }

    public void setReferencia(Referencia referencia) {
        this.referencia = referencia;
    }

    public List<JornadaEventual> getJornadaEventuais() {
        if (this.jornadaEventuais == null) {
            this.jornadaEventuais = new ArrayList<JornadaEventual>();
        }
        return this.jornadaEventuais;
    }

    public boolean add(JornadaEventual jornadaEventual) {
        jornadaEventual.setAgendamento(this);
        return this.getJornadaEventuais().add(jornadaEventual);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AgendamentoDeJornada that = (AgendamentoDeJornada)o;
        return Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public String toString() {
        return "AgendamentoDeJornada{id=" + this.id + ", entidadeCodigo='" + this.entidadeCodigo + '\'' + ", registro='" + this.registro + '\'' + ", referenciaCodigo=" + this.referenciaCodigo + ", trabalhador=" + this.trabalhador + ", referencia=" + this.referencia + '}';
    }
}

