/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.filter.annotations.FilterConfig;
import br.com.fiorilli.filter.annotations.FilterConfigJoin;
import br.com.fiorilli.filter.annotations.FilterConfigSelect;
import br.com.fiorilli.filter.model.FilterInputType;
import br.com.fiorilli.filter.model.FilterJoinType;
import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.AgenciaPK;
import br.com.fiorilli.sip.persistence.entity.Banco;
import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.validation.constraints.Size;

@Entity
@Table(name="AGENCIAS")
@Audited
public class Agencia
implements Serializable {
    private static final long serialVersionUID = 3397085869236658768L;
    public static final String FIND_BY_NUMERO_BANCO = "SELECT ag FROM Agencia ag LEFT JOIN FETCH ag.banco ba WHERE ag.agenciaPK.entidade = :entidadeCodigo AND (ag.agencia LIKE :valor OR LOWER(ba.nome) LIKE :valor) ORDER BY ba.nome";
    public static final String FIND_BY_PK = "SELECT ag FROM Agencia ag LEFT JOIN FETCH ag.banco ba WHERE ag.agenciaPK = :pk";
    @EmbeddedId
    protected AgenciaPK agenciaPK;
    @Size(max=6)
    @Column(name="AGENCIA")
    @FilterConfig(label="Ag\u00eancia")
    private String agencia;
    @Column(name="DVAGENCIA")
    private Character digitoVerificador;
    @Size(max=60)
    @Column(name="NOME")
    private String nome;
    @Size(max=60)
    @Column(name="CONTATO")
    private String contato;
    @Size(max=60)
    @Column(name="GERENTE")
    private String gerente;
    @Size(max=11)
    @Column(name="TELEFONE")
    private String telefone;
    @Size(max=11)
    @Column(name="FAX")
    private String fax;
    @FilterConfigJoin(type=FilterJoinType.LEFT, fetch=true)
    @JoinColumn(name="BANCO", referencedColumnName="CODIGO", insertable=false, updatable=false)
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    @FilterConfig(label="Banco", inputType=FilterInputType.AUTO_COMPLETE)
    @FilterConfigSelect(query="SELECT b FROM Banco b WHERE (b.nome LIKE :param||'%') OR (b.codigo = :param)")
    private Banco banco;

    public Agencia() {
        this.agenciaPK = new AgenciaPK();
    }

    public Agencia(AgenciaPK agenciaPK) {
        this.agenciaPK = agenciaPK;
    }

    public Agencia(String entidade, String banco, short item) {
        this.agenciaPK = new AgenciaPK(entidade, banco, item);
    }

    public AgenciaPK getAgenciaPK() {
        return this.agenciaPK;
    }

    public void setAgenciaPK(AgenciaPK agenciaPK) {
        this.agenciaPK = agenciaPK;
    }

    public String getAgencia() {
        return this.agencia;
    }

    public void setAgencia(String agencia) {
        this.agencia = agencia;
    }

    public Character getDigitoVerificador() {
        return this.digitoVerificador;
    }

    public void setDigitoVerificador(Character dvagencia) {
        this.digitoVerificador = dvagencia;
    }

    public String getNome() {
        return this.nome;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public String getContato() {
        return this.contato;
    }

    public void setContato(String contato) {
        this.contato = contato;
    }

    public String getGerente() {
        return this.gerente;
    }

    public void setGerente(String gerente) {
        this.gerente = gerente;
    }

    public String getTelefone() {
        return this.telefone;
    }

    public void setTelefone(String telefone) {
        this.telefone = telefone;
    }

    public String getFax() {
        return this.fax;
    }

    public void setFax(String fax) {
        this.fax = fax;
    }

    public Banco getBanco() {
        return this.banco;
    }

    public void setBanco(Banco banco) {
        if (banco != null) {
            this.agenciaPK.setBanco(banco.getCodigo());
        } else {
            this.agenciaPK.setBanco(null);
        }
        this.banco = banco;
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.agenciaPK != null ? this.agenciaPK.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Agencia)) {
            return false;
        }
        Agencia other = (Agencia)object;
        return (this.agenciaPK != null || other.agenciaPK == null) && (this.agenciaPK == null || this.agenciaPK.equals(other.agenciaPK));
    }

    public String toString() {
        return "entity.Agencia[ agenciaPK=" + this.agenciaPK + " ]";
    }
}

