/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.component.layout;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.logging.Logger;
import javax.el.ValueExpression;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.AjaxBehaviorEvent;
import javax.faces.event.FacesEvent;
import org.apache.commons.lang3.StringUtils;
import org.primefaces.component.api.Widget;
import org.primefaces.extensions.component.layout.LayoutPane;
import org.primefaces.extensions.event.CloseEvent;
import org.primefaces.extensions.event.OpenEvent;
import org.primefaces.extensions.event.ResizeEvent;
import org.primefaces.extensions.util.FastStringWriter;
import org.primefaces.util.ComponentUtils;

@ResourceDependencies(value={@ResourceDependency(library="primefaces", name="jquery/jquery.js"), @ResourceDependency(library="primefaces", name="jquery/jquery-plugins.js"), @ResourceDependency(library="primefaces", name="core.js"), @ResourceDependency(library="primefaces-extensions", name="primefaces-extensions.js"), @ResourceDependency(library="primefaces-extensions", name="layout/layout.css"), @ResourceDependency(library="primefaces-extensions", name="layout/layout.js")})
public class Layout
extends UIComponentBase
implements Widget,
ClientBehaviorHolder {
    private static final Logger LOG = Logger.getLogger(Layout.class.getName());
    public static final String COMPONENT_TYPE = "org.primefaces.extensions.component.Layout";
    public static final String COMPONENT_FAMILY = "org.primefaces.extensions.component";
    private static final String DEFAULT_RENDERER = "org.primefaces.extensions.component.LayoutRenderer";
    public static final String POSITION_SEPARATOR = "_";
    public static final String STYLE_CLASS_PANE = "ui-widget-content ui-corner-all";
    public static final String STYLE_CLASS_PANE_WITH_SUBPANES = "ui-corner-all pe-layout-pane-withsubpanes";
    public static final String STYLE_CLASS_PANE_HEADER = "ui-widget-header ui-corner-top pe-layout-pane-header";
    public static final String STYLE_CLASS_PANE_CONTENT = "pe-layout-pane-content";
    public static final String STYLE_CLASS_LAYOUT_CONTENT = "ui-layout-content";
    public static final String PANE_POSITION_CENTER = "center";
    public static final String PANE_POSITION_NORTH = "north";
    public static final String PANE_POSITION_SOUTH = "south";
    public static final String PANE_POSITION_WEST = "west";
    public static final String PANE_POSITION_EAST = "east";
    private static final Collection<String> EVENT_NAMES = Collections.unmodifiableCollection(Arrays.asList("open", "close", "resize"));
    private ResponseWriter originalWriter;
    private FastStringWriter fsw;
    private boolean buildOptions;

    public Layout() {
        this.setRendererType(DEFAULT_RENDERER);
    }

    public String getFamily() {
        return COMPONENT_FAMILY;
    }

    public String getWidgetVar() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.widgetVar), null);
    }

    public void setWidgetVar(String widgetVar) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.widgetVar), (Object)widgetVar);
    }

    public boolean isFullPage() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.fullPage), (Object)true);
    }

    public void setFullPage(boolean fullPage) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.fullPage), (Object)fullPage);
    }

    public Object getOptions() {
        return this.getStateHelper().eval((Serializable)((Object)PropertyKeys.options), null);
    }

    public void setOptions(Object options) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.options), options);
    }

    public String getStyle() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.style), null);
    }

    public void setStyle(String style) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.style), (Object)style);
    }

    public String getStyleClass() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.styleClass), null);
    }

    public void setStyleClass(String styleClass) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.styleClass), (Object)styleClass);
    }

    public String getState() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.state), null);
    }

    public void setState(String state) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.state), (Object)state);
    }

    public boolean isStateCookie() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.stateCookie), (Object)false);
    }

    public void setStateCookie(boolean stateCookie) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.stateCookie), (Object)stateCookie);
    }

    public String getTogglerTipOpen() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.togglerTip_open), null);
    }

    public void setTogglerTipOpen(String togglerTipOpen) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.togglerTip_open), (Object)togglerTipOpen);
    }

    public String getTogglerTipClosed() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.togglerTip_closed), null);
    }

    public void setTogglerTipClosed(String togglerTipClosed) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.togglerTip_closed), (Object)togglerTipClosed);
    }

    public String getResizerTip() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.resizerTip), null);
    }

    public void setResizerTip(String resizerTip) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.resizerTip), (Object)resizerTip);
    }

    public String getSliderTip() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.sliderTip), null);
    }

    public void setSliderTip(String sliderTip) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.sliderTip), (Object)sliderTip);
    }

    public boolean isMaskPanesEarly() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.maskPanesEarly), (Object)false);
    }

    public void setMaskPanesEarly(boolean maskPanesEarly) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.maskPanesEarly), (Object)maskPanesEarly);
    }

    public Collection<String> getEventNames() {
        return EVENT_NAMES;
    }

    public void processDecodes(FacesContext fc) {
        if (this.isSelfRequest(fc)) {
            this.decode(fc);
        } else {
            super.processDecodes(fc);
        }
    }

    public void processValidators(FacesContext fc) {
        if (!this.isSelfRequest(fc)) {
            super.processValidators(fc);
        }
    }

    public void processUpdates(FacesContext fc) {
        ValueExpression stateVE;
        String state;
        if (!this.isSelfRequest(fc)) {
            super.processUpdates(fc);
        }
        if (StringUtils.isNotBlank((CharSequence)(state = (String)fc.getExternalContext().getRequestParameterMap().get(this.getClientId(fc) + "_state"))) && (stateVE = this.getValueExpression(PropertyKeys.state.toString())) != null) {
            stateVE.setValue(fc.getELContext(), (Object)state);
            this.getStateHelper().remove((Serializable)((Object)PropertyKeys.state));
        }
    }

    public void queueEvent(FacesEvent event) {
        FacesContext context = FacesContext.getCurrentInstance();
        if (this.isSelfRequest(context)) {
            Map params = context.getExternalContext().getRequestParameterMap();
            String eventName = (String)params.get("javax.faces.behavior.event");
            String clientId = this.getClientId(context);
            AjaxBehaviorEvent behaviorEvent = (AjaxBehaviorEvent)event;
            LayoutPane pane = this.getLayoutPane((UIComponent)this, (String)params.get(clientId + "_pane"));
            if (pane == null) {
                LOG.warning("LayoutPane by request parameter '" + (String)params.get(clientId + "_pane") + "' was not found");
                return;
            }
            if ("open".equals(eventName)) {
                OpenEvent openEvent = new OpenEvent((UIComponent)pane, behaviorEvent.getBehavior());
                openEvent.setPhaseId(behaviorEvent.getPhaseId());
                super.queueEvent((FacesEvent)openEvent);
                return;
            }
            if ("close".equals(eventName)) {
                CloseEvent closeEvent = new CloseEvent((UIComponent)pane, behaviorEvent.getBehavior());
                closeEvent.setPhaseId(behaviorEvent.getPhaseId());
                super.queueEvent((FacesEvent)closeEvent);
                return;
            }
            if ("resize".equals(eventName)) {
                double width = Double.valueOf((String)params.get(clientId + "_width"));
                double height = Double.valueOf((String)params.get(clientId + "_height"));
                ResizeEvent resizeEvent = new ResizeEvent((UIComponent)pane, behaviorEvent.getBehavior(), width, height);
                resizeEvent.setPhaseId(behaviorEvent.getPhaseId());
                super.queueEvent((FacesEvent)resizeEvent);
                return;
            }
        }
        super.queueEvent(event);
    }

    public LayoutPane getLayoutPane(UIComponent component, String combinedPosition) {
        for (UIComponent child : component.getChildren()) {
            if (!(child instanceof LayoutPane)) continue;
            if (((LayoutPane)child).getCombinedPosition().equals(combinedPosition)) {
                return (LayoutPane)child;
            }
            LayoutPane pane = this.getLayoutPane(child, combinedPosition);
            if (pane == null) continue;
            return pane;
        }
        return null;
    }

    public ResponseWriter getOriginalWriter() {
        return this.originalWriter;
    }

    public void setOriginalWriter(ResponseWriter originalWriter) {
        this.originalWriter = originalWriter;
    }

    public FastStringWriter getFastStringWriter() {
        return this.fsw;
    }

    public void setFastStringWriter(FastStringWriter fsw) {
        this.fsw = fsw;
    }

    public boolean isBuildOptions() {
        return this.buildOptions;
    }

    public void setBuildOptions(boolean buildOptions) {
        this.buildOptions = buildOptions;
    }

    public void removeOptions() {
        this.getStateHelper().remove((Serializable)((Object)PropertyKeys.options));
    }

    private boolean isSelfRequest(FacesContext context) {
        return this.getClientId(context).equals(context.getExternalContext().getRequestParameterMap().get("javax.faces.source"));
    }

    public String resolveWidgetVar() {
        return ComponentUtils.resolveWidgetVar((FacesContext)this.getFacesContext(), (Widget)this);
    }

    public static enum PropertyKeys {
        widgetVar,
        fullPage,
        options,
        style,
        styleClass,
        state,
        stateCookie,
        togglerTip_open("Open"),
        togglerTip_closed("Close"),
        resizerTip("Resize"),
        sliderTip("Slide"),
        maskPanesEarly;

        private String toString;

        private PropertyKeys(String toString) {
            this.toString = toString;
        }

        private PropertyKeys() {
        }

        public String toString() {
            return this.toString != null ? this.toString : super.toString();
        }
    }
}

