/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.component.documentviewer;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import javax.faces.application.Resource;
import javax.faces.application.ResourceHandler;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.commons.lang3.StringUtils;
import org.primefaces.application.resource.DynamicContentType;
import org.primefaces.extensions.component.documentviewer.DocumentViewer;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.DynamicContentSrcBuilder;

public class DocumentViewerRenderer
extends CoreRenderer {
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        DocumentViewer documentViewer = (DocumentViewer)component;
        this.encodeMarkup(context, documentViewer);
    }

    private void encodeMarkup(FacesContext context, DocumentViewer documentViewer) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("iframe", (UIComponent)documentViewer);
        writer.writeAttribute("id", (Object)documentViewer.getClientId(), null);
        writer.writeAttribute("style", (Object)documentViewer.getStyle(), null);
        writer.writeAttribute("width", documentViewer.getWidth() != null ? documentViewer.getWidth() : "100%", null);
        writer.writeAttribute("height", (Object)documentViewer.getHeight(), null);
        writer.writeAttribute("allowfullscreen", (Object)"", null);
        writer.writeAttribute("webkitallowfullscreen", (Object)"", null);
        writer.writeAttribute("src", (Object)this.generateSrc(context, documentViewer), null);
        writer.endElement("iframe");
    }

    private String generateSrc(FacesContext context, DocumentViewer documentViewer) throws IOException {
        String imageSrc;
        try {
            imageSrc = URLEncoder.encode(this.getDocumentSource(context, documentViewer), "UTF-8");
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
        StringBuilder srcBuilder = new StringBuilder();
        srcBuilder.append(this.getResourceURL(context));
        srcBuilder.append("&file=");
        srcBuilder.append(imageSrc);
        srcBuilder.append(this.generateHashString(documentViewer));
        return srcBuilder.toString();
    }

    private String generateHashString(DocumentViewer documentViewer) {
        ArrayList<String> params = new ArrayList<String>(4);
        params.add("locale=" + documentViewer.calculateLocale().toString().replaceAll("_", "-"));
        if (documentViewer.getPage() != null) {
            params.add("page=" + documentViewer.getPage());
        }
        if (StringUtils.isNotBlank((CharSequence)documentViewer.getZoom())) {
            params.add("zoom=" + documentViewer.getZoom());
        }
        if (StringUtils.isNotBlank((CharSequence)documentViewer.getNameddest())) {
            params.add("nameddest=" + documentViewer.getNameddest());
        }
        if (StringUtils.isNotBlank((CharSequence)documentViewer.getPagemode())) {
            params.add("pagemode=" + documentViewer.getPagemode());
        }
        if (!params.isEmpty()) {
            return "#" + StringUtils.join(params, (String)"&");
        }
        return "";
    }

    private String getResourceURL(FacesContext context) {
        ResourceHandler handler = context.getApplication().getResourceHandler();
        return context.getExternalContext().encodeResourceURL(handler.createResource("documentviewer/pdfviewer.html", "primefaces-extensions").getRequestPath());
    }

    protected String getDocumentSource(FacesContext context, DocumentViewer documentViewer) throws UnsupportedEncodingException {
        String name = documentViewer.getName();
        if (name != null) {
            String libName = documentViewer.getLibrary();
            ResourceHandler handler = context.getApplication().getResourceHandler();
            Resource res = handler.createResource(name, libName);
            if (res == null) {
                return "RES_NOT_FOUND";
            }
            String requestPath = res.getRequestPath();
            return context.getExternalContext().encodeResourceURL(requestPath);
        }
        return DynamicContentSrcBuilder.build((FacesContext)context, (Object)documentViewer.getValue(), (UIComponent)documentViewer, (boolean)documentViewer.isCache(), (DynamicContentType)DynamicContentType.STREAMED_CONTENT, (boolean)true) + "&download=" + documentViewer.getDownload();
    }
}

