/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.component.analogclock;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.context.RequestContext;
import org.primefaces.extensions.component.analogclock.AnalogClock;
import org.primefaces.extensions.component.analogclock.model.AnalogClockColorModel;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.WidgetBuilder;

public class AnalogClockRenderer
extends CoreRenderer {
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        AnalogClock analogClock = (AnalogClock)component;
        this.encodeMarkup(context, analogClock);
        this.encodeScript(context, analogClock);
    }

    protected void encodeMarkup(FacesContext context, AnalogClock clock) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("div", (UIComponent)clock);
        writer.writeAttribute("id", (Object)clock.getClientId(), null);
        writer.endElement("div");
    }

    protected void encodeScript(FacesContext context, AnalogClock analogClock) throws IOException {
        String clientId = analogClock.getClientId();
        String widgetVar = analogClock.resolveWidgetVar();
        WidgetBuilder wb = RequestContext.getCurrentInstance().getWidgetBuilder();
        wb.initWithDomReady("ExtAnalogClock", widgetVar, clientId).attr("mode", analogClock.getMode()).attr("time", analogClock.getStartTime() != null ? Long.valueOf(analogClock.getStartTime().getTime()) : null);
        if (analogClock.getColorTheme() != null) {
            if (analogClock.getColorTheme() instanceof String) {
                wb.attr("colorTheme", analogClock.getColorTheme().toString());
            } else {
                AnalogClockColorModel model = (AnalogClockColorModel)analogClock.getColorTheme();
                wb.attr("themeObject", this.escapeText(model.toJson()));
            }
        }
        if (analogClock.getWidth() != null) {
            wb.attr("width", analogClock.getWidth().toString());
        }
        wb.finish();
    }
}

