/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.viewhandler;

import java.io.IOException;
import javax.faces.FacesException;
import javax.faces.FactoryFinder;
import javax.faces.application.ViewHandler;
import javax.faces.application.ViewHandlerWrapper;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.context.FacesContextWrapper;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;
import org.omnifaces.taghandler.EnableRestorableView;
import org.omnifaces.util.Faces;
import org.omnifaces.util.FacesLocal;

public class RestorableViewHandler
extends ViewHandlerWrapper {
    private ViewHandler wrapped;

    public RestorableViewHandler(ViewHandler wrapped) {
        this.wrapped = wrapped;
    }

    public UIViewRoot restoreView(FacesContext context, String viewId) {
        UIViewRoot restoredView = super.restoreView(context, viewId);
        if (!this.isEnabled(context) || restoredView != null || !context.isPostback()) {
            return restoredView;
        }
        String normalizedViewId = Faces.normalizeViewId(viewId);
        UIViewRoot createdView = this.createView(context, normalizedViewId);
        TemporaryViewFacesContext temporaryContext = new TemporaryViewFacesContext(context, createdView);
        try {
            Faces.setContext((FacesContext)temporaryContext);
            this.getViewDeclarationLanguage((FacesContext)temporaryContext, normalizedViewId).buildView((FacesContext)temporaryContext, createdView);
        }
        catch (IOException e) {
            throw new FacesException((Throwable)e);
        }
        finally {
            Faces.setContext(context);
        }
        if (Boolean.TRUE.equals(createdView.getAttributes().get(EnableRestorableView.class.getName()))) {
            return createdView;
        }
        return null;
    }

    private boolean isEnabled(FacesContext context) {
        return Boolean.TRUE.equals(FacesLocal.getApplicationAttribute(context, EnableRestorableView.class.getName()));
    }

    public ViewHandler getWrapped() {
        return this.wrapped;
    }

    private static class TemporaryViewFacesContext
    extends FacesContextWrapper {
        private FacesContext wrapped;
        private UIViewRoot temporaryView;

        public TemporaryViewFacesContext(FacesContext wrapped, UIViewRoot temporaryView) {
            this.wrapped = wrapped;
            this.temporaryView = temporaryView;
        }

        public UIViewRoot getViewRoot() {
            return this.temporaryView;
        }

        public RenderKit getRenderKit() {
            return ((RenderKitFactory)FactoryFinder.getFactory((String)"javax.faces.render.RenderKitFactory")).getRenderKit((FacesContext)this, this.temporaryView.getRenderKitId());
        }

        public FacesContext getWrapped() {
            return this.wrapped;
        }
    }
}

