/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.util.concurrentlinkedhashmap;

import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractQueue;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.omnifaces.util.concurrentlinkedhashmap.EntryWeigher;
import org.omnifaces.util.concurrentlinkedhashmap.EvictionListener;
import org.omnifaces.util.concurrentlinkedhashmap.GuardedBy;
import org.omnifaces.util.concurrentlinkedhashmap.Immutable;
import org.omnifaces.util.concurrentlinkedhashmap.Linked;
import org.omnifaces.util.concurrentlinkedhashmap.LinkedDeque;
import org.omnifaces.util.concurrentlinkedhashmap.ThreadSafe;
import org.omnifaces.util.concurrentlinkedhashmap.Weigher;
import org.omnifaces.util.concurrentlinkedhashmap.Weighers;

@ThreadSafe
public final class ConcurrentLinkedHashMap<K, V>
extends AbstractMap<K, V>
implements ConcurrentMap<K, V>,
Serializable {
    static final long MAXIMUM_CAPACITY = 9223372034707292160L;
    static final int MAXIMUM_BUFFER_SIZE = 0x100000;
    static final int BUFFER_THRESHOLD = 16;
    static final int DEFAULT_INITIAL_CAPACITY = 16;
    static final float DEFAULT_LOAD_FACTOR = 0.75f;
    static final int NUMBER_OF_BUFFERS;
    static final int BUFFER_MASK;
    static final int AMORTIZED_DRAIN_THRESHOLD;
    static final Queue<?> DISCARDING_QUEUE;
    private final ConcurrentMap<K, Node> data;
    private final int concurrencyLevel;
    @GuardedBy(value="evictionLock")
    private final LinkedDeque<Node> evictionDeque;
    @GuardedBy(value="evictionLock")
    private volatile long weightedSize;
    @GuardedBy(value="evictionLock")
    private volatile long capacity;
    private volatile int nextOrder;
    @GuardedBy(value="evictionLock")
    private int drainedOrder;
    private final Lock evictionLock;
    private final Queue<Task>[] buffers;
    private final AtomicIntegerArray bufferLengths;
    private final AtomicReference<DrainStatus> drainStatus;
    private final EntryWeigher<? super K, ? super V> weigher;
    private final Queue<Node> pendingNotifications;
    private final EvictionListener<K, V> listener;
    private transient Set<K> keySet;
    private transient Collection<V> values;
    private transient Set<Map.Entry<K, V>> entrySet;
    static final long serialVersionUID = 1L;

    static int ceilingNextPowerOfTwo(int x) {
        return 1 << 32 - Integer.numberOfLeadingZeros(x - 1);
    }

    private ConcurrentLinkedHashMap(Builder<K, V> builder) {
        this.concurrencyLevel = ((Builder)builder).concurrencyLevel;
        this.capacity = Math.min(((Builder)builder).capacity, 9223372034707292160L);
        this.data = new ConcurrentHashMap<K, Node>(((Builder)builder).initialCapacity, 0.75f, this.concurrencyLevel);
        this.weigher = ((Builder)builder).weigher;
        this.nextOrder = Integer.MIN_VALUE;
        this.drainedOrder = Integer.MIN_VALUE;
        this.evictionLock = new ReentrantLock();
        this.evictionDeque = new LinkedDeque();
        this.drainStatus = new AtomicReference<DrainStatus>(DrainStatus.IDLE);
        this.buffers = new Queue[NUMBER_OF_BUFFERS];
        this.bufferLengths = new AtomicIntegerArray(NUMBER_OF_BUFFERS);
        for (int i = 0; i < NUMBER_OF_BUFFERS; ++i) {
            this.buffers[i] = new ConcurrentLinkedQueue<Task>();
        }
        this.listener = ((Builder)builder).listener;
        this.pendingNotifications = this.listener == DiscardingListener.INSTANCE ? DISCARDING_QUEUE : new ConcurrentLinkedQueue();
    }

    static void checkNotNull(Object o) {
        Objects.requireNonNull(o);
    }

    static void checkArgument(boolean expression) {
        if (!expression) {
            throw new IllegalArgumentException();
        }
    }

    static void checkState(boolean expression) {
        if (!expression) {
            throw new IllegalStateException();
        }
    }

    public long capacity() {
        return this.capacity;
    }

    public void setCapacity(long capacity) {
        ConcurrentLinkedHashMap.checkArgument(capacity >= 0L);
        this.evictionLock.lock();
        try {
            this.capacity = Math.min(capacity, 9223372034707292160L);
            this.drainBuffers(AMORTIZED_DRAIN_THRESHOLD);
            this.evict();
        }
        finally {
            this.evictionLock.unlock();
        }
        this.notifyListener();
    }

    boolean hasOverflowed() {
        return this.weightedSize > this.capacity;
    }

    @GuardedBy(value="evictionLock")
    void evict() {
        while (this.hasOverflowed()) {
            Node node = (Node)this.evictionDeque.poll();
            if (node == null) {
                return;
            }
            if (this.data.remove(node.key, node)) {
                this.pendingNotifications.add(node);
            }
            node.makeDead();
        }
    }

    void afterCompletion(Task task) {
        boolean delayable = this.schedule(task);
        if (this.shouldDrainBuffers(delayable)) {
            this.tryToDrainBuffers(AMORTIZED_DRAIN_THRESHOLD);
        }
        this.notifyListener();
    }

    boolean schedule(Task task) {
        int index = ConcurrentLinkedHashMap.bufferIndex();
        int buffered = this.bufferLengths.incrementAndGet(index);
        if (task.isWrite()) {
            this.buffers[index].add(task);
            this.drainStatus.set(DrainStatus.REQUIRED);
            return false;
        }
        if (buffered <= 0x100000) {
            this.buffers[index].add(task);
            return buffered <= 16;
        }
        this.bufferLengths.decrementAndGet(index);
        return false;
    }

    static int bufferIndex() {
        return (int)Thread.currentThread().getId() & BUFFER_MASK;
    }

    int nextOrdering() {
        return this.nextOrder++;
    }

    boolean shouldDrainBuffers(boolean delayable) {
        DrainStatus status = this.drainStatus.get();
        return status != DrainStatus.PROCESSING & (!delayable | status == DrainStatus.REQUIRED);
    }

    void tryToDrainBuffers(int maxToDrain) {
        if (this.evictionLock.tryLock()) {
            try {
                this.drainStatus.set(DrainStatus.PROCESSING);
                this.drainBuffers(maxToDrain);
            }
            finally {
                this.drainStatus.compareAndSet(DrainStatus.PROCESSING, DrainStatus.IDLE);
                this.evictionLock.unlock();
            }
        }
    }

    @GuardedBy(value="evictionLock")
    void drainBuffers(int maxToDrain) {
        Task[] tasks = new Task[maxToDrain];
        int maxTaskIndex = this.moveTasksFromBuffers(tasks);
        this.runTasks(tasks, maxTaskIndex);
        this.updateDrainedOrder(tasks, maxTaskIndex);
    }

    @GuardedBy(value="evictionLock")
    int moveTasksFromBuffers(Task[] tasks) {
        int maxTaskIndex = -1;
        for (int i = 0; i < this.buffers.length; ++i) {
            int maxIndex = this.moveTasksFromBuffer(tasks, i);
            maxTaskIndex = Math.max(maxIndex, maxTaskIndex);
        }
        return maxTaskIndex;
    }

    @GuardedBy(value="evictionLock")
    int moveTasksFromBuffer(Task[] tasks, int bufferIndex) {
        Task task;
        Queue<Task> buffer = this.buffers[bufferIndex];
        int removedFromBuffer = 0;
        int maxIndex = -1;
        while ((task = buffer.poll()) != null) {
            ++removedFromBuffer;
            int index = task.getOrder() - this.drainedOrder;
            if (index < 0) {
                task.run();
                continue;
            }
            if (index >= tasks.length) {
                maxIndex = tasks.length - 1;
                this.addTaskToChain(tasks, task, maxIndex);
                break;
            }
            maxIndex = Math.max(index, maxIndex);
            this.addTaskToChain(tasks, task, index);
        }
        this.bufferLengths.addAndGet(bufferIndex, -removedFromBuffer);
        return maxIndex;
    }

    @GuardedBy(value="evictionLock")
    void addTaskToChain(Task[] tasks, Task task, int index) {
        task.setNext(tasks[index]);
        tasks[index] = task;
    }

    @GuardedBy(value="evictionLock")
    void runTasks(Task[] tasks, int maxTaskIndex) {
        for (int i = 0; i <= maxTaskIndex; ++i) {
            this.runTasksInChain(tasks[i]);
        }
    }

    @GuardedBy(value="evictionLock")
    void runTasksInChain(Task task) {
        for (Task nextTask = task; nextTask != null; nextTask = nextTask.getNext()) {
            Task currentTask = nextTask;
            currentTask.setNext(null);
            currentTask.run();
        }
    }

    @GuardedBy(value="evictionLock")
    void updateDrainedOrder(Task[] tasks, int maxTaskIndex) {
        if (maxTaskIndex >= 0) {
            Task task = tasks[maxTaskIndex];
            this.drainedOrder = task.getOrder() + 1;
        }
    }

    void notifyListener() {
        Node node;
        while ((node = this.pendingNotifications.poll()) != null) {
            this.listener.onEviction(node.key, node.getValue());
        }
    }

    @Override
    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    @Override
    public int size() {
        return this.data.size();
    }

    public long weightedSize() {
        return Math.max(0L, this.weightedSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        this.evictionLock.lock();
        try {
            Node node;
            while ((node = (Node)this.evictionDeque.poll()) != null) {
                this.data.remove(node.key, node);
                node.makeDead();
            }
            for (int i = 0; i < this.buffers.length; ++i) {
                Task task;
                Queue<Task> buffer = this.buffers[i];
                int removed = 0;
                while ((task = buffer.poll()) != null) {
                    if (task.isWrite()) {
                        task.run();
                    }
                    ++removed;
                }
                this.bufferLengths.addAndGet(i, -removed);
            }
        }
        finally {
            this.evictionLock.unlock();
        }
    }

    @Override
    public boolean containsKey(Object key) {
        return this.data.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        ConcurrentLinkedHashMap.checkNotNull(value);
        for (Node node : this.data.values()) {
            if (!node.getValue().equals(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public V get(Object key) {
        Node node = (Node)this.data.get(key);
        if (node == null) {
            return null;
        }
        this.afterCompletion(new ReadTask(node));
        return node.getValue();
    }

    @Override
    public V put(K key, V value) {
        return this.put(key, value, false);
    }

    @Override
    public V putIfAbsent(K key, V value) {
        return this.put(key, value, true);
    }

    V put(K key, V value, boolean onlyIfAbsent) {
        WeightedValue oldWeightedValue;
        Node prior;
        ConcurrentLinkedHashMap.checkNotNull(value);
        int weight = this.weigher.weightOf(key, value);
        WeightedValue<V> weightedValue = new WeightedValue<V>(value, weight);
        Node node = new Node(key, weightedValue);
        block0: while (true) {
            if ((prior = this.data.putIfAbsent(node.key, node)) == null) {
                this.afterCompletion(new AddTask(node, weight));
                return null;
            }
            if (onlyIfAbsent) {
                this.afterCompletion(new ReadTask(prior));
                return prior.getValue();
            }
            do {
                if (!(oldWeightedValue = (WeightedValue)prior.get()).isAlive()) continue block0;
            } while (!prior.compareAndSet(oldWeightedValue, weightedValue));
            break;
        }
        int weightedDifference = weight - oldWeightedValue.weight;
        ReadTask task = weightedDifference == 0 ? new ReadTask(prior) : new UpdateTask(prior, weightedDifference);
        this.afterCompletion(task);
        return (V)oldWeightedValue.value;
    }

    @Override
    public V remove(Object key) {
        Node node = (Node)this.data.remove(key);
        if (node == null) {
            return null;
        }
        node.makeRetired();
        this.afterCompletion(new RemovalTask(node));
        return node.getValue();
    }

    @Override
    public boolean remove(Object key, Object value) {
        Node node = (Node)this.data.get(key);
        if (node == null || value == null) {
            return false;
        }
        WeightedValue weightedValue = (WeightedValue)node.get();
        while (weightedValue.hasValue(value)) {
            if (node.tryToRetire(weightedValue)) {
                if (!this.data.remove(key, node)) break;
                this.afterCompletion(new RemovalTask(node));
                return true;
            }
            weightedValue = (WeightedValue)node.get();
            if (weightedValue.isAlive()) continue;
        }
        return false;
    }

    @Override
    public V replace(K key, V value) {
        WeightedValue oldWeightedValue;
        ConcurrentLinkedHashMap.checkNotNull(value);
        int weight = this.weigher.weightOf(key, value);
        WeightedValue<V> weightedValue = new WeightedValue<V>(value, weight);
        Node node = (Node)this.data.get(key);
        if (node == null) {
            return null;
        }
        do {
            if ((oldWeightedValue = (WeightedValue)node.get()).isAlive()) continue;
            return null;
        } while (!node.compareAndSet(oldWeightedValue, weightedValue));
        int weightedDifference = weight - oldWeightedValue.weight;
        ReadTask task = weightedDifference == 0 ? new ReadTask(node) : new UpdateTask(node, weightedDifference);
        this.afterCompletion(task);
        return (V)oldWeightedValue.value;
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        WeightedValue weightedValue;
        ConcurrentLinkedHashMap.checkNotNull(oldValue);
        ConcurrentLinkedHashMap.checkNotNull(newValue);
        int weight = this.weigher.weightOf(key, newValue);
        WeightedValue<V> newWeightedValue = new WeightedValue<V>(newValue, weight);
        Node node = (Node)this.data.get(key);
        if (node == null) {
            return false;
        }
        do {
            if ((weightedValue = (WeightedValue)node.get()).isAlive() && weightedValue.hasValue(oldValue)) continue;
            return false;
        } while (!node.compareAndSet(weightedValue, newWeightedValue));
        int weightedDifference = weight - weightedValue.weight;
        ReadTask task = weightedDifference == 0 ? new ReadTask(node) : new UpdateTask(node, weightedDifference);
        this.afterCompletion(task);
        return true;
    }

    @Override
    public Set<K> keySet() {
        if (this.keySet == null) {
            this.keySet = new KeySet();
        }
        return this.keySet;
    }

    public Set<K> ascendingKeySet() {
        return this.orderedKeySet(true, Integer.MAX_VALUE);
    }

    public Set<K> ascendingKeySetWithLimit(int limit) {
        return this.orderedKeySet(true, limit);
    }

    public Set<K> descendingKeySet() {
        return this.orderedKeySet(false, Integer.MAX_VALUE);
    }

    public Set<K> descendingKeySetWithLimit(int limit) {
        return this.orderedKeySet(false, limit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set<K> orderedKeySet(boolean ascending, int limit) {
        ConcurrentLinkedHashMap.checkArgument(limit >= 0);
        this.evictionLock.lock();
        try {
            Iterator<Node> iterator;
            this.drainBuffers(AMORTIZED_DRAIN_THRESHOLD);
            int initialCapacity = this.weigher == Weighers.entrySingleton() ? Math.min(limit, (int)this.weightedSize()) : 16;
            LinkedHashSet<Object> keys = new LinkedHashSet<Object>(initialCapacity);
            Iterator<Node> iterator2 = iterator = ascending ? this.evictionDeque.iterator() : this.evictionDeque.descendingIterator();
            while (iterator.hasNext() && limit > keys.size()) {
                keys.add(iterator.next().key);
            }
            Set set = Collections.unmodifiableSet(keys);
            return set;
        }
        finally {
            this.evictionLock.unlock();
        }
    }

    @Override
    public Collection<V> values() {
        if (this.values == null) {
            this.values = new Values();
        }
        return this.values;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new EntrySet();
        }
        return this.entrySet;
    }

    public Map<K, V> ascendingMap() {
        return this.orderedMap(true, Integer.MAX_VALUE);
    }

    public Map<K, V> ascendingMapWithLimit(int limit) {
        return this.orderedMap(true, limit);
    }

    public Map<K, V> descendingMap() {
        return this.orderedMap(false, Integer.MAX_VALUE);
    }

    public Map<K, V> descendingMapWithLimit(int limit) {
        return this.orderedMap(false, limit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<K, V> orderedMap(boolean ascending, int limit) {
        ConcurrentLinkedHashMap.checkArgument(limit >= 0);
        this.evictionLock.lock();
        try {
            Iterator<Node> iterator;
            this.drainBuffers(AMORTIZED_DRAIN_THRESHOLD);
            int initialCapacity = this.weigher == Weighers.entrySingleton() ? Math.min(limit, (int)this.weightedSize()) : 16;
            LinkedHashMap map = new LinkedHashMap(initialCapacity);
            Iterator<Node> iterator2 = iterator = ascending ? this.evictionDeque.iterator() : this.evictionDeque.descendingIterator();
            while (iterator.hasNext() && limit > map.size()) {
                Node node = iterator.next();
                map.put(node.key, node.getValue());
            }
            Map map2 = Collections.unmodifiableMap(map);
            return map2;
        }
        finally {
            this.evictionLock.unlock();
        }
    }

    Object writeReplace() {
        return new SerializationProxy(this);
    }

    private void readObject(ObjectInputStream stream) throws InvalidObjectException {
        throw new InvalidObjectException("Proxy required");
    }

    static {
        DISCARDING_QUEUE = new DiscardingQueue();
        int buffers = ConcurrentLinkedHashMap.ceilingNextPowerOfTwo(Runtime.getRuntime().availableProcessors());
        AMORTIZED_DRAIN_THRESHOLD = (1 + buffers) * 16;
        NUMBER_OF_BUFFERS = buffers;
        BUFFER_MASK = buffers - 1;
    }

    public static final class Builder<K, V> {
        static final int DEFAULT_CONCURRENCY_LEVEL = 16;
        static final int DEFAULT_INITIAL_CAPACITY = 16;
        private EvictionListener<K, V> listener;
        private EntryWeigher<? super K, ? super V> weigher = Weighers.entrySingleton();
        private int concurrencyLevel = 16;
        private int initialCapacity = 16;
        private long capacity = -1L;

        public Builder() {
            this.listener = DiscardingListener.INSTANCE;
        }

        public Builder<K, V> initialCapacity(int initialCapacity) {
            ConcurrentLinkedHashMap.checkArgument(initialCapacity >= 0);
            this.initialCapacity = initialCapacity;
            return this;
        }

        public Builder<K, V> maximumWeightedCapacity(long capacity) {
            ConcurrentLinkedHashMap.checkArgument(capacity >= 0L);
            this.capacity = capacity;
            return this;
        }

        public Builder<K, V> concurrencyLevel(int concurrencyLevel) {
            ConcurrentLinkedHashMap.checkArgument(concurrencyLevel > 0);
            this.concurrencyLevel = concurrencyLevel;
            return this;
        }

        public Builder<K, V> listener(EvictionListener<K, V> listener) {
            ConcurrentLinkedHashMap.checkNotNull(listener);
            this.listener = listener;
            return this;
        }

        public Builder<K, V> weigher(Weigher<? super V> weigher) {
            this.weigher = weigher == Weighers.singleton() ? Weighers.entrySingleton() : new BoundedEntryWeigher(Weighers.asEntryWeigher(weigher));
            return this;
        }

        public Builder<K, V> weigher(EntryWeigher<? super K, ? super V> weigher) {
            this.weigher = weigher == Weighers.entrySingleton() ? Weighers.entrySingleton() : new BoundedEntryWeigher<K, V>(weigher);
            return this;
        }

        public ConcurrentLinkedHashMap<K, V> build() {
            ConcurrentLinkedHashMap.checkState(this.capacity >= 0L);
            return new ConcurrentLinkedHashMap(this);
        }
    }

    private static final class SerializationProxy<K, V>
    implements Serializable {
        private final EntryWeigher<? super K, ? super V> weigher;
        private final EvictionListener<K, V> listener;
        private final int concurrencyLevel;
        private final Map<K, V> data;
        private final long capacity;
        static final long serialVersionUID = 1L;

        SerializationProxy(ConcurrentLinkedHashMap<K, V> map) {
            this.concurrencyLevel = ((ConcurrentLinkedHashMap)map).concurrencyLevel;
            this.data = new HashMap<K, V>(map);
            this.capacity = ((ConcurrentLinkedHashMap)map).capacity;
            this.listener = ((ConcurrentLinkedHashMap)map).listener;
            this.weigher = ((ConcurrentLinkedHashMap)map).weigher;
        }

        Object readResolve() {
            ConcurrentLinkedHashMap<K, V> map = new Builder().concurrencyLevel(this.concurrencyLevel).maximumWeightedCapacity(this.capacity).listener(this.listener).weigher(this.weigher).build();
            map.putAll(this.data);
            return map;
        }
    }

    private abstract class AbstractTask
    implements Task {
        private final int order;
        private Task task;

        AbstractTask() {
            this.order = ConcurrentLinkedHashMap.this.nextOrdering();
        }

        @Override
        public int getOrder() {
            return this.order;
        }

        @Override
        public Task getNext() {
            return this.task;
        }

        @Override
        public void setNext(Task task) {
            this.task = task;
        }
    }

    private static interface Task
    extends Runnable {
        public int getOrder();

        public boolean isWrite();

        public Task getNext();

        public void setNext(Task var1);
    }

    private static enum DiscardingListener implements EvictionListener<Object, Object>
    {
        INSTANCE;


        @Override
        public void onEviction(Object key, Object value) {
        }
    }

    private static final class DiscardingQueue
    extends AbstractQueue<Object> {
        private DiscardingQueue() {
        }

        @Override
        public boolean add(Object e) {
            return true;
        }

        @Override
        public boolean offer(Object e) {
            return true;
        }

        @Override
        public Object poll() {
            return null;
        }

        @Override
        public Object peek() {
            return null;
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public Iterator<Object> iterator() {
            return Collections.emptyList().iterator();
        }
    }

    private static final class BoundedEntryWeigher<K, V>
    implements EntryWeigher<K, V>,
    Serializable {
        static final long serialVersionUID = 1L;
        private final EntryWeigher<? super K, ? super V> weigher;

        BoundedEntryWeigher(EntryWeigher<? super K, ? super V> weigher) {
            ConcurrentLinkedHashMap.checkNotNull(weigher);
            this.weigher = weigher;
        }

        @Override
        public int weightOf(K key, V value) {
            int weight = this.weigher.weightOf(key, value);
            ConcurrentLinkedHashMap.checkArgument(weight >= 1);
            return weight;
        }

        Object writeReplace() {
            return this.weigher;
        }
    }

    private final class WriteThroughEntry
    extends AbstractMap.SimpleEntry<K, V> {
        static final long serialVersionUID = 1L;

        WriteThroughEntry(Node node) {
            super(node.key, node.getValue());
        }

        @Override
        public V setValue(V value) {
            ConcurrentLinkedHashMap.this.put(this.getKey(), value);
            return super.setValue(value);
        }

        Object writeReplace() {
            return new AbstractMap.SimpleEntry(this);
        }
    }

    private final class EntryIterator
    implements Iterator<Map.Entry<K, V>> {
        private final Iterator<Node> iterator;
        private Node current;

        private EntryIterator() {
            this.iterator = ConcurrentLinkedHashMap.this.data.values().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public Map.Entry<K, V> next() {
            this.current = this.iterator.next();
            return new WriteThroughEntry(this.current);
        }

        @Override
        public void remove() {
            ConcurrentLinkedHashMap.checkState(this.current != null);
            ConcurrentLinkedHashMap.this.remove(this.current.key);
            this.current = null;
        }
    }

    private final class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private final ConcurrentLinkedHashMap<K, V> map;

        private EntrySet() {
            this.map = ConcurrentLinkedHashMap.this;
        }

        @Override
        public int size() {
            return this.map.size();
        }

        @Override
        public void clear() {
            this.map.clear();
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator();
        }

        @Override
        public boolean contains(Object obj) {
            if (!(obj instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)obj;
            Node node = (Node)this.map.data.get(entry.getKey());
            return node != null && node.getValue().equals(entry.getValue());
        }

        @Override
        public boolean add(Map.Entry<K, V> entry) {
            return this.map.putIfAbsent(entry.getKey(), entry.getValue()) == null;
        }

        @Override
        public boolean remove(Object obj) {
            if (!(obj instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)obj;
            return this.map.remove(entry.getKey(), entry.getValue());
        }
    }

    private final class ValueIterator
    implements Iterator<V> {
        private final Iterator<Node> iterator;
        private Node current;

        private ValueIterator() {
            this.iterator = ConcurrentLinkedHashMap.this.data.values().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public V next() {
            this.current = this.iterator.next();
            return this.current.getValue();
        }

        @Override
        public void remove() {
            ConcurrentLinkedHashMap.checkState(this.current != null);
            ConcurrentLinkedHashMap.this.remove(this.current.key);
            this.current = null;
        }
    }

    private final class Values
    extends AbstractCollection<V> {
        private Values() {
        }

        @Override
        public int size() {
            return ConcurrentLinkedHashMap.this.size();
        }

        @Override
        public void clear() {
            ConcurrentLinkedHashMap.this.clear();
        }

        @Override
        public Iterator<V> iterator() {
            return new ValueIterator();
        }

        @Override
        public boolean contains(Object o) {
            return ConcurrentLinkedHashMap.this.containsValue(o);
        }
    }

    private final class KeyIterator
    implements Iterator<K> {
        private final Iterator<K> iterator;
        private K current;

        private KeyIterator() {
            this.iterator = ConcurrentLinkedHashMap.this.data.keySet().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public K next() {
            this.current = this.iterator.next();
            return this.current;
        }

        @Override
        public void remove() {
            ConcurrentLinkedHashMap.checkState(this.current != null);
            ConcurrentLinkedHashMap.this.remove(this.current);
            this.current = null;
        }
    }

    private final class KeySet
    extends AbstractSet<K> {
        private final ConcurrentLinkedHashMap<K, V> map;

        private KeySet() {
            this.map = ConcurrentLinkedHashMap.this;
        }

        @Override
        public int size() {
            return this.map.size();
        }

        @Override
        public void clear() {
            this.map.clear();
        }

        @Override
        public Iterator<K> iterator() {
            return new KeyIterator();
        }

        @Override
        public boolean contains(Object obj) {
            return ConcurrentLinkedHashMap.this.containsKey(obj);
        }

        @Override
        public boolean remove(Object obj) {
            return this.map.remove(obj) != null;
        }

        @Override
        public Object[] toArray() {
            return this.map.data.keySet().toArray();
        }

        @Override
        public <T> T[] toArray(T[] array) {
            return this.map.data.keySet().toArray(array);
        }
    }

    private final class Node
    extends AtomicReference<WeightedValue<V>>
    implements Linked<Node> {
        private final K key;
        @GuardedBy(value="evictionLock")
        private Node prev;
        @GuardedBy(value="evictionLock")
        private Node next;

        Node(K key, WeightedValue<V> weightedValue) {
            super(weightedValue);
            this.key = key;
        }

        @Override
        @GuardedBy(value="evictionLock")
        public Node getPrevious() {
            return this.prev;
        }

        @Override
        @GuardedBy(value="evictionLock")
        public void setPrevious(Node prev) {
            this.prev = prev;
        }

        @Override
        @GuardedBy(value="evictionLock")
        public Node getNext() {
            return this.next;
        }

        @Override
        @GuardedBy(value="evictionLock")
        public void setNext(Node next) {
            this.next = next;
        }

        V getValue() {
            return ((WeightedValue)this.get()).value;
        }

        boolean tryToRetire(WeightedValue<V> expect) {
            if (expect.isAlive()) {
                WeightedValue<Object> retired = new WeightedValue<Object>(expect.value, -expect.weight);
                return this.compareAndSet(expect, retired);
            }
            return false;
        }

        void makeRetired() {
            WeightedValue<Object> retired;
            WeightedValue current;
            do {
                if ((current = (WeightedValue)this.get()).isAlive()) continue;
                return;
            } while (!this.compareAndSet(current, retired = new WeightedValue<Object>(current.value, -current.weight)));
        }

        @GuardedBy(value="evictionLock")
        void makeDead() {
            WeightedValue<Object> dead;
            WeightedValue current;
            while (!this.compareAndSet(current = (WeightedValue)this.get(), dead = new WeightedValue<Object>(current.value, 0))) {
            }
            ConcurrentLinkedHashMap.this.weightedSize = ConcurrentLinkedHashMap.this.weightedSize - (long)Math.abs(current.weight);
        }
    }

    @Immutable
    private static final class WeightedValue<V> {
        private final int weight;
        private final V value;

        WeightedValue(V value, int weight) {
            this.weight = weight;
            this.value = value;
        }

        boolean hasValue(Object o) {
            return o == this.value || this.value.equals(o);
        }

        boolean isAlive() {
            return this.weight > 0;
        }
    }

    private final class UpdateTask
    extends ReadTask {
        private final int weightDifference;

        public UpdateTask(Node node, int weightDifference) {
            super(node);
            this.weightDifference = weightDifference;
        }

        @Override
        @GuardedBy(value="evictionLock")
        public void run() {
            super.run();
            ConcurrentLinkedHashMap.this.weightedSize = ConcurrentLinkedHashMap.this.weightedSize + (long)this.weightDifference;
            ConcurrentLinkedHashMap.this.evict();
        }

        @Override
        public boolean isWrite() {
            return true;
        }
    }

    private final class RemovalTask
    extends AbstractTask {
        private final Node node;

        RemovalTask(Node node) {
            this.node = node;
        }

        @Override
        @GuardedBy(value="evictionLock")
        public void run() {
            ConcurrentLinkedHashMap.this.evictionDeque.remove(this.node);
            this.node.makeDead();
        }

        @Override
        public boolean isWrite() {
            return true;
        }
    }

    private final class AddTask
    extends AbstractTask {
        private final Node node;
        private final int weight;

        AddTask(Node node, int weight) {
            this.weight = weight;
            this.node = node;
        }

        @Override
        @GuardedBy(value="evictionLock")
        public void run() {
            ConcurrentLinkedHashMap.this.weightedSize = ConcurrentLinkedHashMap.this.weightedSize + (long)this.weight;
            if (((WeightedValue)this.node.get()).isAlive()) {
                ConcurrentLinkedHashMap.this.evictionDeque.add(this.node);
                ConcurrentLinkedHashMap.this.evict();
            }
        }

        @Override
        public boolean isWrite() {
            return true;
        }
    }

    private class ReadTask
    extends AbstractTask {
        private final Node node;

        ReadTask(Node node) {
            this.node = node;
        }

        @Override
        @GuardedBy(value="evictionLock")
        public void run() {
            if (ConcurrentLinkedHashMap.this.evictionDeque.contains(this.node)) {
                ConcurrentLinkedHashMap.this.evictionDeque.moveToBack(this.node);
            }
        }

        @Override
        public boolean isWrite() {
            return false;
        }
    }

    static enum DrainStatus {
        IDLE,
        REQUIRED,
        PROCESSING;

    }
}

