/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.regex.Pattern;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import javax.xml.bind.DatatypeConverter;

public final class Utils {
    private static final int DEFAULT_STREAM_BUFFER_SIZE = 10240;
    private static final String PATTERN_RFC1123_DATE = "EEE, dd MMM yyyy HH:mm:ss zzz";
    private static final TimeZone TIMEZONE_GMT = TimeZone.getTimeZone("GMT");
    private static final int BASE64_SEGMENT_LENGTH = 4;
    private static final int UNICODE_3_BYTES = 4095;
    private static final int UNICODE_2_BYTES = 255;
    private static final int UNICODE_1_BYTE = 15;
    private static final int UNICODE_END_PRINTABLE_ASCII = 127;
    private static final int UNICODE_BEGIN_PRINTABLE_ASCII = 32;
    private static final String ERROR_UNSUPPORTED_ENCODING = "UTF-8 is apparently not supported on this platform.";

    private Utils() {
    }

    public static boolean isEmpty(String string) {
        return string == null || string.isEmpty();
    }

    public static boolean isEmpty(Object[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isEmpty(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean isEmpty(Map<?, ?> map) {
        return map == null || map.isEmpty();
    }

    public static boolean isEmpty(Object value) {
        if (value == null) {
            return true;
        }
        if (value instanceof String) {
            return ((String)value).isEmpty();
        }
        if (value instanceof Collection) {
            return ((Collection)value).isEmpty();
        }
        if (value instanceof Map) {
            return ((Map)value).isEmpty();
        }
        if (value.getClass().isArray()) {
            return Array.getLength(value) == 0;
        }
        return value.toString() == null || value.toString().isEmpty();
    }

    public static boolean isAnyEmpty(Object ... values) {
        for (Object value : values) {
            if (!Utils.isEmpty(value)) continue;
            return true;
        }
        return false;
    }

    public static boolean isBlank(String string) {
        return Utils.isEmpty(string) || string.trim().isEmpty();
    }

    public static boolean isNumber(String string) {
        try {
            Long.parseLong(string);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isDecimal(String string) {
        try {
            Double.parseDouble(string);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @SafeVarargs
    public static <T> T coalesce(T ... objects) {
        for (T object : objects) {
            if (object == null) continue;
            return object;
        }
        return null;
    }

    @SafeVarargs
    public static <T> boolean isOneOf(T object, T ... objects) {
        for (T other : objects) {
            if (!(object == null ? other == null : object.equals(other))) continue;
            return true;
        }
        return false;
    }

    public static boolean startsWithOneOf(String string, String ... prefixes) {
        for (String prefix : prefixes) {
            if (!string.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    public static boolean isOneInstanceOf(Class<?> cls, Class<?> ... classes) {
        for (Class<?> other : classes) {
            if (!(cls == null ? other == null : other.isAssignableFrom(cls))) continue;
            return true;
        }
        return false;
    }

    @SafeVarargs
    public static boolean isOneAnnotationPresent(Class<?> cls, Class<? extends Annotation> ... annotations) {
        for (Class<? extends Annotation> annotation : annotations) {
            if (!cls.isAnnotationPresent(annotation)) continue;
            return true;
        }
        return false;
    }

    /*
     * Exception decompiling
     */
    public static long stream(InputStream input, OutputStream output) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static byte[] toByteArray(InputStream input) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        Utils.stream(input, output);
        return output.toByteArray();
    }

    public static IOException close(Closeable resource) {
        if (resource != null) {
            try {
                resource.close();
            }
            catch (IOException e) {
                return e;
            }
        }
        return null;
    }

    public static <E> Set<E> unmodifiableSet(Object ... values) {
        HashSet<Object> set = new HashSet<Object>();
        for (Object value : values) {
            if (value instanceof Object[]) {
                for (Object item : (Object[])value) {
                    set.add(item);
                }
                continue;
            }
            if (value instanceof Collection) {
                for (Object item : (Collection)value) {
                    set.add(item);
                }
                continue;
            }
            set.add(value);
        }
        return Collections.unmodifiableSet(set);
    }

    public static <E> List<E> iterableToList(Iterable<E> iterable) {
        ArrayList<E> list = null;
        if (iterable instanceof List) {
            list = (ArrayList<E>)iterable;
        } else if (iterable instanceof Collection) {
            list = new ArrayList((Collection)iterable);
        } else {
            list = new ArrayList<E>();
            Iterator<E> iterator = iterable.iterator();
            while (iterator.hasNext()) {
                list.add(iterator.next());
            }
        }
        return list;
    }

    public static List<String> csvToList(String values) {
        return Utils.csvToList(values, ",");
    }

    public static List<String> csvToList(String values, String delimiter) {
        if (Utils.isEmpty(values)) {
            return Collections.emptyList();
        }
        ArrayList<String> list = new ArrayList<String>();
        for (String value : values.split(Pattern.quote(delimiter))) {
            String trimmedValue = value.trim();
            if (Utils.isEmpty(trimmedValue)) continue;
            list.add(trimmedValue);
        }
        return list;
    }

    public static <T> Map<T, T> reverse(Map<T, T> source) {
        HashMap<T, T> target = new HashMap<T, T>();
        for (Map.Entry<T, T> entry : source.entrySet()) {
            target.put(entry.getValue(), entry.getKey());
        }
        return target;
    }

    public static boolean containsByClassName(Collection<?> objects, String className) {
        for (Object object : objects) {
            if (!object.getClass().getName().equals(className)) continue;
            return true;
        }
        return false;
    }

    public static String formatRFC1123(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat(PATTERN_RFC1123_DATE, Locale.US);
        sdf.setTimeZone(TIMEZONE_GMT);
        return sdf.format(date);
    }

    public static Date parseRFC1123(String string) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat(PATTERN_RFC1123_DATE, Locale.US);
        return sdf.parse(string);
    }

    public static String serializeURLSafe(String string) {
        if (string == null) {
            return null;
        }
        try {
            ByteArrayInputStream raw = new ByteArrayInputStream(string.getBytes(StandardCharsets.UTF_8));
            ByteArrayOutputStream deflated = new ByteArrayOutputStream();
            Utils.stream(raw, new DeflaterOutputStream((OutputStream)deflated, new Deflater(9)));
            String base64 = DatatypeConverter.printBase64Binary((byte[])deflated.toByteArray());
            return base64.replace('+', '-').replace('/', '_').replace("=", "");
        }
        catch (IOException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    public static String unserializeURLSafe(String string) {
        if (string == null) {
            return null;
        }
        try {
            String base64 = string.replace('-', '+').replace('_', '/') + "===".substring(0, string.length() % 4);
            ByteArrayInputStream deflated = new ByteArrayInputStream(DatatypeConverter.parseBase64Binary((String)base64));
            return new String(Utils.toByteArray(new InflaterInputStream(deflated)), StandardCharsets.UTF_8);
        }
        catch (UnsupportedEncodingException e) {
            throw new UnsupportedOperationException(e);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static String encodeURL(String string) {
        if (string == null) {
            return null;
        }
        try {
            return URLEncoder.encode(string, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new UnsupportedOperationException(ERROR_UNSUPPORTED_ENCODING, e);
        }
    }

    public static String decodeURL(String string) {
        if (string == null) {
            return null;
        }
        try {
            return URLDecoder.decode(string, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new UnsupportedOperationException(ERROR_UNSUPPORTED_ENCODING, e);
        }
    }

    public static String escapeJS(String string, boolean escapeSingleQuote) {
        if (string == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder(string.length());
        for (char c : string.toCharArray()) {
            if (c > '\u0fff') {
                builder.append("\\u").append(Integer.toHexString(c));
                continue;
            }
            if (c > '\u00ff') {
                builder.append("\\u0").append(Integer.toHexString(c));
                continue;
            }
            if (c > '\u007f') {
                builder.append("\\u00").append(Integer.toHexString(c));
                continue;
            }
            if (c < ' ') {
                Utils.escapeJSControlCharacter(builder, c);
                continue;
            }
            Utils.escapeJSASCIICharacter(builder, c, escapeSingleQuote);
        }
        return builder.toString();
    }

    private static void escapeJSControlCharacter(StringBuilder builder, char c) {
        switch (c) {
            case '\b': {
                builder.append('\\').append('b');
                break;
            }
            case '\n': {
                builder.append('\\').append('n');
                break;
            }
            case '\t': {
                builder.append('\\').append('t');
                break;
            }
            case '\f': {
                builder.append('\\').append('f');
                break;
            }
            case '\r': {
                builder.append('\\').append('r');
                break;
            }
            default: {
                if (c > '\u000f') {
                    builder.append("\\u00").append(Integer.toHexString(c));
                    break;
                }
                builder.append("\\u000").append(Integer.toHexString(c));
            }
        }
    }

    private static void escapeJSASCIICharacter(StringBuilder builder, char c, boolean escapeSingleQuote) {
        switch (c) {
            case '\'': {
                if (escapeSingleQuote) {
                    builder.append('\\');
                }
                builder.append('\'');
                break;
            }
            case '\"': {
                builder.append('\\').append('\"');
                break;
            }
            case '\\': {
                builder.append('\\').append('\\');
                break;
            }
            case '/': {
                builder.append('\\').append('/');
                break;
            }
            default: {
                builder.append(c);
            }
        }
    }
}

