/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.util;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.faces.application.ProjectStage;
import javax.servlet.ServletContext;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.omnifaces.filter.CacheControlFilter;
import org.omnifaces.util.JNDI;
import org.omnifaces.util.Utils;

public final class Servlets {
    private static final Set<String> FACES_AJAX_HEADERS = Utils.unmodifiableSet("partial/ajax", "partial/process");
    private static final String FACES_AJAX_REDIRECT_XML = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><partial-response><redirect url=\"%s\"></redirect></partial-response>";
    private static Boolean facesDevelopment;

    private Servlets() {
    }

    public static String getRequestHostname(HttpServletRequest request) {
        try {
            return new URL(request.getRequestURL().toString()).getHost();
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static String getRequestDomainURL(HttpServletRequest request) {
        String url = request.getRequestURL().toString();
        return url.substring(0, url.length() - request.getRequestURI().length());
    }

    public static String getRequestBaseURL(HttpServletRequest request) {
        return Servlets.getRequestDomainURL(request) + request.getContextPath() + "/";
    }

    public static String getRequestRelativeURI(HttpServletRequest request) {
        return request.getRequestURI().substring(request.getContextPath().length());
    }

    public static String getRequestRelativeURIWithoutPathParameters(HttpServletRequest request) {
        return request.getPathInfo() == null ? request.getServletPath() : request.getServletPath() + request.getPathInfo();
    }

    public static String getRequestURLWithQueryString(HttpServletRequest request) {
        StringBuffer requestURL = request.getRequestURL();
        String queryString = request.getQueryString();
        return queryString == null ? requestURL.toString() : requestURL.append('?').append(queryString).toString();
    }

    public static String getRequestURIWithQueryString(HttpServletRequest request) {
        String requestURI = request.getRequestURI();
        String queryString = request.getQueryString();
        return queryString == null ? requestURI : requestURI + "?" + queryString;
    }

    public static Map<String, List<String>> getRequestQueryStringMap(HttpServletRequest request) {
        String queryString = request.getQueryString();
        if (Utils.isEmpty(queryString)) {
            return Collections.emptyMap();
        }
        return Servlets.toParameterMap(queryString);
    }

    public static String getForwardRequestURI(HttpServletRequest request) {
        return (String)request.getAttribute("javax.servlet.forward.request_uri");
    }

    public static String getForwardRequestQueryString(HttpServletRequest request) {
        return (String)request.getAttribute("javax.servlet.forward.query_string");
    }

    public static String getForwardRequestURIWithQueryString(HttpServletRequest request) {
        String requestURI = Servlets.getForwardRequestURI(request);
        String queryString = Servlets.getForwardRequestQueryString(request);
        return queryString == null ? requestURI : requestURI + "?" + queryString;
    }

    public static Map<String, List<String>> toParameterMap(String queryString) {
        String[] parameters = queryString.split(Pattern.quote("&"));
        LinkedHashMap<String, List<String>> parameterMap = new LinkedHashMap<String, List<String>>(parameters.length);
        for (String parameter : parameters) {
            if (!parameter.contains("=")) continue;
            String[] pair = parameter.split(Pattern.quote("="));
            String key = Utils.decodeURL(pair[0]);
            String value = pair.length > 1 && !Utils.isEmpty(pair[1]) ? Utils.decodeURL(pair[1]) : "";
            ArrayList<String> values = (ArrayList<String>)parameterMap.get(key);
            if (values == null) {
                values = new ArrayList<String>(1);
                parameterMap.put(key, values);
            }
            values.add(value);
        }
        return parameterMap;
    }

    public static String toQueryString(Map<String, List<String>> parameterMap) {
        StringBuilder queryString = new StringBuilder();
        for (Map.Entry<String, List<String>> entry : parameterMap.entrySet()) {
            String name = Utils.encodeURL(entry.getKey());
            for (String value : entry.getValue()) {
                if (queryString.length() > 0) {
                    queryString.append("&");
                }
                queryString.append(name).append("=").append(Utils.encodeURL(value));
            }
        }
        return queryString.toString();
    }

    public static String getRequestCookie(HttpServletRequest request, String name) {
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals(name)) continue;
                return Utils.decodeURL(cookie.getValue());
            }
        }
        return null;
    }

    public static void addResponseCookie(HttpServletRequest request, HttpServletResponse response, String name, String value, int maxAge) {
        Servlets.addResponseCookie(request, response, name, value, Servlets.getRequestHostname(request), null, maxAge);
    }

    public static void addResponseCookie(HttpServletRequest request, HttpServletResponse response, String name, String value, String path, int maxAge) {
        Servlets.addResponseCookie(request, response, name, value, Servlets.getRequestHostname(request), path, maxAge);
    }

    public static void addResponseCookie(HttpServletRequest request, HttpServletResponse response, String name, String value, String domain, String path, int maxAge) {
        Cookie cookie = new Cookie(name, Utils.encodeURL(value));
        if (domain != null && !domain.equals("localhost")) {
            cookie.setDomain(domain);
        }
        if (path != null) {
            cookie.setPath(path);
        }
        cookie.setMaxAge(maxAge);
        cookie.setSecure(request.isSecure());
        response.addCookie(cookie);
    }

    public static void removeResponseCookie(HttpServletRequest request, HttpServletResponse response, String name, String path) {
        Servlets.addResponseCookie(request, response, name, null, path, 0);
    }

    public static <T> T getApplicationAttribute(ServletContext context, String name) {
        return (T)context.getAttribute(name);
    }

    public static boolean isFacesAjaxRequest(HttpServletRequest request) {
        return FACES_AJAX_HEADERS.contains(request.getHeader("Faces-Request"));
    }

    public static boolean isFacesResourceRequest(HttpServletRequest request) {
        return request.getRequestURI().startsWith(request.getContextPath() + "/javax.faces.resource" + "/");
    }

    public static boolean isFacesDevelopment(ServletContext context) {
        if (facesDevelopment != null) {
            return facesDevelopment;
        }
        String projectStage = null;
        try {
            projectStage = (String)JNDI.lookup("java:comp/env/jsf/ProjectStage");
        }
        catch (IllegalStateException ignore) {
            return false;
        }
        if (projectStage == null) {
            projectStage = context.getInitParameter("javax.faces.PROJECT_STAGE");
        }
        facesDevelopment = ProjectStage.Development.name().equals(projectStage);
        return facesDevelopment;
    }

    public static void facesRedirect(HttpServletRequest request, HttpServletResponse response, String url, String ... paramValues) throws IOException {
        String redirectURL = Servlets.prepareRedirectURL(request, url, paramValues);
        if (Servlets.isFacesAjaxRequest(request)) {
            CacheControlFilter.setNoCacheHeaders(response);
            response.setContentType("text/xml");
            response.setCharacterEncoding(StandardCharsets.UTF_8.name());
            response.getWriter().printf(FACES_AJAX_REDIRECT_XML, redirectURL);
        } else {
            response.sendRedirect(redirectURL);
        }
    }

    static String prepareRedirectURL(HttpServletRequest request, String url, String ... paramValues) {
        String redirectURL = url;
        if (!Utils.startsWithOneOf(url, "http://", "https://", "/")) {
            redirectURL = request.getContextPath() + "/" + url;
        }
        if (Utils.isEmpty(paramValues)) {
            return redirectURL;
        }
        Object[] encodedParams = new Object[paramValues.length];
        for (int i = 0; i < paramValues.length; ++i) {
            encodedParams[i] = Utils.encodeURL(paramValues[i]);
        }
        return String.format(redirectURL, encodedParams);
    }
}

