/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.util;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.enterprise.inject.Typed;

@Typed
public final class Reflection {
    private Reflection() {
    }

    public static void setProperties(Object object, Map<String, Object> propertiesToSet) {
        try {
            HashMap<String, PropertyDescriptor> availableProperties = new HashMap<String, PropertyDescriptor>();
            for (PropertyDescriptor propertyDescriptor : Introspector.getBeanInfo(object.getClass()).getPropertyDescriptors()) {
                availableProperties.put(propertyDescriptor.getName(), propertyDescriptor);
            }
            for (Map.Entry entry : propertiesToSet.entrySet()) {
                ((PropertyDescriptor)availableProperties.get(entry.getKey())).getWriteMethod().invoke(object, entry.getValue());
            }
        }
        catch (IntrospectionException | IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
    }

    public static void setPropertiesWithCoercion(Object object, Map<String, Object> propertiesToSet) {
        try {
            for (PropertyDescriptor property : Introspector.getBeanInfo(object.getClass()).getPropertyDescriptors()) {
                Method setter = property.getWriteMethod();
                if (setter == null || !propertiesToSet.containsKey(property.getName())) continue;
                Object value = propertiesToSet.get(property.getName());
                if (value instanceof String && !property.getPropertyType().equals(String.class)) {
                    PropertyEditor editor = PropertyEditorManager.findEditor(property.getPropertyType());
                    editor.setAsText((String)value);
                    value = editor.getValue();
                }
                property.getWriteMethod().invoke(object, value);
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public static Method findMethod(Object base, String methodName, Object[] params) {
        ArrayList<Method> methods = new ArrayList<Method>();
        for (Method method : base.getClass().getMethods()) {
            if (!method.getName().equals(methodName) || method.getParameterTypes().length != params.length) continue;
            methods.add(method);
        }
        if (methods.size() == 1) {
            return (Method)methods.get(0);
        }
        if (methods.size() > 1) {
            for (Method method : methods) {
                boolean match = true;
                Class<?>[] candidateParams = method.getParameterTypes();
                for (int i = 0; i < params.length; ++i) {
                    if (candidateParams[i].isInstance(params[i])) continue;
                    match = false;
                    break;
                }
                if (!match) continue;
                return method;
            }
        }
        return null;
    }

    public static Class<?> toClass(String className) {
        try {
            return Class.forName(className, true, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException e) {
            try {
                return Class.forName(className);
            }
            catch (Exception ignore) {
                Object var2_3 = null;
                throw new IllegalStateException(e);
            }
        }
    }

    public static <T> T instance(String className) {
        return (T)Reflection.instance(Reflection.toClass(className));
    }

    public static <T> T instance(Class<T> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new IllegalStateException(e);
        }
    }
}

