/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.util;

import java.util.logging.Logger;
import javax.faces.webapp.FacesServlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletRegistration;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import org.omnifaces.util.Faces;

public final class Platform {
    public static final String BEAN_VALIDATION_AVAILABLE = "org.omnifaces.BEAN_VALIDATION_AVAILABLE";
    private static final Logger logger = Logger.getLogger(Platform.class.getName());

    private Platform() {
    }

    public static ValidatorFactory getBeanValidatorFactory() {
        ValidatorFactory validatorFactory = (ValidatorFactory)Faces.getApplicationAttribute("javax.faces.validator.beanValidator.ValidatorFactory");
        if (validatorFactory == null) {
            validatorFactory = Validation.buildDefaultValidatorFactory();
            Faces.setApplicationAttribute("javax.faces.validator.beanValidator.ValidatorFactory", validatorFactory);
        }
        return validatorFactory;
    }

    public static Validator getBeanValidator() {
        return Platform.getBeanValidatorFactory().getValidator();
    }

    public static boolean isBeanValidationAvailable() {
        Boolean beanValidationAvailable = (Boolean)Faces.getApplicationAttribute(BEAN_VALIDATION_AVAILABLE);
        if (beanValidationAvailable == null) {
            try {
                Class.forName("javax.validation.Validation");
                Platform.getBeanValidator();
                beanValidationAvailable = Boolean.TRUE;
            }
            catch (Exception | LinkageError e) {
                beanValidationAvailable = Boolean.FALSE;
                logger.warning("Bean validation not available.");
            }
            Faces.setApplicationAttribute(BEAN_VALIDATION_AVAILABLE, beanValidationAvailable);
        }
        return beanValidationAvailable;
    }

    public static ServletRegistration getFacesServletRegistration(ServletContext servletContext) {
        ServletRegistration facesServletRegistration = null;
        for (ServletRegistration registration : servletContext.getServletRegistrations().values()) {
            if (!registration.getClassName().equals(FacesServlet.class.getName())) continue;
            facesServletRegistration = registration;
            break;
        }
        return facesServletRegistration;
    }
}

