/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.util;

import java.text.MessageFormat;
import javax.faces.application.FacesMessage;
import org.omnifaces.util.Faces;

public final class Messages {
    private static final String ERROR_RESOLVER_ALREADY_SET = "The resolver can be set only once.";
    private static final Resolver DEFAULT_RESOLVER;
    private static Resolver resolver;

    public static void setResolver(Resolver resolver) {
        if (Messages.resolver != DEFAULT_RESOLVER) {
            throw new IllegalStateException(ERROR_RESOLVER_ALREADY_SET);
        }
        Messages.resolver = resolver;
    }

    private Messages() {
    }

    public static Message create(String message, Object ... params) {
        return new Message(Messages.createInfo(message, params));
    }

    public static FacesMessage create(FacesMessage.Severity severity, String message, Object ... params) {
        return new FacesMessage(severity, resolver.getMessage(message, params), null);
    }

    public static FacesMessage createInfo(String message, Object ... params) {
        return Messages.create(FacesMessage.SEVERITY_INFO, message, params);
    }

    public static FacesMessage createWarn(String message, Object ... params) {
        return Messages.create(FacesMessage.SEVERITY_WARN, message, params);
    }

    public static FacesMessage createError(String message, Object ... params) {
        return Messages.create(FacesMessage.SEVERITY_ERROR, message, params);
    }

    public static FacesMessage createFatal(String message, Object ... params) {
        return Messages.create(FacesMessage.SEVERITY_FATAL, message, params);
    }

    public static void add(String clientId, FacesMessage message) {
        Faces.getContext().addMessage(clientId, message);
    }

    public static void add(FacesMessage.Severity severity, String clientId, String message, Object ... params) {
        Messages.add(clientId, Messages.create(severity, message, params));
    }

    public static void addInfo(String clientId, String message, Object ... params) {
        Messages.add(clientId, Messages.createInfo(message, params));
    }

    public static void addWarn(String clientId, String message, Object ... params) {
        Messages.add(clientId, Messages.createWarn(message, params));
    }

    public static void addError(String clientId, String message, Object ... params) {
        Messages.add(clientId, Messages.createError(message, params));
    }

    public static void addFatal(String clientId, String message, Object ... params) {
        Messages.add(clientId, Messages.createFatal(message, params));
    }

    public static void addGlobal(FacesMessage message) {
        Messages.add(null, message);
    }

    public static void addGlobal(FacesMessage.Severity severity, String message, Object ... params) {
        Messages.addGlobal(Messages.create(severity, message, params));
    }

    public static void addGlobalInfo(String message, Object ... params) {
        Messages.addGlobal(Messages.createInfo(message, params));
    }

    public static void addGlobalWarn(String message, Object ... params) {
        Messages.addGlobal(Messages.createWarn(message, params));
    }

    public static void addGlobalError(String message, Object ... params) {
        Messages.addGlobal(Messages.createError(message, params));
    }

    public static void addGlobalFatal(String message, Object ... params) {
        Messages.addGlobal(Messages.createFatal(message, params));
    }

    public static void addFlash(String clientId, FacesMessage message) {
        Faces.getFlash().setKeepMessages(true);
        Messages.add(clientId, message);
    }

    public static void addFlash(FacesMessage.Severity severity, String clientId, String message, Object ... params) {
        Messages.addFlash(clientId, Messages.create(severity, message, params));
    }

    public static void addFlashInfo(String clientId, String message, Object ... params) {
        Messages.addFlash(clientId, Messages.createInfo(message, params));
    }

    public static void addFlashWarn(String clientId, String message, Object ... params) {
        Messages.addFlash(clientId, Messages.createWarn(message, params));
    }

    public static void addFlashError(String clientId, String message, Object ... params) {
        Messages.addFlash(clientId, Messages.createError(message, params));
    }

    public static void addFlashFatal(String clientId, String message, Object ... params) {
        Messages.addFlash(clientId, Messages.createFatal(message, params));
    }

    public static void addFlashGlobal(FacesMessage message) {
        Messages.addFlash(null, message);
    }

    public static void addFlashGlobalInfo(String message, Object ... params) {
        Messages.addFlashGlobal(Messages.createInfo(message, params));
    }

    public static void addFlashGlobalWarn(String message, Object ... params) {
        Messages.addFlashGlobal(Messages.createWarn(message, params));
    }

    public static void addFlashGlobalError(String message, Object ... params) {
        Messages.addFlashGlobal(Messages.createError(message, params));
    }

    public static void addFlashGlobalFatal(String message, Object ... params) {
        Messages.addFlashGlobal(Messages.createFatal(message, params));
    }

    static {
        resolver = DEFAULT_RESOLVER = new Resolver(){

            @Override
            public String getMessage(String message, Object ... params) {
                return MessageFormat.format(message, params);
            }
        };
    }

    public static final class Message {
        private FacesMessage message;

        private Message(FacesMessage message) {
            this.message = message;
        }

        public Message detail(String detail, Object ... params) {
            this.message.setDetail(resolver.getMessage(detail, params));
            return this;
        }

        public Message warn() {
            this.message.setSeverity(FacesMessage.SEVERITY_WARN);
            return this;
        }

        public Message error() {
            this.message.setSeverity(FacesMessage.SEVERITY_ERROR);
            return this;
        }

        public Message fatal() {
            this.message.setSeverity(FacesMessage.SEVERITY_FATAL);
            return this;
        }

        public Message flash() {
            Faces.getFlash().setKeepMessages(true);
            return this;
        }

        public void add(String clientId) {
            Messages.add(clientId, this.message);
        }

        public void add() {
            Messages.addGlobal(this.message);
        }

        public FacesMessage get() {
            return this.message;
        }
    }

    public static interface Resolver {
        public String getMessage(String var1, Object ... var2);
    }
}

