/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.application.Application;
import javax.faces.application.Resource;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.NamingContainer;
import javax.faces.component.UICommand;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.component.UIInput;
import javax.faces.component.UINamingContainer;
import javax.faces.component.UIParameter;
import javax.faces.component.UIViewRoot;
import javax.faces.component.behavior.AjaxBehavior;
import javax.faces.component.visit.VisitCallback;
import javax.faces.component.visit.VisitContext;
import javax.faces.component.visit.VisitHint;
import javax.faces.component.visit.VisitResult;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.event.AjaxBehaviorEvent;
import javax.faces.event.AjaxBehaviorListener;
import javax.faces.event.MethodExpressionActionListener;
import javax.faces.view.facelets.FaceletContext;
import org.omnifaces.component.ParamHolder;
import org.omnifaces.component.SimpleParam;
import org.omnifaces.component.output.Param;
import org.omnifaces.util.Callback;
import org.omnifaces.util.Faces;
import org.omnifaces.util.FacesLocal;
import org.omnifaces.util.Utils;

public final class Components {
    private static final String ERROR_INVALID_PARENT = "Component '%s' must have a parent of type '%s', but it cannot be found.";
    private static final String ERROR_INVALID_DIRECT_PARENT = "Component '%s' must have a direct parent of type '%s', but it cannot be found.";
    private static final String ERROR_CHILDREN_DISALLOWED = "Component '%s' must have no children. Encountered children of types '%s'.";

    private Components() {
    }

    public static UIComponent getCurrentComponent() {
        return UIComponent.getCurrentComponent((FacesContext)Faces.getContext());
    }

    public static <T> T getAttribute(UIComponent component, String name) {
        return (T)component.getAttributes().get(name);
    }

    public static boolean isRendered(UIComponent component) {
        UIComponent current = component;
        while (current.getParent() != null) {
            if (!current.isRendered()) {
                return false;
            }
            current = current.getParent();
        }
        return true;
    }

    public static <C extends UIComponent> C findComponent(String clientId) {
        return (C)Faces.getViewRoot().findComponent(clientId);
    }

    public static <C extends UIComponent> C findComponentRelatively(UIComponent component, String clientId) {
        if (Utils.isEmpty(clientId)) {
            return null;
        }
        C result = Components.findComponentInParents(component, clientId);
        if (result == null) {
            result = Components.findComponentInChildren((UIComponent)Faces.getViewRoot(), clientId);
        }
        return result;
    }

    public static <C extends UIComponent> C findComponentInParents(UIComponent component, String clientId) {
        if (Utils.isEmpty(clientId)) {
            return null;
        }
        UIComponent parent = component;
        while (parent != null) {
            UIComponent result = null;
            if (parent instanceof NamingContainer) {
                try {
                    result = parent.findComponent(clientId);
                }
                catch (IllegalArgumentException e) {
                    continue;
                }
            }
            if (result != null) {
                return (C)result;
            }
            parent = parent.getParent();
        }
        return null;
    }

    public static <C extends UIComponent> C findComponentInChildren(UIComponent component, String clientId) {
        if (Utils.isEmpty(clientId)) {
            return null;
        }
        for (UIComponent child : component.getChildren()) {
            Object result = null;
            if (child instanceof NamingContainer) {
                try {
                    result = child.findComponent(clientId);
                }
                catch (IllegalArgumentException e) {
                    continue;
                }
            }
            if (result == null) {
                result = Components.findComponentInChildren(child, clientId);
            }
            if (result == null) continue;
            return (C)result;
        }
        return null;
    }

    public static <C extends UIComponent> List<C> findComponentsInChildren(UIComponent component, Class<C> type) {
        ArrayList components = new ArrayList();
        Components.findComponentsInChildren(component, type, components);
        return components;
    }

    private static <C extends UIComponent> void findComponentsInChildren(UIComponent component, Class<C> type, List<C> matches) {
        for (UIComponent child : component.getChildren()) {
            if (type.isInstance(child)) {
                matches.add(child);
            }
            Components.findComponentsInChildren(child, type, matches);
        }
    }

    public static <C extends UIComponent> C getClosestParent(UIComponent component, Class<C> parentType) {
        UIComponent parent;
        for (parent = component.getParent(); parent != null && !parentType.isInstance(parent); parent = parent.getParent()) {
        }
        return (C)((UIComponent)parentType.cast(parent));
    }

    public static ForEach forEachComponent() {
        return new ForEach();
    }

    public static ForEach forEachComponent(FacesContext facesContext) {
        return new ForEach(facesContext);
    }

    public static void includeFacelet(UIComponent parent, String path) throws IOException {
        Faces.getFaceletContext().includeFacelet(parent, path);
    }

    public static UIComponent includeCompositeComponent(UIComponent parent, String libraryName, String resourceName, String id) {
        FacesContext context = FacesContext.getCurrentInstance();
        Application application = context.getApplication();
        FaceletContext faceletContext = FacesLocal.getFaceletContext(context);
        Resource resource = application.getResourceHandler().createResource(resourceName, libraryName);
        UIComponent composite = application.createComponent(context, resource);
        composite.setId(id);
        UIComponent implementation = application.createComponent("javax.faces.Panel");
        implementation.setRendererType("javax.faces.Group");
        composite.getFacets().put("javax.faces.component.COMPOSITE_FACET_NAME", implementation);
        parent.getChildren().add(composite);
        parent.pushComponentToEL(context, composite);
        try {
            faceletContext.includeFacelet(implementation, resource.getURL());
        }
        catch (IOException e) {
            throw new FacesException((Throwable)e);
        }
        finally {
            parent.popComponentFromEL(context);
        }
        return composite;
    }

    public static UIForm getCurrentForm() {
        FacesContext context = FacesContext.getCurrentInstance();
        if (!context.isPostback()) {
            return null;
        }
        UIViewRoot viewRoot = context.getViewRoot();
        for (String name : context.getExternalContext().getRequestParameterMap().keySet()) {
            UIForm form;
            if (name.startsWith("javax.faces.")) continue;
            UIComponent component = Components.findComponentIgnoringIAE(viewRoot, Components.stripIterationIndexFromClientId(name));
            if (component instanceof UIForm) {
                return (UIForm)component;
            }
            if (component == null || (form = Components.getClosestParent(component, UIForm.class)) == null) continue;
            return form;
        }
        return null;
    }

    public static UICommand getCurrentCommand() {
        UIComponent component;
        String source;
        FacesContext context = FacesContext.getCurrentInstance();
        if (!context.isPostback()) {
            return null;
        }
        UIViewRoot viewRoot = context.getViewRoot();
        Map params = context.getExternalContext().getRequestParameterMap();
        if (context.getPartialViewContext().isAjaxRequest() && (source = (String)params.get("javax.faces.source")) != null && (component = Components.findComponentIgnoringIAE(viewRoot, Components.stripIterationIndexFromClientId(source))) instanceof UICommand) {
            return (UICommand)component;
        }
        for (String name : params.keySet()) {
            UIComponent component2;
            if (name.startsWith("javax.faces.") || !((component2 = Components.findComponentIgnoringIAE(viewRoot, Components.stripIterationIndexFromClientId(name))) instanceof UICommand)) continue;
            return (UICommand)component2;
        }
        return null;
    }

    public static boolean isEditable(UIInput input) {
        return input.isRendered() && !Boolean.TRUE.equals(input.getAttributes().get("disabled")) && !Boolean.TRUE.equals(input.getAttributes().get("readonly"));
    }

    public static String getLabel(UIComponent input) {
        String label = Components.getOptionalLabel(input);
        return label != null ? label : input.getClientId();
    }

    public static String getOptionalLabel(UIComponent input) {
        ValueExpression labelExpression;
        Object label = input.getAttributes().get("label");
        if (Utils.isEmpty(label) && (labelExpression = input.getValueExpression("label")) != null) {
            label = labelExpression.getValue(Faces.getELContext());
        }
        return label != null ? label.toString() : null;
    }

    public static <T> T getValue(EditableValueHolder component) {
        Object submittedValue = component.getSubmittedValue();
        return (T)(submittedValue != null ? submittedValue : component.getLocalValue());
    }

    public static <T> T getImmediateValue(UIInput input) {
        if (input.isValid() && input.getSubmittedValue() != null) {
            input.validate(Faces.getContext());
        }
        return (T)(input.isLocalValueSet() ? input.getValue() : null);
    }

    public static boolean hasSubmittedValue(EditableValueHolder component) {
        return !Utils.isEmpty(component.getSubmittedValue());
    }

    public static boolean hasInvokedSubmit(UIComponent component) {
        String source;
        FacesContext context = FacesContext.getCurrentInstance();
        if (!context.isPostback()) {
            return false;
        }
        String clientId = Components.stripIterationIndexFromClientId(component.getClientId(context));
        Map params = context.getExternalContext().getRequestParameterMap();
        if (context.getPartialViewContext().isAjaxRequest() && (source = (String)params.get("javax.faces.source")) != null) {
            return clientId.equals(Components.stripIterationIndexFromClientId(source));
        }
        if (component instanceof UICommand) {
            for (String name : params.keySet()) {
                if (name.startsWith("javax.faces.") || !clientId.equals(Components.stripIterationIndexFromClientId(name))) continue;
                return true;
            }
        }
        return false;
    }

    public static List<ParamHolder> getParams(UIComponent component) {
        if (component.getChildCount() > 0) {
            ArrayList<SimpleParam> params = new ArrayList<SimpleParam>(component.getChildCount());
            for (UIComponent child : component.getChildren()) {
                UIParameter param;
                String name;
                if (!(child instanceof UIParameter) || Utils.isEmpty(name = (param = (UIParameter)child).getName()) || param.isDisable()) continue;
                SimpleParam paramHolder = new SimpleParam(name, param.getValue());
                if (param instanceof Param) {
                    paramHolder.setConverter(((Param)param).getConverter());
                }
                params.add(paramHolder);
            }
            return Collections.unmodifiableList(params);
        }
        return Collections.emptyList();
    }

    public static ValueExpression createValueExpression(String expression, Class<?> type) {
        FacesContext context = FacesContext.getCurrentInstance();
        return context.getApplication().getExpressionFactory().createValueExpression(context.getELContext(), expression, type);
    }

    public static MethodExpression createMethodExpression(String expression, Class<?> returnType, Class<?> ... parameterTypes) {
        FacesContext context = FacesContext.getCurrentInstance();
        return context.getApplication().getExpressionFactory().createMethodExpression(context.getELContext(), expression, returnType, (Class[])parameterTypes);
    }

    public static MethodExpression createVoidMethodExpression(String expression, Class<?> ... parameterTypes) {
        return Components.createMethodExpression(expression, Void.class, parameterTypes);
    }

    public static MethodExpressionActionListener createActionListenerMethodExpression(String expression) {
        return new MethodExpressionActionListener(Components.createVoidMethodExpression(expression, ActionEvent.class));
    }

    public static AjaxBehavior createAjaxBehavior(String expression) {
        FacesContext context = FacesContext.getCurrentInstance();
        AjaxBehavior behavior = (AjaxBehavior)context.getApplication().createBehavior("javax.faces.behavior.Ajax");
        final MethodExpression method = Components.createVoidMethodExpression(expression, AjaxBehaviorEvent.class);
        behavior.addAjaxBehaviorListener(new AjaxBehaviorListener(){

            public void processAjaxBehavior(AjaxBehaviorEvent event) throws AbortProcessingException {
                method.invoke(Faces.getELContext(), new Object[]{event});
            }
        });
        return behavior;
    }

    public static <C extends UIComponent> void validateHasParent(UIComponent component, Class<C> parentType) throws IllegalArgumentException {
        if (Components.getClosestParent(component, parentType) == null) {
            throw new IllegalArgumentException(String.format(ERROR_INVALID_PARENT, component.getClass().getSimpleName(), parentType));
        }
    }

    public static <C extends UIComponent> void validateHasDirectParent(UIComponent component, Class<C> parentType) throws IllegalArgumentException {
        if (!parentType.isInstance(component.getParent())) {
            throw new IllegalArgumentException(String.format(ERROR_INVALID_DIRECT_PARENT, component.getClass().getSimpleName(), parentType));
        }
    }

    public static void validateHasNoChildren(UIComponent component) throws IllegalArgumentException {
        if (component.getChildCount() > 0) {
            StringBuilder childClassNames = new StringBuilder();
            for (UIComponent child : component.getChildren()) {
                if (childClassNames.length() > 0) {
                    childClassNames.append(", ");
                }
                childClassNames.append(child.getClass().getName());
            }
            throw new IllegalArgumentException(String.format(ERROR_CHILDREN_DISALLOWED, component.getClass().getSimpleName(), childClassNames));
        }
    }

    private static String stripIterationIndexFromClientId(String clientId) {
        String separatorChar = Character.toString(UINamingContainer.getSeparatorChar((FacesContext)Faces.getContext()));
        return clientId.replaceAll(Pattern.quote(separatorChar) + "[0-9]+" + Pattern.quote(separatorChar), separatorChar);
    }

    private static UIComponent findComponentIgnoringIAE(UIViewRoot viewRoot, String clientId) {
        try {
            return viewRoot.findComponent(clientId);
        }
        catch (IllegalArgumentException ignore) {
            return null;
        }
    }

    public static class ForEach {
        private FacesContext facesContext;
        private UIComponent root;
        private Collection<String> ids;
        private Set<VisitHint> hints;
        private Class<?>[] types;

        public ForEach() {
            this.facesContext = Faces.getContext();
        }

        public ForEach(FacesContext facesContext) {
            this.facesContext = facesContext;
        }

        public ForEach fromRoot(UIComponent root) {
            this.root = root;
            return this;
        }

        public ForEach havingIds(Collection<String> ids) {
            this.ids = ids;
            return this;
        }

        public ForEach havingIds(String ... ids) {
            this.ids = Arrays.asList(ids);
            return this;
        }

        public ForEach withHints(Set<VisitHint> hints) {
            this.hints = hints;
            return this;
        }

        public ForEach withHints(VisitHint ... hints) {
            if (hints.length > 0) {
                EnumSet<VisitHint> hintsSet = EnumSet.noneOf(hints[0].getDeclaringClass());
                for (VisitHint hint : hints) {
                    hintsSet.add(hint);
                }
                this.hints = hintsSet;
            }
            return this;
        }

        @SafeVarargs
        public final ForEach ofTypes(Class<?> ... types) {
            this.types = types;
            return this;
        }

        public void invoke(final Callback.WithArgument<UIComponent> operation) {
            this.invoke(new VisitCallback(){

                public VisitResult visit(VisitContext context, UIComponent target) {
                    operation.invoke(target);
                    return VisitResult.ACCEPT;
                }
            });
        }

        public void invoke(final Callback.ReturningWithArgument<VisitResult, UIComponent> operation) {
            this.invoke(new VisitCallback(){

                public VisitResult visit(VisitContext context, UIComponent target) {
                    return (VisitResult)operation.invoke(target);
                }
            });
        }

        public void invoke(VisitCallback operation) {
            VisitCallback callback = operation;
            if (this.types != null) {
                callback = new TypesVisitCallback(this.types, callback);
            }
            this.getRoot().visitTree(VisitContext.createVisitContext((FacesContext)Faces.getContext(), this.getIds(), this.getHints()), callback);
        }

        protected FacesContext getFacesContext() {
            return this.facesContext;
        }

        protected UIComponent getRoot() {
            return this.root != null ? this.root : this.getFacesContext().getViewRoot();
        }

        protected Collection<String> getIds() {
            return this.ids;
        }

        protected Set<VisitHint> getHints() {
            return this.hints;
        }

        private static class TypesVisitCallback
        implements VisitCallback {
            private Class<?>[] types;
            private VisitCallback next;

            public TypesVisitCallback(Class<?>[] types, VisitCallback next) {
                this.types = types;
                this.next = next;
            }

            public VisitResult visit(VisitContext context, UIComponent target) {
                if (Utils.isOneInstanceOf(target.getClass(), this.types)) {
                    return this.next.visit(context, target);
                }
                return VisitResult.ACCEPT;
            }
        }
    }
}

