/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javax.enterprise.context.spi.AlterableContext;
import javax.enterprise.context.spi.Context;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.Typed;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InjectionPoint;
import org.omnifaces.cdi.beans.InjectionPointGenerator;

@Typed
public final class BeansLocal {
    private static final String ERROR_NO_ALTERABLE_CONTEXT = "Bean '%s' is put in context '%s' which is not an alterable context.";

    private BeansLocal() {
    }

    public static <T> Bean<T> resolve(BeanManager beanManager, Class<T> beanClass) {
        Set beans = beanManager.getBeans(beanClass, new Annotation[0]);
        for (Bean bean : beans) {
            if (bean.getBeanClass() != beanClass) continue;
            return beanManager.resolve(Collections.singleton(bean));
        }
        return beanManager.resolve(beans);
    }

    public static <T> T getReference(BeanManager beanManager, Class<T> beanClass) {
        Bean<T> bean = BeansLocal.resolve(beanManager, beanClass);
        return bean != null ? (T)BeansLocal.getReference(beanManager, bean) : null;
    }

    public static <T> T getReference(BeanManager beanManager, Bean<T> bean) {
        return (T)beanManager.getReference(bean, (Type)bean.getBeanClass(), beanManager.createCreationalContext(bean));
    }

    public static <T> T getInstance(BeanManager beanManager, Class<T> beanClass) {
        return BeansLocal.getInstance(beanManager, beanClass, true);
    }

    public static <T> T getInstance(BeanManager beanManager, Class<T> beanClass, boolean create) {
        Bean<T> bean = BeansLocal.resolve(beanManager, beanClass);
        return bean != null ? (T)BeansLocal.getInstance(beanManager, bean, create) : null;
    }

    public static <T> T getInstance(BeanManager beanManager, Bean<T> bean, boolean create) {
        Context context = beanManager.getContext(bean.getScope());
        if (create) {
            return (T)context.get(bean, beanManager.createCreationalContext(bean));
        }
        return (T)context.get(bean);
    }

    public static <S extends Annotation> Map<Object, String> getActiveInstances(BeanManager beanManager, Class<S> scope) {
        HashMap<Object, String> activeInstances = new HashMap<Object, String>();
        Set beans = beanManager.getBeans(Object.class, new Annotation[0]);
        Context context = beanManager.getContext(scope);
        for (Bean bean : beans) {
            Object instance = context.get((Contextual)bean);
            if (instance == null) continue;
            activeInstances.put(instance, bean.getName());
        }
        return Collections.unmodifiableMap(activeInstances);
    }

    public static <T> void destroy(BeanManager beanManager, Class<T> beanClass) {
        Bean<T> bean = BeansLocal.resolve(beanManager, beanClass);
        if (bean != null) {
            BeansLocal.destroy(beanManager, bean);
        }
    }

    public static <T> void destroy(BeanManager beanManager, Bean<T> bean) {
        Context context = beanManager.getContext(bean.getScope());
        if (!(context instanceof AlterableContext)) {
            throw new IllegalArgumentException(String.format(ERROR_NO_ALTERABLE_CONTEXT, bean.getBeanClass(), context.getClass()));
        }
        ((AlterableContext)context).destroy(bean);
    }

    public static <A extends Annotation> A getAnnotation(BeanManager beanManager, Annotated annotated, Class<A> annotationType) {
        annotated.getAnnotation(annotationType);
        if (annotated.getAnnotations().isEmpty()) {
            return null;
        }
        if (annotated.isAnnotationPresent(annotationType)) {
            return (A)annotated.getAnnotation(annotationType);
        }
        LinkedList annotations = new LinkedList(annotated.getAnnotations());
        while (!annotations.isEmpty()) {
            Annotation annotation = (Annotation)annotations.remove();
            if (annotation.annotationType().equals(annotationType)) {
                return (A)((Annotation)annotationType.cast(annotation));
            }
            if (!beanManager.isStereotype(annotation.annotationType())) continue;
            annotations.addAll(beanManager.getStereotypeDefinition(annotation.annotationType()));
        }
        return null;
    }

    public static InjectionPoint getCurrentInjectionPoint(BeanManager beanManager, CreationalContext<?> creationalContext) {
        return (InjectionPoint)beanManager.getInjectableReference((InjectionPoint)BeansLocal.resolve(beanManager, InjectionPointGenerator.class).getInjectionPoints().iterator().next(), creationalContext);
    }
}

