/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.util;

import java.util.Collection;
import java.util.Map;
import javax.faces.component.UIColumn;
import javax.faces.component.UIComponent;
import javax.faces.component.UIData;
import javax.faces.component.UIForm;
import javax.faces.component.UINamingContainer;
import javax.faces.context.FacesContext;
import javax.faces.context.PartialViewContext;
import org.omnifaces.context.OmniPartialViewContext;
import org.omnifaces.util.Components;
import org.omnifaces.util.Faces;

public final class Ajax {
    private static final String ERROR_ARGUMENTS_LENGTH = "The arguments length must be even. Encountered %d items.";
    private static final String ERROR_ARGUMENT_TYPE = "The argument name must be a String. Encountered type '%s' with value '%s'.";

    private Ajax() {
    }

    public static PartialViewContext getContext() {
        return Faces.getContext().getPartialViewContext();
    }

    public static void update(String ... clientIds) {
        PartialViewContext context = Ajax.getContext();
        Collection renderIds = context.getRenderIds();
        for (String clientId : clientIds) {
            UIComponent currentComponent;
            if (clientId.charAt(0) != '@') {
                renderIds.add(clientId);
                continue;
            }
            if (clientId.equals("@all")) {
                context.setRenderAll(true);
                continue;
            }
            if (clientId.equals("@form")) {
                UIForm currentForm = Components.getCurrentForm();
                if (currentForm == null) continue;
                renderIds.add(currentForm.getClientId());
                continue;
            }
            if (!clientId.equals("@this") || (currentComponent = Components.getCurrentComponent()) == null) continue;
            renderIds.add(currentComponent.getClientId());
        }
    }

    public static void updateAll() {
        Ajax.getContext().setRenderAll(true);
    }

    public static void updateRow(UIData table, int index) {
        int rowCount;
        if (index < 0 || table.getRowCount() < 1 || table.getChildCount() == 0) {
            return;
        }
        int n = rowCount = table.getRows() == 0 ? table.getRowCount() : table.getRows();
        if (index >= rowCount) {
            return;
        }
        Ajax.updateRowCells(table, index);
    }

    private static void updateRowCells(UIData table, int index) {
        FacesContext context = FacesContext.getCurrentInstance();
        String tableId = table.getClientId(context);
        char separator = UINamingContainer.getSeparatorChar((FacesContext)context);
        Collection renderIds = Ajax.getContext().getRenderIds();
        for (UIComponent column : table.getChildren()) {
            if (!(column instanceof UIColumn)) continue;
            for (UIComponent cell : column.getChildren()) {
                renderIds.add(String.format("%s%c%d%c%s", tableId, Character.valueOf(separator), index, Character.valueOf(separator), cell.getId()));
            }
        }
    }

    public static void updateColumn(UIData table, int index) {
        int rowCount;
        if (index < 0 || table.getRowCount() < 1 || index > table.getChildCount()) {
            return;
        }
        int n = rowCount = table.getRows() == 0 ? table.getRowCount() : table.getRows();
        if (rowCount == 0) {
            return;
        }
        Ajax.updateColumnCells(table, index, rowCount);
    }

    private static void updateColumnCells(UIData table, int index, int rowCount) {
        FacesContext context = FacesContext.getCurrentInstance();
        String tableId = table.getClientId(context);
        char separator = UINamingContainer.getSeparatorChar((FacesContext)context);
        Collection renderIds = Ajax.getContext().getRenderIds();
        int columnIndex = 0;
        for (UIComponent column : table.getChildren()) {
            if (!(column instanceof UIColumn) || columnIndex++ != index) continue;
            for (UIComponent cell : column.getChildren()) {
                String cellId = cell.getId();
                for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
                    renderIds.add(String.format("%s%c%d%c%s", tableId, Character.valueOf(separator), rowIndex, Character.valueOf(separator), cellId));
                }
            }
        }
    }

    public static void oncomplete(String ... scripts) {
        OmniPartialViewContext context = OmniPartialViewContext.getCurrentInstance();
        for (String script : scripts) {
            context.addCallbackScript(script);
        }
    }

    public static void data(String name, Object value) {
        OmniPartialViewContext.getCurrentInstance().addArgument(name, value);
    }

    public static void data(Object ... namesValues) {
        if (namesValues.length % 2 != 0) {
            throw new IllegalArgumentException(String.format(ERROR_ARGUMENTS_LENGTH, namesValues.length));
        }
        OmniPartialViewContext context = OmniPartialViewContext.getCurrentInstance();
        for (int i = 0; i < namesValues.length; i += 2) {
            if (!(namesValues[i] instanceof String)) {
                String type = namesValues[i] != null ? namesValues[i].getClass().getName() : "null";
                throw new IllegalArgumentException(String.format(ERROR_ARGUMENT_TYPE, type, namesValues[i]));
            }
            context.addArgument((String)namesValues[i], namesValues[i + 1]);
        }
    }

    public static void data(Map<String, Object> data) {
        OmniPartialViewContext context = OmniPartialViewContext.getCurrentInstance();
        for (Map.Entry<String, Object> entry : data.entrySet()) {
            context.addArgument(entry.getKey(), entry.getValue());
        }
    }
}

