/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.taghandler;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ValueExpression;
import javax.el.ValueReference;
import javax.faces.FacesException;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UICommand;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseId;
import javax.faces.event.PostValidateEvent;
import javax.faces.event.PreValidateEvent;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;
import javax.faces.view.facelets.ComponentHandler;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.TagConfig;
import javax.faces.view.facelets.TagHandler;
import javax.validation.ConstraintViolation;
import org.omnifaces.el.ExpressionInspector;
import org.omnifaces.eventlistener.BeanValidationEventListener;
import org.omnifaces.util.Callback;
import org.omnifaces.util.Components;
import org.omnifaces.util.Events;
import org.omnifaces.util.Facelets;
import org.omnifaces.util.Faces;
import org.omnifaces.util.FacesLocal;
import org.omnifaces.util.Messages;
import org.omnifaces.util.Platform;
import org.omnifaces.util.Reflection;
import org.omnifaces.util.Utils;
import org.omnifaces.util.copier.Copier;
import org.omnifaces.util.copier.MultiStrategyCopier;

public class ValidateBean
extends TagHandler {
    private static final Logger logger = Logger.getLogger(ValidateBean.class.getName());
    private static final String ERROR_MISSING_FORM = "o:validateBean must be nested in an UIForm.";
    private static final String ERROR_INVALID_PARENT = "o:validateBean parent must be an instance of UIInput or UICommand.";
    private ValueExpression value;
    private boolean disabled;
    private ValidateMethod method;
    private String groups;
    private String copier;

    public ValidateBean(TagConfig config) {
        super(config);
    }

    public void apply(FaceletContext context, final UIComponent parent) throws IOException {
        if (this.getAttribute("value") == null && !(parent instanceof UICommand) && !(parent instanceof UIInput)) {
            throw new IllegalArgumentException(ERROR_INVALID_PARENT);
        }
        FacesContext facesContext = context.getFacesContext();
        if (!ComponentHandler.isNew((UIComponent)parent) || !facesContext.isPostback() || facesContext.getCurrentPhaseId() != PhaseId.RESTORE_VIEW) {
            return;
        }
        this.value = Facelets.getValueExpression(context, this.getAttribute("value"), Object.class);
        this.disabled = Facelets.getBoolean(context, this.getAttribute("disabled"));
        this.method = ValidateMethod.of(Facelets.getString(context, this.getAttribute("method")));
        this.groups = Facelets.getString(context, this.getAttribute("validationGroups"));
        this.copier = Facelets.getString(context, this.getAttribute("copier"));
        Events.subscribeToRequestAfterPhase(PhaseId.RESTORE_VIEW, new Callback.Void(){

            @Override
            public void invoke() {
                ValidateBean.this.processValidateBean(parent);
            }
        });
    }

    protected void processValidateBean(UIComponent component) {
        Object bean;
        UIForm form;
        UIForm uIForm = form = component instanceof UIForm ? (UIForm)component : Components.getClosestParent(component, UIForm.class);
        if (form == null) {
            throw new IllegalArgumentException(ERROR_MISSING_FORM);
        }
        if (!form.equals(Components.getCurrentForm()) || component instanceof UICommand && !Components.hasInvokedSubmit(component)) {
            return;
        }
        Object object = bean = this.value != null ? this.value.getValue(Faces.getELContext()) : null;
        if (bean == null) {
            this.validateForm(this.groups, this.disabled);
            return;
        }
        if (this.disabled) {
            return;
        }
        switch (this.method) {
            case validateActual: {
                this.validateActualBean(form, bean, this.groups);
                break;
            }
            case validateCopy: {
                this.validateCopiedBean(form, bean, this.copier, this.groups);
            }
        }
    }

    private void validateActualBean(final UIForm form, final Object bean, final String groups) {
        ValidateBeanCallback validateActualBean = new ValidateBeanCallback(){

            @Override
            public void run() {
                FacesContext context = FacesContext.getCurrentInstance();
                ValidateBean.validate(context, form, bean, groups, false);
            }
        };
        Events.subscribeToRequestAfterPhase(PhaseId.UPDATE_MODEL_VALUES, validateActualBean);
    }

    private void validateCopiedBean(final UIForm form, final Object bean, final String copier, final String groups) {
        final HashMap properties = new HashMap();
        ValidateBeanCallback collectBeanProperties = new ValidateBeanCallback(){

            @Override
            public void run() {
                FacesContext context = FacesContext.getCurrentInstance();
                ValidateBean.forEachInputWithMatchingBase(context, (UIComponent)form, bean, new Operation(){

                    @Override
                    public void run(EditableValueHolder v, ValueReference vr) {
                        ValidateBean.addCollectingValidator(v, vr, properties);
                    }
                });
            }
        };
        ValidateBeanCallback checkConstraints = new ValidateBeanCallback(){

            @Override
            public void run() {
                FacesContext context = FacesContext.getCurrentInstance();
                ValidateBean.forEachInputWithMatchingBase(context, (UIComponent)form, bean, new Operation(){

                    @Override
                    public void run(EditableValueHolder v, ValueReference vr) {
                        ValidateBean.removeCollectingValidator(v);
                    }
                });
                Object copiedBean = ValidateBean.getCopier(context, copier).copy(bean);
                Reflection.setProperties(copiedBean, properties);
                ValidateBean.validate(context, form, copiedBean, groups, true);
            }
        };
        Events.subscribeToRequestBeforePhase(PhaseId.PROCESS_VALIDATIONS, collectBeanProperties);
        Events.subscribeToRequestAfterPhase(PhaseId.PROCESS_VALIDATIONS, checkConstraints);
    }

    private void validateForm(final String validationGroups, final boolean disabled) {
        ValidateBeanCallback validateForm = new ValidateBeanCallback(){

            @Override
            public void run() {
                BeanValidationEventListener listener = new BeanValidationEventListener(validationGroups, disabled);
                Events.subscribeToViewEvent(PreValidateEvent.class, listener);
                Events.subscribeToViewEvent(PostValidateEvent.class, listener);
            }
        };
        Events.subscribeToRequestBeforePhase(PhaseId.PROCESS_VALIDATIONS, validateForm);
    }

    private static void forEachInputWithMatchingBase(final FacesContext context, UIComponent form, final Object base, final Operation operation) {
        Components.forEachComponent(context).fromRoot(form).ofTypes(EditableValueHolder.class).invoke(new Callback.WithArgument<UIComponent>(){

            @Override
            public void invoke(UIComponent component) {
                ValueReference valueReference;
                ValueExpression valueExpression = component.getValueExpression("value");
                if (valueExpression != null && (valueReference = ExpressionInspector.getValueReference(context.getELContext(), valueExpression)).getBase().equals(base)) {
                    operation.run((EditableValueHolder)component, valueReference);
                }
            }
        });
    }

    private static void addCollectingValidator(EditableValueHolder valueHolder, ValueReference valueReference, Map<String, Object> propertyValues) {
        valueHolder.addValidator((Validator)new CollectingValidator(propertyValues, valueReference.getProperty().toString()));
    }

    private static void removeCollectingValidator(EditableValueHolder valueHolder) {
        Validator collectingValidator = null;
        for (Validator validator : valueHolder.getValidators()) {
            if (!(validator instanceof CollectingValidator)) continue;
            collectingValidator = validator;
            break;
        }
        if (collectingValidator != null) {
            valueHolder.removeValidator(collectingValidator);
        }
    }

    private static Copier getCopier(FacesContext context, String copierName) {
        Copier copier = null;
        if (!Utils.isEmpty(copierName)) {
            Object expressionResult = FacesLocal.evaluateExpressionGet(context, copierName);
            if (expressionResult instanceof Copier) {
                copier = (Copier)expressionResult;
            } else if (expressionResult instanceof String) {
                copier = (Copier)Reflection.instance((String)expressionResult);
            }
        }
        if (copier == null) {
            copier = new MultiStrategyCopier();
        }
        return copier;
    }

    private static void validate(FacesContext context, UIForm form, Object bean, String groups, boolean renderResponseOnFail) {
        ArrayList groupClasses = new ArrayList();
        for (String group : Utils.csvToList(groups)) {
            groupClasses.add(Reflection.toClass(group));
        }
        Set violationsRaw = Platform.getBeanValidator().validate(bean, groupClasses.toArray(new Class[groupClasses.size()]));
        Set violations = violationsRaw;
        if (!violations.isEmpty()) {
            context.validationFailed();
            String formId = form.getClientId(context);
            for (ConstraintViolation violation : violations) {
                context.addMessage(formId, Messages.createError(violation.getMessage(), new Object[0]));
            }
            if (renderResponseOnFail) {
                context.renderResponse();
            }
        }
    }

    private static abstract class Operation
    implements Callback.WithArgument<Object[]> {
        private Operation() {
        }

        @Override
        public void invoke(Object[] args) {
            this.run((EditableValueHolder)args[0], (ValueReference)args[1]);
        }

        public abstract void run(EditableValueHolder var1, ValueReference var2);
    }

    private static abstract class ValidateBeanCallback
    implements Callback.Void {
        private ValidateBeanCallback() {
        }

        @Override
        public void invoke() {
            try {
                this.run();
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Exception occured while doing validation.", e);
                Faces.validationFailed();
                Faces.renderResponse();
                throw new FacesException((Throwable)e);
            }
        }

        public abstract void run();
    }

    public static final class CollectingValidator
    implements Validator {
        private final Map<String, Object> propertyValues;
        private final String property;

        public CollectingValidator(Map<String, Object> propertyValues, String property) {
            this.propertyValues = propertyValues;
            this.property = property;
        }

        public void validate(FacesContext context, UIComponent component, Object value) throws ValidatorException {
            this.propertyValues.put(this.property, value);
        }
    }

    private static enum ValidateMethod {
        validateCopy,
        validateActual;


        public static ValidateMethod of(String name) {
            if (Utils.isEmpty(name)) {
                return validateCopy;
            }
            return ValidateMethod.valueOf(name);
        }
    }
}

