/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.taghandler;

import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import javax.el.FunctionMapper;
import javax.faces.component.UIComponent;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.TagAttribute;
import javax.faces.view.facelets.TagConfig;
import javax.faces.view.facelets.TagHandler;
import org.omnifaces.taghandler.ImportConstants;

public class ImportFunctions
extends TagHandler {
    private static final Map<String, Method> FUNCTIONS_CACHE = new ConcurrentHashMap<String, Method>();
    private static final String ERROR_INVALID_VAR = "The 'var' attribute may not be an EL expression.";
    private String varValue;
    private TagAttribute typeAttribute;

    public ImportFunctions(TagConfig config) {
        super(config);
        TagAttribute var = this.getAttribute("var");
        if (var != null) {
            if (var.isLiteral()) {
                this.varValue = var.getValue();
            } else {
                throw new IllegalArgumentException(ERROR_INVALID_VAR);
            }
        }
        this.typeAttribute = this.getRequiredAttribute("type");
    }

    public void apply(FaceletContext context, UIComponent parent) throws IOException {
        String type = this.typeAttribute.getValue(context);
        final Class<?> cls = ImportConstants.toClass(type);
        final String var = this.varValue != null ? this.varValue : type.substring(type.lastIndexOf(46) + 1);
        final FunctionMapper originalFunctionMapper = context.getFunctionMapper();
        context.setFunctionMapper(new FunctionMapper(){

            public Method resolveFunction(String prefix, String name) {
                if (var.equals(prefix)) {
                    String key = cls + "." + name;
                    Method function = (Method)FUNCTIONS_CACHE.get(key);
                    if (function == null) {
                        function = ImportFunctions.findMethod(cls, name);
                        FUNCTIONS_CACHE.put(key, function);
                    }
                    return function;
                }
                return originalFunctionMapper.resolveFunction(prefix, name);
            }
        });
    }

    private static Method findMethod(Class<?> cls, String name) {
        TreeSet<Method> methods = new TreeSet<Method>(new Comparator<Method>(){

            @Override
            public int compare(Method m1, Method m2) {
                return Integer.valueOf(m1.getParameterTypes().length).compareTo(m2.getParameterTypes().length);
            }
        });
        for (Method method : cls.getDeclaredMethods()) {
            if (!method.getName().equals(name) || !ImportFunctions.isPublicStaticNonVoid(method)) continue;
            methods.add(method);
        }
        return methods.isEmpty() ? null : (Method)methods.iterator().next();
    }

    private static boolean isPublicStaticNonVoid(Method method) {
        int modifiers = method.getModifiers();
        return Modifier.isPublic(modifiers) && Modifier.isStatic(modifiers) && method.getReturnType() != Void.TYPE;
    }
}

