/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.taghandler;

import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.el.ELContext;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.application.Application;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.view.AttachedObjectHandler;
import javax.faces.view.facelets.DelegatingMetaTagHandler;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.MetaRuleset;
import javax.faces.view.facelets.TagAttribute;
import javax.faces.view.facelets.TagHandlerDelegate;
import org.omnifaces.util.FacesLocal;

final class DeferredTagHandlerHelper {
    private static final String ERROR_MISSING_ID = "%s '%s' or 'binding' attribute must be specified.";
    private static final String ERROR_INVALID_ID = "%s '%s' attribute must refer an valid %1$s ID. The %1$s ID '%s' cannot be found.";

    private DeferredTagHandlerHelper() {
    }

    static <T> T createInstance(FaceletContext context, DeferredTagHandler tag, String instanceId) {
        ValueExpression binding = DeferredTagHandlerHelper.getValueExpression(context, tag, "binding", Object.class);
        ValueExpression id = DeferredTagHandlerHelper.getValueExpression(context, tag, instanceId, String.class);
        Object instance = null;
        if (binding != null) {
            instance = binding.getValue((ELContext)context);
        }
        if (id != null) {
            try {
                instance = tag.create(context.getFacesContext().getApplication(), (String)id.getValue((ELContext)context));
            }
            catch (FacesException e) {
                throw new IllegalArgumentException(String.format(ERROR_INVALID_ID, tag.getClass().getSimpleName(), instanceId, id), e);
            }
            if (binding != null) {
                binding.setValue((ELContext)context, instance);
            }
        } else if (instance == null) {
            throw new IllegalArgumentException(String.format(ERROR_MISSING_ID, tag.getClass().getSimpleName(), instanceId));
        }
        return (T)instance;
    }

    static <T> DeferredAttributes collectDeferredAttributes(FaceletContext context, DeferredTagHandler tag, T instance) {
        DeferredAttributes attributes = new DeferredAttributes();
        try {
            for (PropertyDescriptor property : Introspector.getBeanInfo(instance.getClass()).getPropertyDescriptors()) {
                ValueExpression ve;
                Method setter = property.getWriteMethod();
                if (setter == null || (ve = DeferredTagHandlerHelper.getValueExpression(context, tag, property.getName(), property.getPropertyType())) == null) continue;
                if (ve.isLiteralText()) {
                    setter.invoke(instance, ve.getValue((ELContext)context));
                    continue;
                }
                attributes.add(setter, ve);
            }
        }
        catch (Exception e) {
            throw new FacesException((Throwable)e);
        }
        return attributes;
    }

    static <T> ValueExpression getValueExpression(FaceletContext context, DeferredTagHandler tag, String name, Class<T> type) {
        TagAttribute attribute = tag.getTagAttribute(name);
        return attribute != null ? attribute.getValueExpression(context, type) : null;
    }

    static class DeferredTagHandlerDelegate
    extends TagHandlerDelegate
    implements AttachedObjectHandler {
        private DelegatingMetaTagHandler tag;
        private TagHandlerDelegate delegate;

        public DeferredTagHandlerDelegate(DelegatingMetaTagHandler tag, TagHandlerDelegate delegate) {
            this.tag = tag;
            this.delegate = delegate;
        }

        public void apply(FaceletContext context, UIComponent component) throws IOException {
            this.delegate.apply(context, component);
        }

        public String getFor() {
            return ((AttachedObjectHandler)this.delegate).getFor();
        }

        public void applyAttachedObject(FacesContext context, UIComponent parent) {
            try {
                this.tag.apply(FacesLocal.getFaceletContext(context), parent);
            }
            catch (IOException e) {
                throw new FacesException((Throwable)e);
            }
        }

        public MetaRuleset createMetaRuleset(Class type) {
            return this.delegate.createMetaRuleset(type);
        }
    }

    static final class DeferredAttributes {
        private Map<Method, ValueExpression> attributes = new HashMap<Method, ValueExpression>();

        private DeferredAttributes() {
        }

        private void add(Method setter, ValueExpression valueExpression) {
            this.attributes.put(setter, valueExpression);
        }

        public void invokeSetters(ELContext elContext, Object object) {
            for (Map.Entry<Method, ValueExpression> entry : this.attributes.entrySet()) {
                try {
                    entry.getKey().invoke(object, entry.getValue().getValue(elContext));
                }
                catch (Exception e) {
                    throw new FacesException((Throwable)e);
                }
            }
        }
    }

    static interface DeferredTagHandler {
        public TagAttribute getTagAttribute(String var1);

        public <T> T create(Application var1, String var2);
    }
}

