/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.servlet;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.omnifaces.io.ResettableBuffer;
import org.omnifaces.io.ResettableBufferedOutputStream;
import org.omnifaces.io.ResettableBufferedWriter;

public abstract class HttpServletResponseOutputWrapper
extends HttpServletResponseWrapper {
    private static final String ERROR_GETOUTPUT_ALREADY_CALLED = "getOutputStream() has already been called on this response.";
    private static final String ERROR_GETWRITER_ALREADY_CALLED = "getWriter() has already been called on this response.";
    private ServletOutputStream output;
    private PrintWriter writer;
    private ResettableBuffer buffer;
    private boolean passThrough;

    public HttpServletResponseOutputWrapper(HttpServletResponse wrappedResponse) {
        super(wrappedResponse);
    }

    protected abstract OutputStream createOutputStream();

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.passThrough) {
            return super.getOutputStream();
        }
        if (this.writer != null) {
            throw new IllegalStateException(ERROR_GETWRITER_ALREADY_CALLED);
        }
        if (this.output == null) {
            this.buffer = new ResettableBufferedOutputStream(this.createOutputStream(), this.getBufferSize());
            this.output = new ServletOutputStream(){

                public void write(int b) throws IOException {
                    ((OutputStream)((Object)HttpServletResponseOutputWrapper.this.buffer)).write(b);
                }

                public void write(byte[] bytes) throws IOException {
                    ((OutputStream)((Object)HttpServletResponseOutputWrapper.this.buffer)).write(bytes);
                }

                public void write(byte[] bytes, int offset, int length) throws IOException {
                    ((OutputStream)((Object)HttpServletResponseOutputWrapper.this.buffer)).write(bytes, offset, length);
                }

                public void flush() throws IOException {
                    ((OutputStream)((Object)HttpServletResponseOutputWrapper.this.buffer)).flush();
                }

                public void close() throws IOException {
                    ((OutputStream)((Object)HttpServletResponseOutputWrapper.this.buffer)).close();
                }
            };
        }
        return this.output;
    }

    public PrintWriter getWriter() throws IOException {
        if (this.passThrough) {
            return super.getWriter();
        }
        if (this.output != null) {
            throw new IllegalStateException(ERROR_GETOUTPUT_ALREADY_CALLED);
        }
        if (this.writer == null) {
            this.buffer = new ResettableBufferedWriter(new OutputStreamWriter(this.createOutputStream(), this.getCharacterEncoding()), this.getBufferSize(), this.getCharacterEncoding());
            this.writer = new PrintWriter((Writer)((Object)this.buffer));
        }
        return this.writer;
    }

    public void flushBuffer() throws IOException {
        super.flushBuffer();
        if (this.passThrough) {
            return;
        }
        if (this.writer != null) {
            this.writer.flush();
        } else if (this.output != null) {
            this.output.flush();
        }
    }

    public void close() throws IOException {
        if (this.writer != null) {
            this.writer.close();
        } else if (this.output != null) {
            this.output.close();
        }
    }

    public void reset() {
        super.reset();
        if (this.buffer != null) {
            this.buffer.reset();
        }
    }

    public boolean isCommitted() {
        return super.isCommitted() || this.buffer != null && !this.buffer.isResettable();
    }

    public boolean isPassThrough() {
        return this.passThrough;
    }

    public void setPassThrough(boolean passThrough) {
        this.passThrough = passThrough;
    }
}

