/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.resourcehandler;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.faces.application.Resource;
import javax.faces.application.ResourceHandler;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import org.omnifaces.resourcehandler.DefaultResourceHandler;
import org.omnifaces.resourcehandler.RemappedResource;
import org.omnifaces.util.Faces;
import org.omnifaces.util.Hacks;
import org.omnifaces.util.Utils;

public class UnmappedResourceHandler
extends DefaultResourceHandler {
    public UnmappedResourceHandler(ResourceHandler wrapped) {
        super(wrapped);
    }

    @Override
    public Resource decorateResource(Resource resource) {
        if (resource == null) {
            return resource;
        }
        String unmappedRequestPath = UnmappedResourceHandler.unmapRequestPath(resource.getRequestPath());
        return new RemappedResource(resource, unmappedRequestPath);
    }

    public boolean isResourceRequest(FacesContext context) {
        return "/javax.faces.resource".equals(context.getExternalContext().getRequestServletPath());
    }

    public void handleResourceRequest(FacesContext context) throws IOException {
        Resource resource = UnmappedResourceHandler.createResource(context);
        if (resource == null) {
            super.handleResourceRequest(context);
            return;
        }
        ExternalContext externalContext = context.getExternalContext();
        if (!resource.userAgentNeedsUpdate(context)) {
            externalContext.setResponseStatus(304);
            return;
        }
        InputStream inputStream = resource.getInputStream();
        if (inputStream == null) {
            externalContext.setResponseStatus(404);
            return;
        }
        externalContext.setResponseContentType(resource.getContentType());
        for (Map.Entry header : resource.getResponseHeaders().entrySet()) {
            externalContext.setResponseHeader((String)header.getKey(), (String)header.getValue());
        }
        Utils.stream(inputStream, externalContext.getResponseOutputStream());
    }

    private static String unmapRequestPath(String path) {
        String mapping = Faces.getMapping();
        if (Faces.isPrefixMapping(mapping)) {
            return path.replaceFirst(mapping, "");
        }
        if (path.contains("?")) {
            return path.replace(mapping + "?", "?");
        }
        return path.substring(0, path.length() - mapping.length());
    }

    private static Resource createResource(FacesContext context) {
        String resourceName;
        if (Hacks.isPrimeFacesDynamicResourceRequest(context)) {
            return null;
        }
        String pathInfo = context.getExternalContext().getRequestPathInfo();
        String string = resourceName = pathInfo != null ? pathInfo.substring(1) : "";
        if (resourceName.isEmpty()) {
            return null;
        }
        String libraryName = (String)context.getExternalContext().getRequestParameterMap().get("ln");
        return context.getApplication().getResourceHandler().createResource(resourceName, libraryName);
    }
}

