/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.resourcehandler;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.el.ValueExpression;
import javax.enterprise.context.ApplicationScoped;
import javax.faces.FacesException;
import javax.faces.application.Application;
import javax.faces.component.UIComponent;
import javax.faces.component.UIOutput;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.xml.bind.DatatypeConverter;
import org.omnifaces.el.ExpressionInspector;
import org.omnifaces.el.MethodReference;
import org.omnifaces.resourcehandler.DynamicResource;
import org.omnifaces.util.Faces;
import org.omnifaces.util.Servlets;
import org.omnifaces.util.Utils;

public class GraphicResource
extends DynamicResource {
    private static final String DEFAULT_CONTENT_TYPE = "image";
    private static final Map<String, String> CONTENT_TYPES_BY_BASE64_HEADER = GraphicResource.createContentTypesByBase64Header();
    private static final Map<String, MethodReference> ALLOWED_METHODS = new ConcurrentHashMap<String, MethodReference>();
    private static final String[] EMPTY_PARAMS = new String[0];
    private static final int RESOURCE_NAME_FULL_PARTS_LENGTH = 3;
    private static final Class<? extends Annotation>[] REQUIRED_ANNOTATION_TYPES = new Class[]{javax.faces.bean.ApplicationScoped.class, ApplicationScoped.class};
    private static final String ERROR_INVALID_LASTMODIFIED = "o:graphicImage 'lastModified' attribute must be an instance of Long or Date. Encountered an invalid value of '%s'.";
    private static final String ERROR_INVALID_TYPE = "o:graphicImage 'type' attribute must represent a valid file extension. Encountered an invalid value of '%s'.";
    private static final String ERROR_UNKNOWN_METHOD = "o:graphicImage 'value' attribute must refer an existing method. Encountered an unknown method of '%s'.";
    private static final String ERROR_INVALID_SCOPE = "o:graphicImage 'value' attribute must refer an @ApplicationScoped bean. Cannot find the right annotation on bean class '%s'.";
    private static final String ERROR_INVALID_RETURNTYPE = "o:graphicImage 'value' attribute must represent a method returning an InputStream or byte[]. Encountered an invalid return value of '%s'.";
    private static final String ERROR_INVALID_PARAMS = "o:graphicImage 'value' attribute must specify valid method parameters. Encountered invalid method parameters '%s'.";
    private String base64;
    private String[] params;

    private static Map<String, String> createContentTypesByBase64Header() {
        HashMap<String, String> contentTypesByBase64Header = new HashMap<String, String>();
        contentTypesByBase64Header.put("/9j/", "image/jpeg");
        contentTypesByBase64Header.put("iVBORw", "image/png");
        contentTypesByBase64Header.put("R0lGOD", "image/gif");
        contentTypesByBase64Header.put("AAABAA", "image/x-icon");
        contentTypesByBase64Header.put("PD94bW", "image/svg+xml");
        contentTypesByBase64Header.put("Qk0", "image/bmp");
        contentTypesByBase64Header.put("SUkqAA", "image/tiff");
        contentTypesByBase64Header.put("TU0AKg", "image/tiff");
        return Collections.unmodifiableMap(contentTypesByBase64Header);
    }

    public GraphicResource(Object content, String contentType) {
        super("", "omnifaces.graphic", contentType);
        this.base64 = GraphicResource.convertToBase64(content);
        if (contentType == null) {
            this.setContentType(GraphicResource.guessContentType(this.base64));
        } else if (!contentType.contains("/")) {
            this.setContentType(GraphicResource.resolveContentType(contentType));
        }
    }

    public GraphicResource(String name, String[] params, Object lastModified) {
        super(name, "omnifaces.graphic", GraphicResource.getContentType(name));
        this.params = (String[])Utils.coalesce(params, EMPTY_PARAMS);
        if (lastModified instanceof Long) {
            this.setLastModified((Long)lastModified);
        } else if (lastModified instanceof Date) {
            this.setLastModified(((Date)lastModified).getTime());
        } else if (Utils.isNumber(String.valueOf(lastModified))) {
            this.setLastModified(Long.valueOf(lastModified.toString()));
        } else if (lastModified != null) {
            throw new IllegalArgumentException(String.format(ERROR_INVALID_LASTMODIFIED, lastModified));
        }
    }

    public static GraphicResource create(FacesContext context, ValueExpression value, String type, Object lastModified) {
        MethodReference methodReference = ExpressionInspector.getMethodReference(context.getELContext(), value);
        if (methodReference.getMethod() == null) {
            throw new IllegalArgumentException(String.format(ERROR_UNKNOWN_METHOD, value.getExpressionString()));
        }
        String name = GraphicResource.getResourceName(methodReference, type);
        if (!ALLOWED_METHODS.containsKey(name)) {
            Class<?> beanClass = methodReference.getBase().getClass();
            if (!Utils.isOneAnnotationPresent(beanClass, REQUIRED_ANNOTATION_TYPES)) {
                throw new IllegalArgumentException(String.format(ERROR_INVALID_SCOPE, beanClass));
            }
            ALLOWED_METHODS.put(name, new MethodReference(methodReference.getBase(), methodReference.getMethod()));
        }
        Object[] params = methodReference.getActualParameters();
        String[] convertedParams = GraphicResource.convertToStrings(context, params, methodReference.getMethod().getParameterTypes());
        return new GraphicResource(name, convertedParams, lastModified);
    }

    @Override
    public String getRequestPath() {
        if (this.base64 != null) {
            return "data:" + this.getContentType() + ";base64," + this.base64;
        }
        String queryString = Utils.isEmpty(this.params) ? "" : "&" + Servlets.toQueryString(Collections.singletonMap("p", Arrays.asList(this.params)));
        return super.getRequestPath() + queryString;
    }

    public InputStream getInputStream() throws IOException {
        Object content;
        MethodReference methodReference = ALLOWED_METHODS.get(this.getResourceName().split("\\.", 2)[0]);
        if (methodReference == null) {
            return null;
        }
        Method method = methodReference.getMethod();
        Object[] convertedParams = GraphicResource.convertToObjects(Faces.getContext(), this.params, method.getParameterTypes());
        try {
            content = method.invoke(methodReference.getBase(), convertedParams);
        }
        catch (Exception e) {
            throw new FacesException((Throwable)e);
        }
        if (content == null) {
            return null;
        }
        if (content instanceof InputStream) {
            return (InputStream)content;
        }
        if (content instanceof byte[]) {
            return new ByteArrayInputStream((byte[])content);
        }
        throw new IllegalArgumentException(String.format(ERROR_INVALID_RETURNTYPE, content));
    }

    private static String getResourceName(MethodReference methodReference, String type) {
        return methodReference.getBase().getClass().getSimpleName() + "_" + methodReference.getMethod().getName() + (Utils.isEmpty(type) ? "" : "_" + type);
    }

    private static String getContentType(String resourceName) {
        String[] parts = resourceName.split("_");
        return parts.length == 3 ? GraphicResource.resolveContentType(parts[2]) : DEFAULT_CONTENT_TYPE;
    }

    private static String guessContentType(String base64) {
        for (Map.Entry<String, String> contentTypeByBase64Header : CONTENT_TYPES_BY_BASE64_HEADER.entrySet()) {
            if (!base64.startsWith(contentTypeByBase64Header.getKey())) continue;
            return contentTypeByBase64Header.getValue();
        }
        return DEFAULT_CONTENT_TYPE;
    }

    private static String resolveContentType(String type) {
        String contentType = Faces.getExternalContext().getMimeType("image." + type);
        if (contentType == null) {
            throw new IllegalArgumentException(String.format(ERROR_INVALID_TYPE, type));
        }
        return contentType;
    }

    private static String convertToBase64(Object content) {
        byte[] bytes;
        if (content instanceof InputStream) {
            try {
                bytes = Utils.toByteArray((InputStream)content);
            }
            catch (IOException e) {
                throw new FacesException((Throwable)e);
            }
        } else if (content instanceof byte[]) {
            bytes = (byte[])content;
        } else {
            throw new IllegalArgumentException(String.format(ERROR_INVALID_RETURNTYPE, content));
        }
        return DatatypeConverter.printBase64Binary((byte[])bytes);
    }

    private static String[] convertToStrings(FacesContext context, Object[] values, Class<?>[] types) {
        GraphicResource.validateParamLength(values, types);
        String[] strings = new String[values.length];
        Application application = context.getApplication();
        UIOutput dummyComponent = new UIOutput();
        for (int i = 0; i < values.length; ++i) {
            Object value = values[i];
            Converter converter = application.createConverter(types[i]);
            strings[i] = converter != null ? converter.getAsString(context, (UIComponent)dummyComponent, value) : (value != null ? value.toString() : "");
        }
        return strings;
    }

    private static Object[] convertToObjects(FacesContext context, String[] values, Class<?>[] types) {
        GraphicResource.validateParamLength(values, types);
        Object[] objects = new Object[values.length];
        Application application = context.getApplication();
        UIOutput dummyComponent = new UIOutput();
        for (int i = 0; i < values.length; ++i) {
            String value = Utils.isEmpty(values[i]) ? null : values[i];
            Converter converter = application.createConverter(types[i]);
            objects[i] = converter != null ? converter.getAsObject(context, (UIComponent)dummyComponent, value) : value;
        }
        return objects;
    }

    private static void validateParamLength(Object[] params, Class<?>[] types) {
        if (params.length != types.length) {
            throw new IllegalArgumentException(String.format(ERROR_INVALID_PARAMS, Arrays.toString(params)));
        }
    }
}

