/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.resourcehandler;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.faces.application.Resource;
import javax.faces.application.ResourceHandler;
import javax.faces.component.UIComponent;
import javax.faces.component.UIOutput;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.PreRenderViewEvent;
import javax.faces.event.SystemEvent;
import javax.faces.event.SystemEventListener;
import org.omnifaces.component.script.DeferredScript;
import org.omnifaces.resourcehandler.CDNResourceHandler;
import org.omnifaces.resourcehandler.CombinedResource;
import org.omnifaces.resourcehandler.CombinedResourceInfo;
import org.omnifaces.resourcehandler.DefaultResourceHandler;
import org.omnifaces.resourcehandler.ResourceIdentifier;
import org.omnifaces.util.Events;
import org.omnifaces.util.Faces;
import org.omnifaces.util.Hacks;
import org.omnifaces.util.Utils;

public class CombinedResourceHandler
extends DefaultResourceHandler
implements SystemEventListener {
    public static final String LIBRARY_NAME = "omnifaces.combined";
    public static final String PARAM_NAME_DISABLED = "org.omnifaces.COMBINED_RESOURCE_HANDLER_DISABLED";
    public static final String PARAM_NAME_EXCLUDED_RESOURCES = "org.omnifaces.COMBINED_RESOURCE_HANDLER_EXCLUDED_RESOURCES";
    public static final String PARAM_NAME_SUPPRESSED_RESOURCES = "org.omnifaces.COMBINED_RESOURCE_HANDLER_SUPPRESSED_RESOURCES";
    public static final String PARAM_NAME_INLINE_CSS = "org.omnifaces.COMBINED_RESOURCE_HANDLER_INLINE_CSS";
    public static final String PARAM_NAME_INLINE_JS = "org.omnifaces.COMBINED_RESOURCE_HANDLER_INLINE_JS";
    public static final String PARAM_NAME_CACHE_TTL = "org.omnifaces.COMBINED_RESOURCE_HANDLER_CACHE_TTL";
    private static final String ERROR_INVALID_CACHE_TTL_PARAM = "Context parameter 'org.omnifaces.COMBINED_RESOURCE_HANDLER_CACHE_TTL' is in invalid syntax. It must represent a valid time in seconds between 0 and 2147483647. Encountered an invalid value of '%s'.";
    private static final String TARGET_HEAD = "head";
    private static final String TARGET_BODY = "body";
    private String disabledParam = Faces.getInitParameter("org.omnifaces.COMBINED_RESOURCE_HANDLER_DISABLED");
    private Set<ResourceIdentifier> excludedResources = CombinedResourceHandler.initResources("org.omnifaces.COMBINED_RESOURCE_HANDLER_EXCLUDED_RESOURCES");
    private Set<ResourceIdentifier> suppressedResources;
    private boolean inlineCSS;
    private boolean inlineJS;
    private Integer cacheTTL;

    public CombinedResourceHandler(ResourceHandler wrapped) {
        super(wrapped);
        this.excludedResources.addAll(CombinedResourceHandler.initCDNResources());
        this.suppressedResources = CombinedResourceHandler.initResources(PARAM_NAME_SUPPRESSED_RESOURCES);
        this.excludedResources.addAll(this.suppressedResources);
        this.inlineCSS = Boolean.valueOf(Faces.getInitParameter(PARAM_NAME_INLINE_CSS));
        this.inlineJS = Boolean.valueOf(Faces.getInitParameter(PARAM_NAME_INLINE_JS));
        this.cacheTTL = CombinedResourceHandler.initCacheTTL(Faces.getInitParameter(PARAM_NAME_CACHE_TTL));
        Events.subscribeToApplicationEvent(PreRenderViewEvent.class, this);
    }

    public boolean isListenerForSource(Object source) {
        return source instanceof UIViewRoot;
    }

    public void processEvent(SystemEvent event) throws AbortProcessingException {
        if (this.disabledParam != null && Boolean.valueOf(String.valueOf(Faces.evaluateExpressionGet(this.disabledParam))).booleanValue()) {
            return;
        }
        FacesContext context = FacesContext.getCurrentInstance();
        UIViewRoot view = context.getViewRoot();
        CombinedResourceBuilder builder = new CombinedResourceBuilder();
        for (UIComponent component : view.getComponentResources(context, TARGET_HEAD)) {
            if (component.getAttributes().get("name") == null) continue;
            builder.add(context, component, component.getRendererType(), new ResourceIdentifier(component), TARGET_HEAD);
        }
        for (UIComponent component : view.getComponentResources(context, TARGET_BODY)) {
            if (!(component instanceof DeferredScript)) continue;
            builder.add(context, component, component.getRendererType(), new ResourceIdentifier(component), TARGET_BODY);
        }
        builder.create(context);
    }

    @Override
    public String getLibraryName() {
        return LIBRARY_NAME;
    }

    @Override
    public Resource createResourceFromLibrary(String resourceName, String contentType) {
        return new CombinedResource(resourceName, this.cacheTTL);
    }

    private static Set<ResourceIdentifier> initResources(String name) {
        HashSet<ResourceIdentifier> resources = new HashSet<ResourceIdentifier>(1);
        String configuredResources = Faces.getInitParameter(name);
        if (configuredResources != null) {
            for (String resourceIdentifier : configuredResources.split("\\s*,\\s*")) {
                resources.add(new ResourceIdentifier(resourceIdentifier));
            }
        }
        return resources;
    }

    private static Set<ResourceIdentifier> initCDNResources() {
        Map<ResourceIdentifier, String> cdnResources = CDNResourceHandler.initCDNResources();
        return cdnResources != null ? cdnResources.keySet() : Collections.emptySet();
    }

    private static Integer initCacheTTL(String cacheTTLParam) {
        if (!Faces.isDevelopment() && cacheTTLParam != null) {
            int cacheTTL;
            if (Utils.isNumber(cacheTTLParam) && (cacheTTL = Integer.valueOf(cacheTTLParam).intValue()) > 0) {
                return cacheTTL;
            }
            throw new IllegalArgumentException(String.format(ERROR_INVALID_CACHE_TTL_PARAM, cacheTTLParam));
        }
        return null;
    }

    private static void removeComponentResources(FacesContext context, List<UIComponent> componentResourcesToRemove, String target) {
        UIViewRoot view = context.getViewRoot();
        for (UIComponent resourceToRemove : componentResourcesToRemove) {
            if (resourceToRemove == null) continue;
            view.removeComponentResource(context, resourceToRemove, target);
        }
    }

    private final class CombinedResourceBuilder {
        private static final String RENDERER_TYPE_CSS = "javax.faces.resource.Stylesheet";
        private static final String RENDERER_TYPE_JS = "javax.faces.resource.Script";
        private static final String EXTENSION_CSS = ".css";
        private static final String EXTENSION_JS = ".js";
        private CombinedResourceBuilder stylesheets;
        private CombinedResourceBuilder scripts;
        private Map<String, CombinedResourceBuilder> deferredScripts;
        private List<UIComponent> componentResourcesToRemove;
        private String extension;
        private String target;
        private CombinedResourceInfo.Builder infoBuilder;
        private UIComponent componentResource;

        public CombinedResourceBuilder() {
            this.stylesheets = new CombinedResourceBuilder(EXTENSION_CSS, CombinedResourceHandler.TARGET_HEAD);
            this.scripts = new CombinedResourceBuilder(EXTENSION_JS, CombinedResourceHandler.TARGET_HEAD);
            this.deferredScripts = new LinkedHashMap<String, CombinedResourceBuilder>();
            this.componentResourcesToRemove = new ArrayList<UIComponent>();
        }

        private void add(FacesContext context, UIComponent component, String rendererType, ResourceIdentifier id, String target) {
            if (CombinedResourceHandler.LIBRARY_NAME.equals(id.getLibrary())) {
                this.addCombined(context, component, rendererType, id, target);
            } else if (rendererType.equals(RENDERER_TYPE_CSS)) {
                this.addStylesheet(context, component, id);
            } else if (rendererType.equals(RENDERER_TYPE_JS)) {
                this.addScript(context, component, id);
            } else if (component instanceof DeferredScript) {
                this.addDeferredScript(component, id);
            } else if (Hacks.isRichFacesResourceLibraryRenderer(rendererType)) {
                Set<ResourceIdentifier> resourceIdentifiers = Hacks.getRichFacesResourceLibraryResources(id);
                ResourceHandler handler = context.getApplication().getResourceHandler();
                for (ResourceIdentifier identifier : resourceIdentifiers) {
                    this.add(context, null, handler.getRendererTypeForResourceName(identifier.getName()), identifier, target);
                }
                this.componentResourcesToRemove.add(component);
            }
        }

        private void addCombined(FacesContext context, UIComponent component, String rendererType, ResourceIdentifier id, String target) {
            String[] resourcePathParts = id.getName().split("\\.", 2)[0].split("/");
            String resourceId = resourcePathParts[resourcePathParts.length - 1];
            CombinedResourceInfo info = CombinedResourceInfo.get(resourceId);
            if (info != null) {
                for (ResourceIdentifier combinedId : info.getResourceIdentifiers()) {
                    this.add(context, null, rendererType, combinedId, target);
                }
            }
            this.componentResourcesToRemove.add(component);
        }

        private void addStylesheet(FacesContext context, UIComponent component, ResourceIdentifier id) {
            if (this.stylesheets.add(component, id)) {
                Hacks.setStylesheetResourceRendered(context, id);
            }
        }

        private void addScript(FacesContext context, UIComponent component, ResourceIdentifier id) {
            if (Hacks.isScriptResourceRendered(context, id)) {
                this.componentResourcesToRemove.add(component);
            } else if (this.scripts.add(component, id)) {
                Hacks.setScriptResourceRendered(context, id);
            }
        }

        private void addDeferredScript(UIComponent component, ResourceIdentifier id) {
            String group = (String)component.getAttributes().get("group");
            CombinedResourceBuilder builder = this.deferredScripts.get(group);
            if (builder == null) {
                builder = new CombinedResourceBuilder(EXTENSION_JS, CombinedResourceHandler.TARGET_BODY);
                this.deferredScripts.put(group, builder);
            }
            builder.add(component, id);
        }

        public void create(FacesContext context) {
            this.stylesheets.create(context, CombinedResourceHandler.this.inlineCSS ? "org.omnifaces.InlineStylesheet" : RENDERER_TYPE_CSS);
            this.scripts.create(context, CombinedResourceHandler.this.inlineJS ? "org.omnifaces.InlineScript" : RENDERER_TYPE_JS);
            for (CombinedResourceBuilder builder : this.deferredScripts.values()) {
                builder.create(context, "org.omnifaces.DeferredScript");
            }
            CombinedResourceHandler.removeComponentResources(context, this.componentResourcesToRemove, CombinedResourceHandler.TARGET_HEAD);
        }

        private CombinedResourceBuilder(String extension, String target) {
            this.extension = extension;
            this.target = target;
            this.infoBuilder = new CombinedResourceInfo.Builder();
            this.componentResourcesToRemove = new ArrayList<UIComponent>();
        }

        private boolean add(UIComponent componentResource, ResourceIdentifier resourceIdentifier) {
            if (componentResource != null && !componentResource.isRendered()) {
                this.componentResourcesToRemove.add(componentResource);
                return true;
            }
            if (CombinedResourceHandler.this.excludedResources.isEmpty() || !CombinedResourceHandler.this.excludedResources.contains(resourceIdentifier)) {
                this.infoBuilder.add(resourceIdentifier);
                if (this.componentResource == null) {
                    this.componentResource = componentResource;
                } else {
                    if (componentResource instanceof DeferredScript) {
                        this.mergeAttribute(this.componentResource, componentResource, "onbegin");
                        this.mergeAttribute(this.componentResource, componentResource, "onsuccess");
                        this.mergeAttribute(this.componentResource, componentResource, "onerror");
                    }
                    this.componentResourcesToRemove.add(componentResource);
                }
                return true;
            }
            if (CombinedResourceHandler.this.suppressedResources.contains(resourceIdentifier)) {
                this.componentResourcesToRemove.add(componentResource);
                return true;
            }
            return false;
        }

        private void mergeAttribute(UIComponent originalComponent, UIComponent newComponent, String name) {
            String originalAttribute = this.getAttribute(originalComponent, name);
            String newAttribute = this.getAttribute(newComponent, name);
            String separator = originalAttribute.isEmpty() || originalAttribute.endsWith(";") ? "" : ";";
            originalComponent.getAttributes().put(name, originalAttribute + separator + newAttribute);
        }

        private String getAttribute(UIComponent component, String name) {
            String attribute = (String)component.getAttributes().get(name);
            return attribute == null ? "" : attribute.trim();
        }

        private void create(FacesContext context, String rendererType) {
            if (!this.infoBuilder.isEmpty()) {
                if (this.componentResource == null) {
                    this.componentResource = new UIOutput();
                    context.getViewRoot().addComponentResource(context, this.componentResource, this.target);
                }
                this.componentResource.getAttributes().put("library", CombinedResourceHandler.LIBRARY_NAME);
                this.componentResource.getAttributes().put("name", this.infoBuilder.create() + this.extension);
                this.componentResource.setRendererType(rendererType);
            }
            CombinedResourceHandler.removeComponentResources(context, this.componentResourcesToRemove, this.target);
        }
    }
}

