/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.resourcehandler;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.faces.context.FacesContext;
import org.omnifaces.component.output.cache.Cache;
import org.omnifaces.component.output.cache.CacheFactory;
import org.omnifaces.resourcehandler.CombinedResourceHandler;
import org.omnifaces.resourcehandler.CombinedResourceInfo;
import org.omnifaces.resourcehandler.CombinedResourceInputStream;
import org.omnifaces.resourcehandler.DynamicResource;
import org.omnifaces.util.Faces;
import org.omnifaces.util.Utils;

public class CombinedResource
extends DynamicResource {
    private static final String CACHE_SCOPE = "application";
    private String resourceId;
    private CombinedResourceInfo info;
    private Integer cacheTTL;

    public CombinedResource(String resourceName, Integer cacheTTL) {
        super(resourceName, "omnifaces.combined", Faces.getMimeType(resourceName));
        String[] resourcePathParts = resourceName.split("\\.", 2)[0].split("/");
        this.resourceId = resourcePathParts[resourcePathParts.length - 1];
        this.info = CombinedResourceInfo.get(this.resourceId);
        this.cacheTTL = cacheTTL;
    }

    @Override
    public long getLastModified() {
        return this.info != null ? this.info.getLastModified() : super.getLastModified();
    }

    public InputStream getInputStream() throws IOException {
        if (this.info != null && !this.info.getResources().isEmpty()) {
            if (this.cacheTTL == null) {
                return new CombinedResourceInputStream(this.info.getResources());
            }
            return this.getInputStreamFromCache();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private InputStream getInputStreamFromCache() throws IOException {
        Cache combinedResourceCache = CacheFactory.getCache(FacesContext.getCurrentInstance(), CACHE_SCOPE);
        Class<CombinedResourceHandler> clazz = CombinedResourceHandler.class;
        synchronized (CombinedResourceHandler.class) {
            byte[] cachedCombinedResource = (byte[])combinedResourceCache.getObject(this.resourceId);
            // ** MonitorExit[var3_2] (shouldn't be in output)
            if (cachedCombinedResource != null) return new ByteArrayInputStream(cachedCombinedResource);
            cachedCombinedResource = Utils.toByteArray(new CombinedResourceInputStream(this.info.getResources()));
            clazz = CombinedResourceHandler.class;
            synchronized (CombinedResourceHandler.class) {
                if (combinedResourceCache.getObject(this.resourceId) != null) return new ByteArrayInputStream(cachedCombinedResource);
                combinedResourceCache.putObject(this.resourceId, cachedCombinedResource, this.cacheTTL);
                // ** MonitorExit[var3_2] (shouldn't be in output)
                return new ByteArrayInputStream(cachedCombinedResource);
            }
        }
    }
}

