/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.renderkit;

import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.faces.component.UICommand;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.component.UIInput;
import javax.faces.component.UISelectBoolean;
import javax.faces.component.UISelectMany;
import javax.faces.component.UISelectOne;
import javax.faces.component.html.HtmlInputSecret;
import javax.faces.component.html.HtmlInputText;
import javax.faces.component.html.HtmlInputTextarea;
import javax.faces.context.ResponseWriter;
import javax.faces.context.ResponseWriterWrapper;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitWrapper;
import org.omnifaces.util.Components;
import org.omnifaces.util.Faces;
import org.omnifaces.util.Utils;

public class Html5RenderKit
extends RenderKitWrapper {
    public static final String PARAM_NAME_PASSTHROUGH_ATTRIBUTES = "org.omnifaces.HTML5_RENDER_KIT_PASSTHROUGH_ATTRIBUTES";
    private static final Set<String> HTML5_UIFORM_ATTRIBUTES = Utils.unmodifiableSet("autocomplete");
    private static final Set<String> HTML5_SELECT_ATTRIBUTES = Utils.unmodifiableSet("autofocus");
    private static final Set<String> HTML5_TEXTAREA_ATTRIBUTES = Utils.unmodifiableSet("autofocus", "maxlength", "placeholder", "spellcheck", "wrap");
    private static final Set<String> HTML5_INPUT_ATTRIBUTES = Utils.unmodifiableSet("autofocus", "list", "pattern", "placeholder", "spellcheck");
    private static final Set<String> HTML5_INPUT_PASSWORD_ATTRIBUTES = Utils.unmodifiableSet("autofocus", "pattern", "placeholder");
    private static final Set<String> HTML5_INPUT_RANGE_ATTRIBUTES = Utils.unmodifiableSet("max", "min", "step");
    private static final Set<String> HTML5_INPUT_RANGE_TYPES = Utils.unmodifiableSet("range", "number", "date");
    private static final Set<String> HTML5_INPUT_TYPES = Utils.unmodifiableSet("text", "search", "email", "url", "tel", HTML5_INPUT_RANGE_TYPES);
    private static final Set<String> HTML5_BUTTON_ATTRIBUTES = Utils.unmodifiableSet("autofocus");
    private static final String ERROR_INVALID_INIT_PARAM = "Context parameter 'org.omnifaces.HTML5_RENDER_KIT_PASSTHROUGH_ATTRIBUTES' is in invalid syntax.";
    private static final String ERROR_INVALID_INIT_PARAM_CLASS = "Context parameter 'org.omnifaces.HTML5_RENDER_KIT_PASSTHROUGH_ATTRIBUTES' references a class which is not found in runtime classpath: '%s'";
    private static final String ERROR_UNSUPPORTED_HTML5_INPUT_TYPE = "HtmlInputText type '%s' is not supported. Supported types are " + HTML5_INPUT_TYPES + ".";
    private RenderKit wrapped;
    private Map<Class<UIComponent>, Set<String>> passthroughAttributes;

    public Html5RenderKit(RenderKit wrapped) {
        this.wrapped = wrapped;
        this.passthroughAttributes = Html5RenderKit.initPassthroughAttributes();
    }

    public ResponseWriter createResponseWriter(Writer writer, String contentTypeList, String characterEncoding) {
        return new Html5ResponseWriter(super.createResponseWriter(writer, contentTypeList, characterEncoding));
    }

    public RenderKit getWrapped() {
        return this.wrapped;
    }

    private static Map<Class<UIComponent>, Set<String>> initPassthroughAttributes() {
        String passthroughAttributesParam = Faces.getInitParameter(PARAM_NAME_PASSTHROUGH_ATTRIBUTES);
        if (Utils.isEmpty(passthroughAttributesParam)) {
            return null;
        }
        HashMap<Class<UIComponent>, Set<String>> passthroughAttributes = new HashMap<Class<UIComponent>, Set<String>>();
        for (String passthroughAttribute : passthroughAttributesParam.split("\\s*;\\s*")) {
            String[] classAndAttributeNames = passthroughAttribute.split("\\s*=\\s*", 2);
            if (classAndAttributeNames.length != 2) {
                throw new IllegalArgumentException(ERROR_INVALID_INIT_PARAM);
            }
            String className = classAndAttributeNames[0];
            Object[] attributeNames = classAndAttributeNames[1].split("\\s*,\\s*");
            Set attributeNameSet = Utils.unmodifiableSet(attributeNames);
            try {
                passthroughAttributes.put(Class.forName(className), attributeNameSet);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException(String.format(ERROR_INVALID_INIT_PARAM_CLASS, className), e);
            }
        }
        return passthroughAttributes;
    }

    class Html5ResponseWriter
    extends ResponseWriterWrapper {
        private ResponseWriter wrapped;

        public Html5ResponseWriter(ResponseWriter wrapped) {
            this.wrapped = wrapped;
        }

        public ResponseWriter cloneWithWriter(Writer writer) {
            return new Html5ResponseWriter(super.cloneWithWriter(writer));
        }

        public void startElement(String name, UIComponent component) throws IOException {
            super.startElement(name, component);
            if (component == null) {
                return;
            }
            if (component instanceof UIForm && "form".equals(name)) {
                this.writeHtml5AttributesIfNecessary(component.getAttributes(), HTML5_UIFORM_ATTRIBUTES);
            } else if (component instanceof UIInput) {
                this.writeHtml5AttributesIfNecessary((UIInput)component, name);
            } else if (component instanceof UICommand && "input".equals(name)) {
                this.writeHtml5AttributesIfNecessary(component.getAttributes(), HTML5_BUTTON_ATTRIBUTES);
            }
            if (Html5RenderKit.this.passthroughAttributes != null) {
                for (Map.Entry entry : Html5RenderKit.this.passthroughAttributes.entrySet()) {
                    if (!((Class)entry.getKey()).isInstance(component)) continue;
                    this.writeHtml5AttributesIfNecessary(component.getAttributes(), (Set)entry.getValue());
                }
            }
        }

        public void writeAttribute(String name, Object value, String property) throws IOException {
            Object type;
            UIComponent component;
            if ("type".equals(name) && "text".equals(value) && (component = Components.getCurrentComponent()) instanceof HtmlInputText && (type = component.getAttributes().get("type")) != null) {
                if (HTML5_INPUT_TYPES.contains(type)) {
                    super.writeAttribute(name, type, null);
                    return;
                }
                throw new IllegalArgumentException(String.format(ERROR_UNSUPPORTED_HTML5_INPUT_TYPE, type));
            }
            super.writeAttribute(name, value, property);
        }

        public ResponseWriter getWrapped() {
            return this.wrapped;
        }

        private void writeHtml5AttributesIfNecessary(UIInput component, String name) throws IOException {
            if (this.isInput(component, name)) {
                Map attributes = component.getAttributes();
                this.writeHtml5AttributesIfNecessary(attributes, HTML5_INPUT_ATTRIBUTES);
                if (HTML5_INPUT_RANGE_TYPES.contains(attributes.get("type"))) {
                    this.writeHtml5AttributesIfNecessary(attributes, HTML5_INPUT_RANGE_ATTRIBUTES);
                }
            } else if (this.isInputPassword(component, name)) {
                this.writeHtml5AttributesIfNecessary(component.getAttributes(), HTML5_INPUT_PASSWORD_ATTRIBUTES);
            } else if (this.isTextarea(component, name)) {
                this.writeHtml5AttributesIfNecessary(component.getAttributes(), HTML5_TEXTAREA_ATTRIBUTES);
            } else if (this.isSelect(component, name)) {
                this.writeHtml5AttributesIfNecessary(component.getAttributes(), HTML5_SELECT_ATTRIBUTES);
            }
        }

        private void writeHtml5AttributesIfNecessary(Map<String, Object> attributes, Set<String> names) throws IOException {
            for (String name : names) {
                Object value = attributes.get(name);
                if (value == null) continue;
                super.writeAttribute(name, value, null);
            }
        }

        private boolean isInput(UIInput component, String name) {
            return component instanceof HtmlInputText && "input".equals(name);
        }

        private boolean isInputPassword(UIInput component, String name) {
            return component instanceof HtmlInputSecret && "input".equals(name);
        }

        private boolean isTextarea(UIInput component, String name) {
            return component instanceof HtmlInputTextarea && "textarea".equals(name);
        }

        private boolean isSelect(UIInput component, String name) {
            return Utils.isOneInstanceOf(component.getClass(), UISelectBoolean.class, UISelectOne.class, UISelectMany.class) && ("input".equals(name) || "select".equals(name));
        }
    }
}

