/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.renderer;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import javax.faces.application.Resource;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.Renderer;

public abstract class InlineResourceRenderer
extends Renderer {
    public boolean getRendersChildren() {
        return true;
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String name = (String)component.getAttributes().get("name");
        String library = (String)component.getAttributes().get("library");
        Resource resource = context.getApplication().getResourceHandler().createResource(name, library);
        this.startElement(writer, component);
        try (InputStreamReader reader = new InputStreamReader(resource.getInputStream(), writer.getCharacterEncoding());){
            this.writeResource(reader, writer);
        }
        this.endElement(writer);
    }

    public abstract void startElement(ResponseWriter var1, UIComponent var2) throws IOException;

    public abstract void writeResource(Reader var1, ResponseWriter var2) throws IOException;

    public abstract void endElement(ResponseWriter var1) throws IOException;
}

