/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.facesviews;

import java.io.IOException;
import java.util.Map;
import javax.faces.application.ProjectStage;
import javax.servlet.FilterChain;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.omnifaces.facesviews.ExtensionAction;
import org.omnifaces.facesviews.FacesServletDispatchMethod;
import org.omnifaces.facesviews.FacesViews;
import org.omnifaces.facesviews.PathAction;
import org.omnifaces.facesviews.UriExtensionRequestWrapper;
import org.omnifaces.filter.HttpFilter;
import org.omnifaces.util.Faces;
import org.omnifaces.util.ResourcePaths;
import org.omnifaces.util.Servlets;

public class FacesViewsForwardingFilter
extends HttpFilter {
    private ExtensionAction extensionAction;
    private PathAction pathAction;
    private FacesServletDispatchMethod dispatchMethod;

    @Override
    public void init() throws ServletException {
        ServletContext servletContext = this.getServletContext();
        try {
            this.extensionAction = FacesViews.getExtensionAction(servletContext);
            this.pathAction = FacesViews.getPathAction(servletContext);
            this.dispatchMethod = FacesViews.getFacesServletDispatchMethod(servletContext);
        }
        catch (IllegalStateException e) {
            throw new ServletException((Throwable)e);
        }
    }

    @Override
    public void doFilter(HttpServletRequest request, HttpServletResponse response, HttpSession session, FilterChain chain) throws ServletException, IOException {
        String resource = request.getServletPath();
        if (this.filterExtensionLess(request, response, chain, resource)) {
            return;
        }
        if (this.filterExtension(request, response, resource)) {
            return;
        }
        if (this.filterPublicPath(request, response, resource)) {
            return;
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean filterExtensionLess(HttpServletRequest request, HttpServletResponse response, FilterChain chain, String resource) throws IOException, ServletException {
        block9: {
            if (!ResourcePaths.isExtensionless(resource)) {
                return false;
            }
            Map<String, String> resources = (Map<String, String>)Servlets.getApplicationAttribute(this.getServletContext(), "org.omnifaces.facesviews");
            if (Faces.getApplicationFromFactory().getProjectStage() == ProjectStage.Development && !resources.containsKey(resource)) {
                resources = FacesViews.scanAndStoreViews(this.getServletContext());
            }
            if (!resources.containsKey(resource)) break block9;
            String extension = ResourcePaths.getExtension((String)resources.get(resource));
            switch (this.dispatchMethod) {
                case DO_FILTER: {
                    try {
                        request.setAttribute("org.omnifaces.facesviews.original.servlet_path", (Object)request.getServletPath());
                        chain.doFilter((ServletRequest)new UriExtensionRequestWrapper(request, extension), (ServletResponse)response);
                    }
                    finally {
                        request.removeAttribute("org.omnifaces.facesviews.original.servlet_path");
                    }
                    return true;
                }
                case FORWARD: {
                    RequestDispatcher requestDispatcher = this.getServletContext().getRequestDispatcher(resource + extension);
                    if (requestDispatcher == null) break;
                    requestDispatcher.forward((ServletRequest)request, (ServletResponse)response);
                    return true;
                }
            }
        }
        return false;
    }

    private boolean filterExtension(HttpServletRequest request, HttpServletResponse response, String resource) throws IOException {
        Map resources = (Map)Servlets.getApplicationAttribute(this.getServletContext(), "org.omnifaces.facesviews");
        if (resources.containsKey(resource)) {
            switch (this.extensionAction) {
                case REDIRECT_TO_EXTENSIONLESS: {
                    FacesViewsForwardingFilter.redirectPermanent(response, FacesViews.getExtensionlessURLWithQuery(request));
                    return true;
                }
                case SEND_404: {
                    response.sendError(404);
                    return true;
                }
                case PROCEED: {
                    break;
                }
            }
        }
        return false;
    }

    private boolean filterPublicPath(HttpServletRequest request, HttpServletResponse response, String resource) throws IOException {
        if (!FacesViews.isResourceInPublicPath(this.getServletContext(), resource)) {
            return false;
        }
        Map reverseResources = (Map)Servlets.getApplicationAttribute(this.getServletContext(), "org.omnifaces.facesviews.reverse.resources");
        if (reverseResources.containsKey(resource)) {
            switch (this.pathAction) {
                case REDIRECT_TO_SCANNED_EXTENSIONLESS: {
                    FacesViewsForwardingFilter.redirectPermanent(response, FacesViews.getExtensionlessURLWithQuery(request, (String)reverseResources.get(resource)));
                    return true;
                }
                case SEND_404: {
                    response.sendError(404);
                    return true;
                }
                case PROCEED: {
                    break;
                }
            }
        }
        return false;
    }

    private static void redirectPermanent(HttpServletResponse response, String url) {
        response.setStatus(301);
        response.setHeader("Location", url);
        response.setHeader("Connection", "close");
    }
}

