/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.exceptionhandler;

import java.io.IOException;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExceptionHandler;
import javax.faces.context.ExceptionHandlerWrapper;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ExceptionQueuedEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PreRenderViewEvent;
import javax.faces.view.ViewDeclarationLanguage;
import javax.servlet.http.HttpServletRequest;
import org.omnifaces.config.WebXml;
import org.omnifaces.context.OmniPartialViewContext;
import org.omnifaces.util.Exceptions;
import org.omnifaces.util.Faces;
import org.omnifaces.util.FacesLocal;
import org.omnifaces.util.Hacks;

public class FullAjaxExceptionHandler
extends ExceptionHandlerWrapper {
    private static final Logger logger = Logger.getLogger(FullAjaxExceptionHandler.class.getName());
    private static final String ERROR_DEFAULT_LOCATION_MISSING = "Either HTTP 500 or java.lang.Throwable error page is required in web.xml or web-fragment.xml. Neither was found.";
    private static final String LOG_EXCEPTION_HANDLED = "FullAjaxExceptionHandler: An exception occurred during processing JSF ajax request. Error page '%s' will be shown.";
    private static final String LOG_RENDER_EXCEPTION_HANDLED = "FullAjaxExceptionHandler: An exception occurred during rendering JSF ajax response. Error page '%s' will be shown.";
    private static final String LOG_RENDER_EXCEPTION_UNHANDLED = "FullAjaxExceptionHandler: An exception occurred during rendering JSF ajax response. Error page '%s' CANNOT be shown as response is already committed. Consider increasing 'javax.faces.FACELETS_BUFFER_SIZE' if it really needs to be handled.";
    private static final String LOG_ERROR_PAGE_ERROR = "FullAjaxExceptionHandler: Well, another exception occurred during rendering error page '%s'. Trying to render a hardcoded error page now.";
    private static final String ERROR_PAGE_ERROR = "<?xml version='1.0' encoding='UTF-8'?><partial-response id='error'><changes><update id='javax.faces.ViewRoot'><![CDATA[<html lang='en'><head><title>Error in error</title></head><body><section><h2>Oops!</h2><p>A problem occurred during processing the ajax request. Subsequently, another problem occurred during processing the error page which should inform you about that problem.</p><p>If you are the responsible web developer, it's time to read the server logs about the bug in the error page itself.</p></section></body></html>]]></update></changes></partial-response>";
    private ExceptionHandler wrapped;

    public FullAjaxExceptionHandler(ExceptionHandler wrapped) {
        this.wrapped = wrapped;
    }

    public void handle() throws FacesException {
        this.handleAjaxException(Faces.getContext());
        this.wrapped.handle();
    }

    private void handleAjaxException(FacesContext context) {
        if (context == null || !context.getPartialViewContext().isAjaxRequest()) {
            return;
        }
        Iterator unhandledExceptionQueuedEvents = this.getUnhandledExceptionQueuedEvents().iterator();
        if (!unhandledExceptionQueuedEvents.hasNext()) {
            return;
        }
        Throwable exception = ((ExceptionQueuedEvent)unhandledExceptionQueuedEvents.next()).getContext().getException();
        if (exception instanceof AbortProcessingException) {
            return;
        }
        if (!this.shouldHandleExceptionRootCause(context, exception = this.findExceptionRootCause(context, exception))) {
            return;
        }
        String errorPageLocation = this.findErrorPageLocation(context, exception);
        if (errorPageLocation == null) {
            throw new IllegalArgumentException(ERROR_DEFAULT_LOCATION_MISSING);
        }
        unhandledExceptionQueuedEvents.remove();
        if (!this.canRenderErrorPageView(context, exception, errorPageLocation)) {
            return;
        }
        HttpServletRequest request = FacesLocal.getRequest(context);
        request.setAttribute("javax.servlet.error.exception", (Object)exception);
        request.setAttribute("javax.servlet.error.exception_type", exception.getClass());
        request.setAttribute("javax.servlet.error.message", (Object)exception.getMessage());
        request.setAttribute("javax.servlet.error.request_uri", (Object)request.getRequestURI());
        request.setAttribute("javax.servlet.error.status_code", (Object)500);
        try {
            this.renderErrorPageView(context, request, errorPageLocation);
        }
        catch (IOException e) {
            throw new FacesException((Throwable)e);
        }
        while (unhandledExceptionQueuedEvents.hasNext()) {
            unhandledExceptionQueuedEvents.next();
            unhandledExceptionQueuedEvents.remove();
        }
    }

    protected Throwable findExceptionRootCause(FacesContext context, Throwable exception) {
        return Exceptions.unwrap(exception);
    }

    protected boolean shouldHandleExceptionRootCause(FacesContext context, Throwable exception) {
        return true;
    }

    protected String findErrorPageLocation(FacesContext context, Throwable exception) {
        return WebXml.INSTANCE.findErrorPageLocation(exception);
    }

    protected void logException(FacesContext context, Throwable exception, String location, String message, Object ... parameters) {
        logger.log(Level.SEVERE, String.format(message, location), exception);
    }

    private boolean canRenderErrorPageView(FacesContext context, Throwable exception, String errorPageLocation) {
        if (context.getCurrentPhaseId() != PhaseId.RENDER_RESPONSE) {
            this.logException(context, exception, errorPageLocation, LOG_EXCEPTION_HANDLED, new Object[0]);
            return true;
        }
        if (!context.getExternalContext().isResponseCommitted()) {
            this.logException(context, exception, errorPageLocation, LOG_RENDER_EXCEPTION_HANDLED, new Object[0]);
            this.resetResponse(context);
            return true;
        }
        this.logException(context, exception, errorPageLocation, LOG_RENDER_EXCEPTION_UNHANDLED, new Object[0]);
        OmniPartialViewContext.getCurrentInstance(context).closePartialResponse();
        return false;
    }

    private void resetResponse(FacesContext context) {
        ExternalContext externalContext = context.getExternalContext();
        String contentType = externalContext.getResponseContentType();
        String characterEncoding = externalContext.getResponseCharacterEncoding();
        externalContext.responseReset();
        OmniPartialViewContext.getCurrentInstance(context).resetPartialResponse();
        externalContext.setResponseContentType(contentType);
        externalContext.setResponseCharacterEncoding(characterEncoding);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderErrorPageView(FacesContext context, HttpServletRequest request, String errorPageLocation) throws IOException {
        block6: {
            String viewId = this.getViewIdAndPrepareParamsIfNecessary(context, errorPageLocation);
            ViewHandler viewHandler = context.getApplication().getViewHandler();
            UIViewRoot viewRoot = viewHandler.createView(context, viewId);
            context.setViewRoot(viewRoot);
            context.getPartialViewContext().setRenderAll(true);
            Hacks.removeResourceDependencyState(context);
            try {
                ViewDeclarationLanguage vdl = viewHandler.getViewDeclarationLanguage(context, viewId);
                vdl.buildView(context, viewRoot);
                context.getApplication().publishEvent(context, PreRenderViewEvent.class, (Object)viewRoot);
                vdl.renderView(context, viewRoot);
                context.responseComplete();
            }
            catch (Exception e) {
                this.logException(context, e, errorPageLocation, LOG_ERROR_PAGE_ERROR, new Object[0]);
                ExternalContext externalContext = context.getExternalContext();
                if (!externalContext.isResponseCommitted()) {
                    this.resetResponse(context);
                    externalContext.setResponseContentType("text/xml");
                    externalContext.getResponseOutputWriter().write(ERROR_PAGE_ERROR);
                    context.responseComplete();
                    break block6;
                }
                throw new FacesException((Throwable)e);
            }
            finally {
                request.removeAttribute("javax.servlet.error.exception");
            }
        }
    }

    private String getViewIdAndPrepareParamsIfNecessary(FacesContext context, String errorPageLocation) {
        String[] parts = errorPageLocation.split("\\?", 2);
        return FacesLocal.normalizeViewId(context, parts[0]);
    }

    public ExceptionHandler getWrapped() {
        return this.wrapped;
    }
}

