/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.eventlistener;

import java.util.Collection;
import java.util.EnumSet;
import java.util.Set;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.visit.VisitCallback;
import javax.faces.component.visit.VisitContext;
import javax.faces.component.visit.VisitHint;
import javax.faces.component.visit.VisitResult;
import javax.faces.context.FacesContext;
import javax.faces.context.PartialViewContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.event.ActionListener;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import org.omnifaces.eventlistener.DefaultPhaseListener;
import org.omnifaces.util.Hacks;

public class ResetInputAjaxActionListener
extends DefaultPhaseListener
implements ActionListener {
    private static final long serialVersionUID = -5317382021715077662L;
    private static final Set<VisitHint> VISIT_HINTS = EnumSet.of(VisitHint.SKIP_TRANSIENT, VisitHint.SKIP_UNRENDERED);
    private static final VisitCallback VISIT_CALLBACK = new VisitCallback(){

        public VisitResult visit(VisitContext context, UIComponent target) {
            FacesContext facesContext = context.getFacesContext();
            Collection executeIds = facesContext.getPartialViewContext().getExecuteIds();
            if (executeIds.contains(target.getClientId(facesContext))) {
                return VisitResult.REJECT;
            }
            if (target instanceof EditableValueHolder) {
                ((EditableValueHolder)target).resetValue();
            } else if (context.getIdsToVisit() != VisitContext.ALL_IDS) {
                target.visitTree(VisitContext.createVisitContext((FacesContext)facesContext, null, (Set)context.getHints()), VISIT_CALLBACK);
            }
            return VisitResult.ACCEPT;
        }
    };
    private ActionListener wrapped;

    public ResetInputAjaxActionListener() {
        this((ActionListener)null);
    }

    public ResetInputAjaxActionListener(ActionListener wrapped) {
        super(PhaseId.INVOKE_APPLICATION);
        this.wrapped = wrapped;
    }

    @Override
    public void beforePhase(PhaseEvent event) {
        this.processAction(null);
    }

    public void processAction(ActionEvent event) throws AbortProcessingException {
        Collection<String> renderIds;
        FacesContext context = FacesContext.getCurrentInstance();
        PartialViewContext partialViewContext = context.getPartialViewContext();
        if (partialViewContext.isAjaxRequest() && !(renderIds = ResetInputAjaxActionListener.getRenderIds(partialViewContext)).isEmpty() && !partialViewContext.getExecuteIds().containsAll(renderIds)) {
            context.getViewRoot().visitTree(VisitContext.createVisitContext((FacesContext)context, renderIds, VISIT_HINTS), VISIT_CALLBACK);
        }
        if (this.wrapped != null && event != null) {
            this.wrapped.processAction(event);
        }
    }

    private static Collection<String> getRenderIds(PartialViewContext partialViewContext) {
        Collection<String> renderIds = partialViewContext.getRenderIds();
        if (renderIds.isEmpty() && Hacks.isRichFacesInstalled()) {
            renderIds = Hacks.getRichFacesRenderIds();
        }
        return renderIds;
    }
}

