/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.eventlistener;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIInput;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ComponentSystemEvent;
import javax.faces.event.PostValidateEvent;
import javax.faces.event.PreValidateEvent;
import javax.faces.event.SystemEvent;
import javax.faces.event.SystemEventListener;
import javax.faces.validator.BeanValidator;
import javax.faces.validator.Validator;

public class BeanValidationEventListener
implements SystemEventListener {
    private static final String ATTRIBUTE_ORIGINAL_VALIDATION_GROUPS = "BeanValidationEventListener.originalValidationGroups";
    private static final Logger LOGGER = Logger.getLogger(BeanValidationEventListener.class.getName());
    private static final String LOG_VALIDATION_GROUPS_OVERRIDDEN = "Validation groups for component with id '%s' overriden from '%s' to '%s'";
    private String validationGroups;
    private boolean disabled;

    public BeanValidationEventListener(String validationGroups, boolean disabled) {
        this.validationGroups = validationGroups;
        this.disabled = disabled;
    }

    public boolean isListenerForSource(Object source) {
        return source instanceof UIInput && BeanValidationEventListener.getBeanValidator((EditableValueHolder)source) != null;
    }

    public void processEvent(SystemEvent event) throws AbortProcessingException {
        if (event instanceof PreValidateEvent) {
            this.handlePreValidate((UIInput)((ComponentSystemEvent)event).getComponent());
        } else if (event instanceof PostValidateEvent) {
            this.handlePostValidate((UIInput)((ComponentSystemEvent)event).getComponent());
        }
    }

    private void handlePreValidate(UIInput component) {
        BeanValidator beanValidator = BeanValidationEventListener.getBeanValidator((EditableValueHolder)component);
        String newValidationGroups = this.disabled ? NoValidationGroup.class.getName() : this.validationGroups;
        String originalValidationGroups = beanValidator.getValidationGroups();
        if (originalValidationGroups != null) {
            component.getAttributes().put(ATTRIBUTE_ORIGINAL_VALIDATION_GROUPS, originalValidationGroups);
        }
        beanValidator.setValidationGroups(newValidationGroups);
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer(String.format(LOG_VALIDATION_GROUPS_OVERRIDDEN, component.getClientId(), originalValidationGroups, newValidationGroups));
        }
    }

    private void handlePostValidate(UIInput component) {
        BeanValidator beanValidator = BeanValidationEventListener.getBeanValidator((EditableValueHolder)component);
        String originalValidationGroups = (String)component.getAttributes().remove(ATTRIBUTE_ORIGINAL_VALIDATION_GROUPS);
        beanValidator.setValidationGroups(originalValidationGroups);
    }

    private static BeanValidator getBeanValidator(EditableValueHolder component) {
        Validator[] validators;
        for (Validator validator : validators = component.getValidators()) {
            if (!(validator instanceof BeanValidator)) continue;
            return (BeanValidator)validator;
        }
        return null;
    }

    private static interface NoValidationGroup {
    }
}

