/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.el.functions;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import org.omnifaces.util.Faces;

public final class Numbers {
    private static final int BYTES_1K = 1024;

    private Numbers() {
    }

    public static String formatBytes(Long bytes) {
        if (bytes == null) {
            return "0 B";
        }
        if (bytes < 1024L) {
            return bytes + " B";
        }
        int exp = (int)(Math.log(bytes.longValue()) / Math.log(1024.0));
        return String.format(Faces.getLocale(), "%.1f %ciB", (double)bytes.longValue() / Math.pow(1024.0, exp), Character.valueOf("KMGTPE".charAt(exp - 1)));
    }

    public static String formatCurrency(Number number, String currencySymbol) {
        if (number == null) {
            return null;
        }
        DecimalFormat formatter = (DecimalFormat)NumberFormat.getCurrencyInstance(Faces.getLocale());
        DecimalFormatSymbols symbols = formatter.getDecimalFormatSymbols();
        symbols.setCurrencySymbol(currencySymbol);
        formatter.setDecimalFormatSymbols(symbols);
        return formatter.format(number);
    }

    public static String formatNumber(Number number, String pattern) {
        if (number == null) {
            return null;
        }
        DecimalFormat formatter = (DecimalFormat)NumberFormat.getNumberInstance(Faces.getLocale());
        formatter.applyPattern(pattern);
        return formatter.format(number);
    }

    public static String formatNumberDefault(Number number) {
        if (number == null) {
            return null;
        }
        return NumberFormat.getNumberInstance(Faces.getLocale()).format(number);
    }

    public static String formatPercent(Number number) {
        if (number == null) {
            return null;
        }
        return NumberFormat.getPercentInstance(Faces.getLocale()).format(number);
    }
}

