/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.el;

import java.lang.reflect.Method;
import java.util.Set;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ELResolver;
import javax.el.MethodExpression;
import javax.el.MethodInfo;
import javax.el.MethodNotFoundException;
import javax.el.PropertyNotFoundException;
import javax.el.ValueExpression;
import javax.faces.convert.ConverterException;
import javax.faces.validator.ValidatorException;
import org.omnifaces.el.ELContextWrapper;
import org.omnifaces.el.ELResolverWrapper;
import org.omnifaces.el.ExpressionInspector;
import org.omnifaces.util.Utils;

public class MethodExpressionValueExpressionAdapter
extends MethodExpression {
    private static final long serialVersionUID = 1L;
    private static final Set<Class<? extends Throwable>> EXCEPTIONS_TO_UNWRAP = Utils.unmodifiableSet(MethodNotFoundException.class, ConverterException.class, ValidatorException.class);
    private final ValueExpression valueExpression;

    public MethodExpressionValueExpressionAdapter(ValueExpression valueExpression) {
        this.valueExpression = valueExpression;
    }

    public Object invoke(ELContext context, Object[] params) {
        try {
            return this.valueExpression.getValue((ELContext)new ValueToInvokeElContext(context, params));
        }
        catch (ELException e) {
            for (Throwable cause = e.getCause(); cause != null; cause = cause.getCause()) {
                if (!EXCEPTIONS_TO_UNWRAP.contains(cause.getClass())) continue;
                throw (RuntimeException)cause;
            }
            throw e;
        }
    }

    public MethodInfo getMethodInfo(ELContext context) {
        Method method = ExpressionInspector.getMethodReference(context, this.valueExpression).getMethod();
        return new MethodInfo(method.getName(), method.getReturnType(), (Class[])method.getParameterTypes());
    }

    public boolean isLiteralText() {
        return false;
    }

    public int hashCode() {
        return this.valueExpression.hashCode();
    }

    public String getExpressionString() {
        return this.valueExpression.getExpressionString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof MethodExpressionValueExpressionAdapter) {
            return ((MethodExpressionValueExpressionAdapter)((Object)obj)).getValueExpression().equals((Object)this.valueExpression);
        }
        return false;
    }

    public ValueExpression getValueExpression() {
        return this.valueExpression;
    }

    static class ValueToInvokeElResolver
    extends ELResolverWrapper {
        private static final Object[] EMPTY_PARAMETERS = new Object[0];
        private final Object[] callerProvidedParameters;

        public ValueToInvokeElResolver(ELResolver elResolver, Object[] callerProvidedParameters) {
            super(elResolver);
            this.callerProvidedParameters = callerProvidedParameters;
        }

        @Override
        public Object getValue(ELContext context, Object base, Object property) {
            if (base == null) {
                return super.getValue(context, null, property);
            }
            try {
                return super.getValue(context, base, property);
            }
            catch (PropertyNotFoundException ignore2) {
                Object ignore2 = null;
                try {
                    return super.invoke(context, base, property, null, this.callerProvidedParameters != null ? this.callerProvidedParameters : EMPTY_PARAMETERS);
                }
                catch (MethodNotFoundException e) {
                    throw new ELException(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    static class ValueToInvokeElContext
    extends ELContextWrapper {
        private final Object[] callerProvidedParameters;

        public ValueToInvokeElContext(ELContext elContext, Object[] callerProvidedParameters) {
            super(elContext);
            this.callerProvidedParameters = callerProvidedParameters;
        }

        @Override
        public ELResolver getELResolver() {
            return new ValueToInvokeElResolver(super.getELResolver(), this.callerProvidedParameters);
        }
    }
}

